/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.observers.InnerQueuedObserver;
import io.reactivex.rxjava3.internal.observers.InnerQueuedObserverSupport;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.ErrorMode;
import io.reactivex.rxjava3.operators.QueueDisposable;
import io.reactivex.rxjava3.operators.SimpleQueue;
import io.reactivex.rxjava3.operators.SpscLinkedArrayQueue;
import java.util.ArrayDeque;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

public final class ObservableConcatMapEager<T, R>
extends AbstractObservableWithUpstream<T, R> {
    final Function<? super T, ? extends ObservableSource<? extends R>> mapper;
    final ErrorMode errorMode;
    final int maxConcurrency;
    final int prefetch;

    public ObservableConcatMapEager(ObservableSource<T> source, Function<? super T, ? extends ObservableSource<? extends R>> mapper, ErrorMode errorMode, int maxConcurrency, int prefetch) {
        super(source);
        this.mapper = mapper;
        this.errorMode = errorMode;
        this.maxConcurrency = maxConcurrency;
        this.prefetch = prefetch;
    }

    @Override
    protected void subscribeActual(Observer<? super R> observer) {
        this.source.subscribe(new ConcatMapEagerMainObserver<T, R>(observer, this.mapper, this.maxConcurrency, this.prefetch, this.errorMode));
    }

    static final class ConcatMapEagerMainObserver<T, R>
    extends AtomicInteger
    implements Observer<T>,
    Disposable,
    InnerQueuedObserverSupport<R> {
        private static final long serialVersionUID = 8080567949447303262L;
        final Observer<? super R> downstream;
        final Function<? super T, ? extends ObservableSource<? extends R>> mapper;
        final int maxConcurrency;
        final int prefetch;
        final ErrorMode errorMode;
        final AtomicThrowable errors;
        final ArrayDeque<InnerQueuedObserver<R>> observers;
        SimpleQueue<T> queue;
        Disposable upstream;
        volatile boolean done;
        int sourceMode;
        volatile boolean cancelled;
        InnerQueuedObserver<R> current;
        int activeCount;

        ConcatMapEagerMainObserver(Observer<? super R> actual, Function<? super T, ? extends ObservableSource<? extends R>> mapper, int maxConcurrency, int prefetch, ErrorMode errorMode) {
            this.downstream = actual;
            this.mapper = mapper;
            this.maxConcurrency = maxConcurrency;
            this.prefetch = prefetch;
            this.errorMode = errorMode;
            this.errors = new AtomicThrowable();
            this.observers = new ArrayDeque();
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                if (d instanceof QueueDisposable) {
                    QueueDisposable qd = (QueueDisposable)d;
                    int m = qd.requestFusion(3);
                    if (m == 1) {
                        this.sourceMode = m;
                        this.queue = qd;
                        this.done = true;
                        this.downstream.onSubscribe(this);
                        this.drain();
                        return;
                    }
                    if (m == 2) {
                        this.sourceMode = m;
                        this.queue = qd;
                        this.downstream.onSubscribe(this);
                        return;
                    }
                }
                this.queue = new SpscLinkedArrayQueue(this.prefetch);
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T value) {
            if (this.sourceMode == 0) {
                this.queue.offer(value);
            }
            this.drain();
        }

        @Override
        public void onError(Throwable e) {
            if (this.errors.tryAddThrowableOrReport(e)) {
                this.done = true;
                this.drain();
            }
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        public void dispose() {
            if (this.cancelled) {
                return;
            }
            this.cancelled = true;
            this.upstream.dispose();
            this.errors.tryTerminateAndReport();
            this.drainAndDispose();
        }

        void drainAndDispose() {
            if (this.getAndIncrement() == 0) {
                do {
                    this.queue.clear();
                    this.disposeAll();
                } while (this.decrementAndGet() != 0);
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        void disposeAll() {
            InnerQueuedObserver<R> inner = this.current;
            if (inner != null) {
                inner.dispose();
            }
            while ((inner = this.observers.poll()) != null) {
                inner.dispose();
            }
            return;
        }

        @Override
        public void innerNext(InnerQueuedObserver<R> inner, R value) {
            inner.queue().offer(value);
            this.drain();
        }

        @Override
        public void innerError(InnerQueuedObserver<R> inner, Throwable e) {
            if (this.errors.tryAddThrowableOrReport(e)) {
                if (this.errorMode == ErrorMode.IMMEDIATE) {
                    this.upstream.dispose();
                }
                inner.setDone();
                this.drain();
            }
        }

        @Override
        public void innerComplete(InnerQueuedObserver<R> inner) {
            inner.setDone();
            this.drain();
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            missed = 1;
            q = this.queue;
            observers = this.observers;
            a = this.downstream;
            errorMode = this.errorMode;
            while (true) lbl-1000:
            // 5 sources

            {
                for (ac = --this.activeCount; ac != this.maxConcurrency; ++ac) {
                    if (this.cancelled) {
                        q.clear();
                        this.disposeAll();
                        return;
                    }
                    if (errorMode == ErrorMode.IMMEDIATE && (ex = (Throwable)this.errors.get()) != null) {
                        q.clear();
                        this.disposeAll();
                        this.errors.tryTerminateConsumer(this.downstream);
                        return;
                    }
                    try {
                        v = q.poll();
                        if (v == null) break;
                        source = Objects.requireNonNull(this.mapper.apply(v), "The mapper returned a null ObservableSource");
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        this.upstream.dispose();
                        q.clear();
                        this.disposeAll();
                        this.errors.tryAddThrowableOrReport(ex);
                        this.errors.tryTerminateConsumer(this.downstream);
                        return;
                    }
                    inner = new InnerQueuedObserver<T>(this, this.prefetch);
                    observers.offer(inner);
                    source.subscribe(inner);
                }
                this.activeCount = ac;
                if (this.cancelled) {
                    q.clear();
                    this.disposeAll();
                    return;
                }
                if (errorMode == ErrorMode.IMMEDIATE && (ex = (Throwable)this.errors.get()) != null) {
                    q.clear();
                    this.disposeAll();
                    this.errors.tryTerminateConsumer(this.downstream);
                    return;
                }
                active = this.current;
                if (active == null) {
                    if (errorMode == ErrorMode.BOUNDARY && (ex = (Throwable)this.errors.get()) != null) {
                        q.clear();
                        this.disposeAll();
                        this.errors.tryTerminateConsumer(a);
                        return;
                    }
                    d = this.done;
                    active = observers.poll();
                    v0 = empty = active == null;
                    if (d && empty) {
                        ex = (Throwable)this.errors.get();
                        if (ex != null) {
                            q.clear();
                            this.disposeAll();
                            this.errors.tryTerminateConsumer(a);
                        } else {
                            a.onComplete();
                        }
                        return;
                    }
                    if (!empty) {
                        this.current = active;
                    }
                }
                if (active != null) {
                    aq = active.queue();
                    while (true) {
                        if (this.cancelled) {
                            q.clear();
                            this.disposeAll();
                            return;
                        }
                        d = active.isDone();
                        if (errorMode == ErrorMode.IMMEDIATE && (ex = (Throwable)this.errors.get()) != null) {
                            q.clear();
                            this.disposeAll();
                            this.errors.tryTerminateConsumer(a);
                            return;
                        }
                        try {
                            w = aq.poll();
                        }
                        catch (Throwable ex) {
                            Exceptions.throwIfFatal(ex);
                            this.errors.tryAddThrowableOrReport(ex);
                            this.current = null;
                            ** continue;
                        }
                        v1 = empty = w == null;
                        if (d && empty) {
                            this.current = null;
                            --this.activeCount;
                            ** continue;
                        }
                        if (empty) break;
                        a.onNext(w);
                    }
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }
    }
}

