/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.transaction;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.RoutingHandler;
import io.undertow.server.handlers.BlockingHandler;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Deque;
import java.util.function.Function;
import javax.transaction.xa.Xid;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.InputStreamByteInput;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.Unmarshaller;
import org.wildfly.httpclient.common.ContentType;
import org.wildfly.httpclient.common.ElytronIdentityHandler;
import org.wildfly.httpclient.common.HttpMarshallerFactory;
import org.wildfly.httpclient.common.HttpServiceConfig;
import org.wildfly.httpclient.common.NoFlushByteOutput;
import org.wildfly.httpclient.transaction.HttpRemoteTransactionMessages;
import org.wildfly.httpclient.transaction.TransactionConstants;
import org.wildfly.transaction.client.ImportResult;
import org.wildfly.transaction.client.LocalTransaction;
import org.wildfly.transaction.client.LocalTransactionContext;
import org.wildfly.transaction.client.SimpleXid;

public class HttpRemoteTransactionService {
    private final LocalTransactionContext transactionContext;
    private final Function<LocalTransaction, Xid> xidResolver;
    private final HttpServiceConfig httpServiceConfig;

    public HttpRemoteTransactionService(LocalTransactionContext transactionContext, Function<LocalTransaction, Xid> xidResolver) {
        this(transactionContext, xidResolver, HttpServiceConfig.getInstance());
    }

    public HttpRemoteTransactionService(LocalTransactionContext transactionContext, Function<LocalTransaction, Xid> xidResolver, HttpServiceConfig httpServiceConfig) {
        this.transactionContext = transactionContext;
        this.xidResolver = xidResolver;
        this.httpServiceConfig = httpServiceConfig;
    }

    public HttpHandler createHandler() {
        RoutingHandler routingHandler = new RoutingHandler();
        routingHandler.add(Methods.POST, "/ut/begin", (HttpHandler)new BeginHandler());
        routingHandler.add(Methods.POST, "/ut/rollback", (HttpHandler)new UTRollbackHandler());
        routingHandler.add(Methods.POST, "/ut/commit", (HttpHandler)new UTCommitHandler());
        routingHandler.add(Methods.POST, "/xa/bc", (HttpHandler)new XABeforeCompletionHandler());
        routingHandler.add(Methods.POST, "/xa/commit", (HttpHandler)new XACommitHandler());
        routingHandler.add(Methods.POST, "/xa/forget", (HttpHandler)new XAForgetHandler());
        routingHandler.add(Methods.POST, "/xa/prep", (HttpHandler)new XAPrepHandler());
        routingHandler.add(Methods.POST, "/xa/rollback", (HttpHandler)new XARollbackHandler());
        routingHandler.add(Methods.GET, "/xa/recover", (HttpHandler)new XARecoveryHandler());
        return this.httpServiceConfig.wrap((HttpHandler)new BlockingHandler((HttpHandler)new ElytronIdentityHandler((HttpHandler)routingHandler)));
    }

    private void internalSendException(HttpServerExchange exchange, int status, Throwable e) {
        try {
            exchange.setStatusCode(status);
            exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, TransactionConstants.EXCEPTION.toString());
            Marshaller marshaller = this.httpServiceConfig.getHttpMarshallerFactory(exchange).createMarshaller();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            NoFlushByteOutput byteOutput = new NoFlushByteOutput(Marshalling.createByteOutput((OutputStream)outputStream));
            marshaller.start((ByteOutput)byteOutput);
            marshaller.writeObject((Object)e);
            marshaller.write(0);
            marshaller.finish();
            marshaller.flush();
            exchange.getResponseSender().send(ByteBuffer.wrap(outputStream.toByteArray()));
        }
        catch (IOException e1) {
            HttpRemoteTransactionMessages.MESSAGES.debugf(e, "Failed to write exception", new Object[0]);
        }
    }

    @Deprecated
    public static void sendException(HttpServerExchange exchange, int status, Throwable e) {
        try {
            exchange.setStatusCode(status);
            exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, TransactionConstants.EXCEPTION.toString());
            Marshaller marshaller = HttpServiceConfig.getInstance().getHttpMarshallerFactory(exchange).createMarshaller();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            NoFlushByteOutput byteOutput = new NoFlushByteOutput(Marshalling.createByteOutput((OutputStream)outputStream));
            marshaller.start((ByteOutput)byteOutput);
            marshaller.writeObject((Object)e);
            marshaller.write(0);
            marshaller.finish();
            marshaller.flush();
            exchange.getResponseSender().send(ByteBuffer.wrap(outputStream.toByteArray()));
        }
        catch (IOException e1) {
            HttpRemoteTransactionMessages.MESSAGES.debugf(e, "Failed to write exception", new Object[0]);
        }
    }

    class XACommitHandler
    extends AbstractTransactionHandler {
        XACommitHandler() {
        }

        @Override
        protected void handleImpl(HttpServerExchange exchange, ImportResult<LocalTransaction> transaction) throws Exception {
            Deque opc = (Deque)exchange.getQueryParameters().get("opc");
            boolean onePhase = false;
            if (opc != null && !opc.isEmpty()) {
                onePhase = Boolean.parseBoolean((String)opc.poll());
            }
            transaction.getControl().commit(onePhase);
        }
    }

    class XARollbackHandler
    extends AbstractTransactionHandler {
        XARollbackHandler() {
        }

        @Override
        protected void handleImpl(HttpServerExchange exchange, ImportResult<LocalTransaction> transaction) throws Exception {
            transaction.getControl().rollback();
        }
    }

    class XAPrepHandler
    extends AbstractTransactionHandler {
        XAPrepHandler() {
        }

        @Override
        protected void handleImpl(HttpServerExchange exchange, ImportResult<LocalTransaction> transaction) throws Exception {
            transaction.getControl().prepare();
        }
    }

    class XAForgetHandler
    extends AbstractTransactionHandler {
        XAForgetHandler() {
        }

        @Override
        protected void handleImpl(HttpServerExchange exchange, ImportResult<LocalTransaction> transaction) throws Exception {
            transaction.getControl().forget();
        }
    }

    class XABeforeCompletionHandler
    extends AbstractTransactionHandler {
        XABeforeCompletionHandler() {
        }

        @Override
        protected void handleImpl(HttpServerExchange exchange, ImportResult<LocalTransaction> transaction) throws Exception {
            transaction.getControl().beforeCompletion();
        }
    }

    class UTCommitHandler
    extends AbstractTransactionHandler {
        UTCommitHandler() {
        }

        @Override
        protected void handleImpl(HttpServerExchange exchange, ImportResult<LocalTransaction> transaction) throws Exception {
            ((LocalTransaction)transaction.getTransaction()).commit();
        }
    }

    class UTRollbackHandler
    extends AbstractTransactionHandler {
        UTRollbackHandler() {
        }

        @Override
        protected void handleImpl(HttpServerExchange exchange, ImportResult<LocalTransaction> transaction) throws Exception {
            ((LocalTransaction)transaction.getTransaction()).rollback();
        }
    }

    class XARecoveryHandler
    implements HttpHandler {
        XARecoveryHandler() {
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            try {
                String flagsStringString = exchange.getRequestHeaders().getFirst(TransactionConstants.RECOVERY_FLAGS);
                if (flagsStringString == null) {
                    exchange.setStatusCode(400);
                    HttpRemoteTransactionMessages.MESSAGES.debugf("Exchange %s is missing %s header", exchange, TransactionConstants.RECOVERY_FLAGS);
                    return;
                }
                int flags = Integer.parseInt(flagsStringString);
                String parentName = exchange.getRequestHeaders().getFirst(TransactionConstants.RECOVERY_PARENT_NAME);
                if (parentName == null) {
                    exchange.setStatusCode(400);
                    HttpRemoteTransactionMessages.MESSAGES.debugf("Exchange %s is missing %s header", exchange, TransactionConstants.RECOVERY_PARENT_NAME);
                    return;
                }
                Xid[] recoveryList = HttpRemoteTransactionService.this.transactionContext.getRecoveryInterface().recover(flags, parentName);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                Marshaller marshaller = HttpRemoteTransactionService.this.httpServiceConfig.getHttpMarshallerFactory(exchange).createMarshaller();
                marshaller.start((ByteOutput)new NoFlushByteOutput(Marshalling.createByteOutput((OutputStream)out)));
                marshaller.writeInt(recoveryList.length);
                for (int i = 0; i < recoveryList.length; ++i) {
                    Xid xid = recoveryList[i];
                    marshaller.writeInt(xid.getFormatId());
                    marshaller.writeInt(xid.getGlobalTransactionId().length);
                    marshaller.write(xid.getGlobalTransactionId());
                    marshaller.writeInt(xid.getBranchQualifier().length);
                    marshaller.write(xid.getBranchQualifier());
                }
                marshaller.finish();
                exchange.getResponseSender().send(ByteBuffer.wrap(out.toByteArray()));
            }
            catch (Exception e) {
                HttpRemoteTransactionService.this.internalSendException(exchange, 500, e);
            }
        }
    }

    class BeginHandler
    implements HttpHandler {
        BeginHandler() {
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            try {
                String timeoutString = exchange.getRequestHeaders().getFirst(TransactionConstants.TIMEOUT);
                if (timeoutString == null) {
                    exchange.setStatusCode(400);
                    HttpRemoteTransactionMessages.MESSAGES.debugf("Exchange %s is missing %s header", exchange, TransactionConstants.TIMEOUT);
                    return;
                }
                Integer timeout = Integer.parseInt(timeoutString);
                exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, TransactionConstants.NEW_TRANSACTION.toString());
                LocalTransaction transaction = HttpRemoteTransactionService.this.transactionContext.beginTransaction(timeout.intValue());
                Xid xid = HttpRemoteTransactionService.this.xidResolver.apply(transaction);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                Marshaller marshaller = HttpRemoteTransactionService.this.httpServiceConfig.getHttpMarshallerFactory(exchange).createMarshaller();
                marshaller.start((ByteOutput)new NoFlushByteOutput(Marshalling.createByteOutput((OutputStream)out)));
                marshaller.writeInt(xid.getFormatId());
                marshaller.writeInt(xid.getGlobalTransactionId().length);
                marshaller.write(xid.getGlobalTransactionId());
                marshaller.writeInt(xid.getBranchQualifier().length);
                marshaller.write(xid.getBranchQualifier());
                marshaller.finish();
                exchange.getResponseSender().send(ByteBuffer.wrap(out.toByteArray()));
            }
            catch (Exception e) {
                HttpRemoteTransactionService.this.internalSendException(exchange, 500, e);
            }
        }
    }

    abstract class AbstractTransactionHandler
    implements HttpHandler {
        AbstractTransactionHandler() {
        }

        public final void handleRequest(HttpServerExchange exchange) throws Exception {
            ContentType contentType = ContentType.parse((String)exchange.getRequestHeaders().getFirst(Headers.CONTENT_TYPE));
            if (contentType == null || contentType.getVersion() != 1 || !contentType.getType().equals(TransactionConstants.XID.getType())) {
                exchange.setStatusCode(400);
                HttpRemoteTransactionMessages.MESSAGES.debugf("Exchange %s has incorrect or missing content type", exchange);
                return;
            }
            try {
                HttpMarshallerFactory httpMarshallerFactory = HttpRemoteTransactionService.this.httpServiceConfig.getHttpUnmarshallerFactory(exchange);
                Unmarshaller unmarshaller = httpMarshallerFactory.createUnmarshaller();
                unmarshaller.start((ByteInput)new InputStreamByteInput(exchange.getInputStream()));
                int formatId = unmarshaller.readInt();
                int len = unmarshaller.readInt();
                byte[] globalId = new byte[len];
                unmarshaller.readFully(globalId);
                len = unmarshaller.readInt();
                byte[] branchId = new byte[len];
                unmarshaller.readFully(branchId);
                SimpleXid simpleXid = new SimpleXid(formatId, globalId, branchId);
                unmarshaller.finish();
                ImportResult transaction = HttpRemoteTransactionService.this.transactionContext.findOrImportTransaction((Xid)simpleXid, 0);
                ((LocalTransaction)transaction.getTransaction()).performFunction((o, exchange2) -> {
                    this.handleImpl((HttpServerExchange)exchange2, (ImportResult<LocalTransaction>)o);
                    return null;
                }, (Object)transaction, (Object)exchange);
            }
            catch (Exception e) {
                HttpRemoteTransactionService.this.internalSendException(exchange, 500, e);
            }
        }

        protected abstract void handleImpl(HttpServerExchange var1, ImportResult<LocalTransaction> var2) throws Exception;
    }
}

