/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.generator.internal;

import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.persister.entity.EntityPersister;

public class NaturalIdHelper {
    public static String[] getNaturalIdPropertyNames(EntityPersister persister) {
        int[] naturalIdPropertyIndices = persister.getNaturalIdentifierProperties();
        if (naturalIdPropertyIndices == null) {
            throw new IdentifierGenerationException("entity '" + persister.getEntityName() + "' has no '@NaturalId' property");
        }
        if (persister.getEntityMetamodel().isNaturalIdentifierInsertGenerated()) {
            throw new IdentifierGenerationException("entity '" + persister.getEntityName() + "' has a '@NaturalId' property which is also defined as insert-generated");
        }
        String[] allPropertyNames = persister.getPropertyNames();
        String[] propertyNames = new String[naturalIdPropertyIndices.length];
        for (int i = 0; i < naturalIdPropertyIndices.length; ++i) {
            propertyNames[i] = allPropertyNames[naturalIdPropertyIndices[i]];
        }
        return propertyNames;
    }
}

