/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.discovery;

import java.io.Serializable;
import org.wildfly.common.Assert;
import org.wildfly.discovery.BooleanAttributeValue;
import org.wildfly.discovery.NumericAttributeValue;
import org.wildfly.discovery.OpaqueAttributeValue;
import org.wildfly.discovery.StringAttributeValue;

public abstract class AttributeValue
implements Comparable<AttributeValue>,
Serializable {
    private static final long serialVersionUID = -9125386269584070124L;
    static final int K_OPAQUE = 0;
    static final int K_NUMERIC = 1;
    static final int K_STRING = 2;
    static final int K_BOOLEAN_TRUE = 3;
    static final int K_BOOLEAN_FALSE = 4;
    private transient String toString;
    public static final BooleanAttributeValue TRUE = BooleanAttributeValue.TRUE;
    public static final BooleanAttributeValue FALSE = BooleanAttributeValue.FALSE;

    AttributeValue() {
    }

    AttributeValue(String initialToString) {
        this.toString = initialToString;
    }

    public static AttributeValue fromString(String string) {
        Assert.checkNotNullParam((String)"string", (Object)string);
        return new StringAttributeValue(string);
    }

    public static AttributeValue fromBytes(byte[] bytes) {
        Assert.checkNotNullParam((String)"bytes", (Object)bytes);
        return new OpaqueAttributeValue(bytes, true);
    }

    public static AttributeValue fromInt(int value) {
        return new NumericAttributeValue(value);
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean isNumeric() {
        return false;
    }

    public boolean isOpaque() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public int asInt() throws IllegalArgumentException {
        throw new IllegalArgumentException();
    }

    abstract int getKind();

    @Override
    public int compareTo(AttributeValue other) {
        Assert.checkNotNullParam((String)"other", (Object)other);
        return Integer.signum(other.getKind() - this.getKind());
    }

    public abstract boolean equals(Object var1);

    public abstract boolean equals(AttributeValue var1);

    public String toString() {
        String toString = this.toString;
        if (toString == null) {
            this.toString = this.generateToString();
            return this.toString;
        }
        return toString;
    }

    abstract String generateToString();
}

