/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.controller.ResourceDefinitionProvider;
import org.jboss.as.clustering.infinispan.subsystem.BackupResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.BackupsResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.CacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ClusteredCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.CustomStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.DistributedCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ExpirationResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.FileStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.HeapMemoryResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.HotRodStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemSchema;
import org.jboss.as.clustering.infinispan.subsystem.InvalidationCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.JDBCStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.JGroupsTransportResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.LocalCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.LockingResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.MemoryResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.OffHeapMemoryResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.PartitionHandlingResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.RemoteStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ReplicatedCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ScatteredCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ScheduledThreadPoolDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ScheduledThreadPoolResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.SegmentedCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StateTransferResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreWriteBehindResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreWriteResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StringTableResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.TableResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ThreadPoolDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ThreadPoolResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.TransactionMode;
import org.jboss.as.clustering.infinispan.subsystem.TransactionResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.TransportResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.XMLAttribute;
import org.jboss.as.clustering.infinispan.subsystem.XMLElement;
import org.jboss.as.clustering.infinispan.subsystem.remote.ConnectionPoolResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.remote.RemoteCacheContainerResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.remote.RemoteClusterResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.remote.SecurityResourceDefinition;
import org.jboss.as.clustering.logging.ClusteringLogger;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.Versioned;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.wildfly.clustering.infinispan.marshall.InfinispanMarshallerFactory;

public class InfinispanSubsystemXMLReader
implements XMLElementReader<List<ModelNode>> {
    private final InfinispanSubsystemSchema schema;

    InfinispanSubsystemXMLReader(InfinispanSubsystemSchema schema) {
        this.schema = schema;
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> result) throws XMLStreamException {
        LinkedHashMap<PathAddress, ModelNode> operations = new LinkedHashMap<PathAddress, ModelNode>();
        PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{InfinispanSubsystemResourceDefinition.PATH});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            XMLElement element = XMLElement.forName(reader.getLocalName());
            switch (element) {
                case CACHE_CONTAINER: {
                    this.parseContainer(reader, address, operations);
                    continue block4;
                }
                case REMOTE_CACHE_CONTAINER: {
                    if (!this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_6_0)) break;
                    this.parseRemoteContainer(reader, address, operations);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        result.addAll(operations.values());
    }

    private void parseContainer(XMLExtendedStreamReader reader, PathAddress subsystemAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        String name = InfinispanSubsystemXMLReader.require(reader, XMLAttribute.NAME);
        PathAddress address = subsystemAddress.append(new PathElement[]{CacheContainerResourceDefinition.pathElement(name)});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        block25: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    continue block25;
                }
                case DEFAULT_CACHE: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, CacheContainerResourceDefinition.Attribute.DEFAULT_CACHE);
                    continue block25;
                }
                case JNDI_NAME: {
                    if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_5_0)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    ClusteringLogger.ROOT_LOGGER.attributeIgnored(attribute.getLocalName(), reader.getLocalName());
                    continue block25;
                }
                case LISTENER_EXECUTOR: 
                case EVICTION_EXECUTOR: 
                case REPLICATION_QUEUE_EXECUTOR: {
                    if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_4_0)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    ClusteringLogger.ROOT_LOGGER.attributeIgnored(attribute.getLocalName(), reader.getLocalName());
                    continue block25;
                }
                case START: {
                    if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_3_0)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    ClusteringLogger.ROOT_LOGGER.attributeIgnored(attribute.getLocalName(), reader.getLocalName());
                    continue block25;
                }
                case ALIASES: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, CacheContainerResourceDefinition.ListAttribute.ALIASES);
                    continue block25;
                }
                case MODULE: {
                    if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_12_0)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, CacheContainerResourceDefinition.ListAttribute.MODULES);
                    continue block25;
                }
                case STATISTICS_ENABLED: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, CacheContainerResourceDefinition.Attribute.STATISTICS_ENABLED);
                    continue block25;
                }
                case MODULES: {
                    if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_12_0)) {
                        InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, CacheContainerResourceDefinition.ListAttribute.MODULES);
                        continue block25;
                    }
                }
                case MARSHALLER: {
                    if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_13_0)) {
                        InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, CacheContainerResourceDefinition.Attribute.MARSHALLER);
                        continue block25;
                    }
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!operation.hasDefined(CacheContainerResourceDefinition.Attribute.MARSHALLER.getName()) && !this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_14_0)) {
            operation.get(CacheContainerResourceDefinition.Attribute.MARSHALLER.getName()).set(new ModelNode(InfinispanMarshallerFactory.LEGACY.name()));
        }
        block26: while (reader.hasNext() && reader.nextTag() != 2) {
            XMLElement element = XMLElement.forName(reader.getLocalName());
            switch (element) {
                case TRANSPORT: {
                    this.parseTransport(reader, address, operations);
                    continue block26;
                }
                case LOCAL_CACHE: {
                    this.parseLocalCache(reader, address, operations);
                    continue block26;
                }
                case INVALIDATION_CACHE: {
                    this.parseInvalidationCache(reader, address, operations);
                    continue block26;
                }
                case REPLICATED_CACHE: {
                    this.parseReplicatedCache(reader, address, operations);
                    continue block26;
                }
                case DISTRIBUTED_CACHE: {
                    this.parseDistributedCache(reader, address, operations);
                    continue block26;
                }
                case EXPIRATION_THREAD_POOL: {
                    if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_4_0)) {
                        this.parseScheduledThreadPool(ScheduledThreadPoolResourceDefinition.EXPIRATION, reader, address, operations);
                        continue block26;
                    }
                }
                case LISTENER_THREAD_POOL: {
                    if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_4_0)) {
                        this.parseThreadPool(ThreadPoolResourceDefinition.LISTENER, reader, address, operations);
                        continue block26;
                    }
                }
                case ASYNC_OPERATIONS_THREAD_POOL: 
                case PERSISTENCE_THREAD_POOL: 
                case REMOTE_COMMAND_THREAD_POOL: 
                case STATE_TRANSFER_THREAD_POOL: 
                case TRANSPORT_THREAD_POOL: {
                    if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_14_0)) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    ClusteringLogger.ROOT_LOGGER.elementIgnored(element.getLocalName());
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block26;
                }
                case SCATTERED_CACHE: {
                    if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_6_0)) {
                        this.parseScatteredCache(reader, address, operations);
                        continue block26;
                    }
                }
                case BLOCKING_THREAD_POOL: {
                    if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_11_0)) {
                        this.parseThreadPool(ThreadPoolResourceDefinition.BLOCKING, reader, address, operations);
                        continue block26;
                    }
                }
                case NON_BLOCKING_THREAD_POOL: {
                    if (!this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_11_0)) break;
                    this.parseThreadPool(ThreadPoolResourceDefinition.NON_BLOCKING, reader, address, operations);
                    continue block26;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseTransport(XMLExtendedStreamReader reader, PathAddress containerAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = containerAddress.append(new PathElement[]{JGroupsTransportResourceDefinition.PATH});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(containerAddress.append(new PathElement[]{TransportResourceDefinition.WILDCARD_PATH}), operation);
        String stack = null;
        String cluster = null;
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case STACK: {
                    if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_3_0)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    stack = reader.getAttributeValue(i);
                    continue block7;
                }
                case EXECUTOR: {
                    if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_4_0)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    ClusteringLogger.ROOT_LOGGER.attributeIgnored(attribute.getLocalName(), reader.getLocalName());
                    continue block7;
                }
                case LOCK_TIMEOUT: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, JGroupsTransportResourceDefinition.Attribute.LOCK_TIMEOUT);
                    continue block7;
                }
                case CLUSTER: {
                    if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_3_0)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    cluster = reader.getAttributeValue(i);
                    continue block7;
                }
                case CHANNEL: {
                    if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_3_0)) {
                        InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, JGroupsTransportResourceDefinition.Attribute.CHANNEL);
                        continue block7;
                    }
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_3_0)) {
            String channel = "ee-" + containerAddress.getLastElement().getValue();
            InfinispanSubsystemXMLReader.setAttribute(reader, channel, operation, JGroupsTransportResourceDefinition.Attribute.CHANNEL);
            PathAddress subsystemAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"jgroups")});
            PathAddress channelAddress = subsystemAddress.append(new PathElement[]{PathElement.pathElement((String)"channel", (String)channel)});
            ModelNode channelOperation = Util.createAddOperation((PathAddress)channelAddress);
            if (stack != null) {
                channelOperation.get("stack").set(stack);
            }
            if (cluster != null) {
                channelOperation.get("cluster").set(cluster);
            }
            operations.put(channelAddress, channelOperation);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseLocalCache(XMLExtendedStreamReader reader, PathAddress containerAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        String name = InfinispanSubsystemXMLReader.require(reader, XMLAttribute.NAME);
        PathAddress address = containerAddress.append(new PathElement[]{LocalCacheResourceDefinition.pathElement(name)});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            this.parseCacheAttribute(reader, i, address, operations);
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
            this.parseCacheElement(reader, address, operations);
        }
    }

    private void parseReplicatedCache(XMLExtendedStreamReader reader, PathAddress containerAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        String name = InfinispanSubsystemXMLReader.require(reader, XMLAttribute.NAME);
        PathAddress address = containerAddress.append(new PathElement[]{ReplicatedCacheResourceDefinition.pathElement(name)});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            this.parseClusteredCacheAttribute(reader, i, address, operations);
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
            this.parseSharedStateCacheElement(reader, address, operations);
        }
    }

    private void parseScatteredCache(XMLExtendedStreamReader reader, PathAddress containerAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        String name = InfinispanSubsystemXMLReader.require(reader, XMLAttribute.NAME);
        PathAddress address = containerAddress.append(new PathElement[]{ScatteredCacheResourceDefinition.pathElement(name)});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case BIAS_LIFESPAN: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, ScatteredCacheResourceDefinition.Attribute.BIAS_LIFESPAN);
                    continue block4;
                }
                case INVALIDATION_BATCH_SIZE: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, ScatteredCacheResourceDefinition.Attribute.INVALIDATION_BATCH_SIZE);
                    continue block4;
                }
                default: {
                    this.parseSegmentedCacheAttribute(reader, i, address, operations);
                }
            }
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
            this.parseSharedStateCacheElement(reader, address, operations);
        }
    }

    private void parseDistributedCache(XMLExtendedStreamReader reader, PathAddress containerAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        String name = InfinispanSubsystemXMLReader.require(reader, XMLAttribute.NAME);
        PathAddress address = containerAddress.append(new PathElement[]{DistributedCacheResourceDefinition.pathElement(name)});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case OWNERS: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, DistributedCacheResourceDefinition.Attribute.OWNERS);
                    continue block5;
                }
                case L1_LIFESPAN: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, DistributedCacheResourceDefinition.Attribute.L1_LIFESPAN);
                    continue block5;
                }
                case CAPACITY_FACTOR: {
                    if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_3_0)) {
                        InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, DistributedCacheResourceDefinition.Attribute.CAPACITY_FACTOR);
                        continue block5;
                    }
                }
                default: {
                    this.parseSegmentedCacheAttribute(reader, i, address, operations);
                }
            }
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
            this.parseSharedStateCacheElement(reader, address, operations);
        }
    }

    private void parseInvalidationCache(XMLExtendedStreamReader reader, PathAddress containerAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        String name = InfinispanSubsystemXMLReader.require(reader, XMLAttribute.NAME);
        PathAddress address = containerAddress.append(new PathElement[]{InvalidationCacheResourceDefinition.pathElement(name)});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            this.parseClusteredCacheAttribute(reader, i, address, operations);
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
            this.parseCacheElement(reader, address, operations);
        }
    }

    private void parseCacheAttribute(XMLExtendedStreamReader reader, int index, PathAddress address, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        ModelNode operation = operations.get(address);
        XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(index));
        switch (attribute) {
            case NAME: {
                break;
            }
            case START: {
                if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_3_0)) {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)index);
                }
                ClusteringLogger.ROOT_LOGGER.attributeIgnored(attribute.getLocalName(), reader.getLocalName());
                break;
            }
            case BATCHING: {
                if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_3_0)) {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)index);
                }
                PathAddress transactionAddress = address.append(new PathElement[]{TransactionResourceDefinition.PATH});
                ModelNode transactionOperation = Util.createAddOperation((PathAddress)transactionAddress);
                transactionOperation.get(TransactionResourceDefinition.Attribute.MODE.getName()).set(new ModelNode(TransactionMode.BATCH.name()));
                operations.put(transactionAddress, transactionOperation);
                break;
            }
            case JNDI_NAME: {
                if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_5_0)) {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)index);
                }
                ClusteringLogger.ROOT_LOGGER.attributeIgnored(attribute.getLocalName(), reader.getLocalName());
                break;
            }
            case MODULE: {
                if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_12_0)) {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)index);
                }
                InfinispanSubsystemXMLReader.readAttribute(reader, index, operation, CacheResourceDefinition.ListAttribute.MODULES);
                break;
            }
            case STATISTICS_ENABLED: {
                InfinispanSubsystemXMLReader.readAttribute(reader, index, operation, CacheResourceDefinition.Attribute.STATISTICS_ENABLED);
                break;
            }
            case MODULES: {
                if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_12_0)) {
                    InfinispanSubsystemXMLReader.readAttribute(reader, index, operation, CacheResourceDefinition.ListAttribute.MODULES);
                    break;
                }
            }
            default: {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)index);
            }
        }
    }

    private void parseSegmentedCacheAttribute(XMLExtendedStreamReader reader, int index, PathAddress address, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        ModelNode operation = operations.get(address);
        XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(index));
        switch (attribute) {
            case SEGMENTS: {
                InfinispanSubsystemXMLReader.readAttribute(reader, index, operation, SegmentedCacheResourceDefinition.Attribute.SEGMENTS);
                break;
            }
            case CONSISTENT_HASH_STRATEGY: {
                if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_14_0)) {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)index);
                }
                if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_3_0)) {
                    ClusteringLogger.ROOT_LOGGER.attributeIgnored(attribute.getLocalName(), reader.getLocalName());
                    break;
                }
            }
            default: {
                this.parseClusteredCacheAttribute(reader, index, address, operations);
            }
        }
    }

    private void parseClusteredCacheAttribute(XMLExtendedStreamReader reader, int index, PathAddress address, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        ModelNode operation = operations.get(address);
        XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(index));
        switch (attribute) {
            case MODE: {
                if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_5_0)) {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)index);
                }
                ClusteringLogger.ROOT_LOGGER.attributeIgnored(attribute.getLocalName(), reader.getLocalName());
                break;
            }
            case QUEUE_SIZE: {
                ClusteringLogger.ROOT_LOGGER.attributeIgnored(attribute.getLocalName(), reader.getLocalName());
                break;
            }
            case QUEUE_FLUSH_INTERVAL: {
                ClusteringLogger.ROOT_LOGGER.attributeIgnored(attribute.getLocalName(), reader.getLocalName());
                break;
            }
            case REMOTE_TIMEOUT: {
                InfinispanSubsystemXMLReader.readAttribute(reader, index, operation, ClusteredCacheResourceDefinition.Attribute.REMOTE_TIMEOUT);
                break;
            }
            case ASYNC_MARSHALLING: {
                if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_4_0)) {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)index);
                }
                ClusteringLogger.ROOT_LOGGER.attributeIgnored(attribute.getLocalName(), reader.getLocalName());
                break;
            }
            default: {
                this.parseCacheAttribute(reader, index, address, operations);
            }
        }
    }

    private void parseCacheElement(XMLExtendedStreamReader reader, PathAddress cacheAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        XMLElement element = XMLElement.forName(reader.getLocalName());
        switch (element) {
            case EVICTION: {
                if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_5_0)) {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                this.parseEviction(reader, cacheAddress, operations);
                break;
            }
            case EXPIRATION: {
                this.parseExpiration(reader, cacheAddress, operations);
                break;
            }
            case LOCKING: {
                this.parseLocking(reader, cacheAddress, operations);
                break;
            }
            case TRANSACTION: {
                this.parseTransaction(reader, cacheAddress, operations);
                break;
            }
            case STORE: {
                this.parseCustomStore(reader, cacheAddress, operations);
                break;
            }
            case FILE_STORE: {
                this.parseFileStore(reader, cacheAddress, operations);
                break;
            }
            case REMOTE_STORE: {
                this.parseRemoteStore(reader, cacheAddress, operations);
                break;
            }
            case HOTROD_STORE: {
                if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_6_0)) {
                    this.parseHotRodStore(reader, cacheAddress, operations);
                    break;
                }
            }
            case JDBC_STORE: {
                if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_5_0)) {
                    this.parseJDBCStore(reader, cacheAddress, operations);
                    break;
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            case STRING_KEYED_JDBC_STORE: {
                if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_5_0)) {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                this.parseStringKeyedJDBCStore(reader, cacheAddress, operations);
                break;
            }
            case BINARY_KEYED_JDBC_STORE: {
                if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_14_0)) {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                this.parseBinaryKeyedJDBCStore(reader, cacheAddress, operations);
                break;
            }
            case MIXED_KEYED_JDBC_STORE: {
                if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_14_0)) {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                this.parseMixedKeyedJDBCStore(reader, cacheAddress, operations);
                break;
            }
            case INDEXING: {
                if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_4_0)) {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                this.parseIndexing(reader, cacheAddress, operations);
                break;
            }
            case OBJECT_MEMORY: {
                if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_11_0)) {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_5_0)) {
                    this.parseHeapMemory(reader, cacheAddress, operations);
                    break;
                }
            }
            case BINARY_MEMORY: {
                if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_11_0)) {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_5_0)) {
                    this.parseBinaryMemory(reader, cacheAddress, operations);
                    break;
                }
            }
            case OFF_HEAP_MEMORY: {
                if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_5_0)) {
                    this.parseOffHeapMemory(reader, cacheAddress, operations);
                    break;
                }
            }
            case HEAP_MEMORY: {
                if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_11_0)) {
                    this.parseHeapMemory(reader, cacheAddress, operations);
                    break;
                }
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
    }

    private void parseSharedStateCacheElement(XMLExtendedStreamReader reader, PathAddress address, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        XMLElement element = XMLElement.forName(reader.getLocalName());
        switch (element) {
            case STATE_TRANSFER: {
                this.parseStateTransfer(reader, address, operations);
                break;
            }
            case BACKUPS: {
                if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_2_0)) {
                    this.parseBackups(reader, address, operations);
                    break;
                }
            }
            case BACKUP_FOR: {
                if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_2_0) && !this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_5_0)) {
                    ClusteringLogger.ROOT_LOGGER.elementIgnored(reader.getLocalName());
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    break;
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            case PARTITION_HANDLING: {
                if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_4_0)) {
                    this.parsePartitionHandling(reader, address, operations);
                    break;
                }
            }
            default: {
                this.parseCacheElement(reader, address, operations);
            }
        }
    }

    private void parsePartitionHandling(XMLExtendedStreamReader reader, PathAddress cacheAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = cacheAddress.append(new PathElement[]{PartitionHandlingResourceDefinition.PATH});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_14_0)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, PartitionHandlingResourceDefinition.DeprecatedAttribute.ENABLED);
                    continue block5;
                }
                case WHEN_SPLIT: {
                    if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_14_0)) {
                        InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, PartitionHandlingResourceDefinition.Attribute.WHEN_SPLIT);
                        continue block5;
                    }
                }
                case MERGE_POLICY: {
                    if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_14_0)) {
                        InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, PartitionHandlingResourceDefinition.Attribute.MERGE_POLICY);
                        continue block5;
                    }
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseStateTransfer(XMLExtendedStreamReader reader, PathAddress cacheAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = cacheAddress.append(new PathElement[]{StateTransferResourceDefinition.PATH});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_4_0)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    ClusteringLogger.ROOT_LOGGER.attributeIgnored(attribute.getLocalName(), reader.getLocalName());
                    continue block5;
                }
                case TIMEOUT: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, StateTransferResourceDefinition.Attribute.TIMEOUT);
                    continue block5;
                }
                case CHUNK_SIZE: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, StateTransferResourceDefinition.Attribute.CHUNK_SIZE);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseBackups(XMLExtendedStreamReader reader, PathAddress cacheAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = cacheAddress.append(new PathElement[]{BackupsResourceDefinition.PATH});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            XMLElement element = XMLElement.forName(reader.getLocalName());
            switch (element) {
                case BACKUP: {
                    this.parseBackup(reader, address, operations);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseBackup(XMLExtendedStreamReader reader, PathAddress backupsAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        String site = InfinispanSubsystemXMLReader.require(reader, XMLAttribute.SITE);
        PathAddress address = backupsAddress.append(new PathElement[]{BackupResourceDefinition.pathElement(site)});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        block14: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SITE: {
                    continue block14;
                }
                case STRATEGY: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, BackupResourceDefinition.Attribute.STRATEGY);
                    continue block14;
                }
                case BACKUP_FAILURE_POLICY: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, BackupResourceDefinition.Attribute.FAILURE_POLICY);
                    continue block14;
                }
                case TIMEOUT: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, BackupResourceDefinition.Attribute.TIMEOUT);
                    continue block14;
                }
                case ENABLED: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, BackupResourceDefinition.DeprecatedAttribute.ENABLED);
                    continue block14;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block15: while (reader.hasNext() && reader.nextTag() != 2) {
            XMLElement element = XMLElement.forName(reader.getLocalName());
            switch (element) {
                case TAKE_OFFLINE: {
                    block16: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                        XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
                        switch (attribute) {
                            case TAKE_OFFLINE_AFTER_FAILURES: {
                                InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, BackupResourceDefinition.TakeOfflineAttribute.AFTER_FAILURES);
                                continue block16;
                            }
                            case TAKE_OFFLINE_MIN_WAIT: {
                                InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, BackupResourceDefinition.TakeOfflineAttribute.MIN_WAIT);
                                continue block16;
                            }
                            default: {
                                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                            }
                        }
                    }
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block15;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseLocking(XMLExtendedStreamReader reader, PathAddress cacheAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = cacheAddress.append(new PathElement[]{LockingResourceDefinition.PATH});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ISOLATION: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, LockingResourceDefinition.Attribute.ISOLATION);
                    continue block6;
                }
                case STRIPING: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, LockingResourceDefinition.Attribute.STRIPING);
                    continue block6;
                }
                case ACQUIRE_TIMEOUT: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, LockingResourceDefinition.Attribute.ACQUIRE_TIMEOUT);
                    continue block6;
                }
                case CONCURRENCY_LEVEL: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, LockingResourceDefinition.Attribute.CONCURRENCY);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseTransaction(XMLExtendedStreamReader reader, PathAddress cacheAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = cacheAddress.append(new PathElement[]{TransactionResourceDefinition.PATH});
        ModelNode operation = operations.get(address);
        if (operation == null) {
            operation = Util.createAddOperation((PathAddress)address);
            operations.put(address, operation);
        }
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case STOP_TIMEOUT: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, TransactionResourceDefinition.Attribute.STOP_TIMEOUT);
                    continue block6;
                }
                case MODE: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, TransactionResourceDefinition.Attribute.MODE);
                    continue block6;
                }
                case LOCKING: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, TransactionResourceDefinition.Attribute.LOCKING);
                    continue block6;
                }
                case COMPLETE_TIMEOUT: {
                    if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_13_0)) {
                        InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, TransactionResourceDefinition.Attribute.COMPLETE_TIMEOUT);
                        continue block6;
                    }
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseEviction(XMLExtendedStreamReader reader, PathAddress cacheAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = cacheAddress.append(new PathElement[]{HeapMemoryResourceDefinition.PATH});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case STRATEGY: {
                    ClusteringLogger.ROOT_LOGGER.attributeIgnored(attribute.getLocalName(), reader.getLocalName());
                    continue block4;
                }
                case MAX_ENTRIES: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, MemoryResourceDefinition.Attribute.SIZE);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseExpiration(XMLExtendedStreamReader reader, PathAddress cacheAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = cacheAddress.append(new PathElement[]{ExpirationResourceDefinition.PATH});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case MAX_IDLE: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, ExpirationResourceDefinition.Attribute.MAX_IDLE);
                    continue block5;
                }
                case LIFESPAN: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, ExpirationResourceDefinition.Attribute.LIFESPAN);
                    continue block5;
                }
                case INTERVAL: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, ExpirationResourceDefinition.Attribute.INTERVAL);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseIndexing(XMLExtendedStreamReader reader, PathAddress cacheAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case INDEX: {
                    ClusteringLogger.ROOT_LOGGER.attributeIgnored(attribute.getLocalName(), reader.getLocalName());
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case PROPERTY: {
                    ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)XMLAttribute.NAME.getLocalName());
                    reader.getElementText();
                    ClusteringLogger.ROOT_LOGGER.elementIgnored(reader.getLocalName());
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseHeapMemory(XMLExtendedStreamReader reader, PathAddress cacheAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = cacheAddress.append(new PathElement[]{HeapMemoryResourceDefinition.PATH});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SIZE_UNIT: {
                    if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_11_0)) {
                        InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, HeapMemoryResourceDefinition.Attribute.SIZE_UNIT);
                        continue block3;
                    }
                }
                default: {
                    this.parseMemoryAttribute(reader, i, operation);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseBinaryMemory(XMLExtendedStreamReader reader, PathAddress cacheAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = cacheAddress.append(new PathElement[]{OffHeapMemoryResourceDefinition.BINARY_PATH});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            this.parseBinaryMemoryAttribute(reader, i, operation);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseOffHeapMemory(XMLExtendedStreamReader reader, PathAddress cacheAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = cacheAddress.append(new PathElement[]{OffHeapMemoryResourceDefinition.PATH});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CAPACITY: {
                    if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_14_0)) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    ClusteringLogger.ROOT_LOGGER.attributeIgnored(attribute.getLocalName(), reader.getLocalName());
                    continue block4;
                }
                case SIZE_UNIT: {
                    if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_11_0)) {
                        InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, OffHeapMemoryResourceDefinition.Attribute.SIZE_UNIT);
                        continue block4;
                    }
                }
                default: {
                    this.parseBinaryMemoryAttribute(reader, i, operation);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseBinaryMemoryAttribute(XMLExtendedStreamReader reader, int index, ModelNode operation) throws XMLStreamException {
        XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(index));
        switch (attribute) {
            case EVICTION_TYPE: {
                ClusteringLogger.ROOT_LOGGER.attributeIgnored(attribute.getLocalName(), reader.getLocalName());
                break;
            }
            default: {
                this.parseMemoryAttribute(reader, index, operation);
            }
        }
    }

    private void parseMemoryAttribute(XMLExtendedStreamReader reader, int index, ModelNode operation) throws XMLStreamException {
        XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(index));
        switch (attribute) {
            case SIZE: {
                InfinispanSubsystemXMLReader.readAttribute(reader, index, operation, MemoryResourceDefinition.Attribute.SIZE);
                break;
            }
            default: {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)index);
            }
        }
    }

    private void applyLegacyStoreAttributeDefaults(ModelNode operation) {
        if (!this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_14_0)) {
            for (Attribute attribute : Set.of(StoreResourceDefinition.Attribute.PASSIVATION, StoreResourceDefinition.Attribute.PURGE)) {
                if (operation.hasDefined(attribute.getName())) continue;
                operation.get(attribute.getName()).set(ModelNode.TRUE);
            }
        }
    }

    private void parseCustomStore(XMLExtendedStreamReader reader, PathAddress cacheAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = cacheAddress.append(new PathElement[]{CustomStoreResourceDefinition.PATH});
        PathAddress operationKey = cacheAddress.append(new PathElement[]{StoreResourceDefinition.WILDCARD_PATH});
        if (operations.containsKey(operationKey)) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(operationKey, operation);
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CLASS: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, CustomStoreResourceDefinition.Attribute.CLASS);
                    continue block3;
                }
                default: {
                    this.parseStoreAttribute(reader, i, operation);
                }
            }
        }
        if (!operation.hasDefined(CustomStoreResourceDefinition.Attribute.CLASS.getName())) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(XMLAttribute.CLASS));
        }
        this.applyLegacyStoreAttributeDefaults(operation);
        while (reader.hasNext() && reader.nextTag() != 2) {
            this.parseStoreElement(reader, address, operations);
        }
    }

    private void parseFileStore(XMLExtendedStreamReader reader, PathAddress cacheAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = cacheAddress.append(new PathElement[]{FileStoreResourceDefinition.PATH});
        PathAddress operationKey = cacheAddress.append(new PathElement[]{StoreResourceDefinition.WILDCARD_PATH});
        if (operations.containsKey(operationKey)) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(operationKey, operation);
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case RELATIVE_TO: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, FileStoreResourceDefinition.DeprecatedAttribute.RELATIVE_TO);
                    continue block4;
                }
                case PATH: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, FileStoreResourceDefinition.DeprecatedAttribute.RELATIVE_PATH);
                    continue block4;
                }
                default: {
                    this.parseStoreAttribute(reader, i, operation);
                }
            }
        }
        this.applyLegacyStoreAttributeDefaults(operation);
        while (reader.hasNext() && reader.nextTag() != 2) {
            this.parseStoreElement(reader, address, operations);
        }
    }

    private void parseRemoteStore(XMLExtendedStreamReader reader, PathAddress cacheAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = cacheAddress.append(new PathElement[]{RemoteStoreResourceDefinition.PATH});
        PathAddress operationKey = cacheAddress.append(new PathElement[]{StoreResourceDefinition.WILDCARD_PATH});
        if (operations.containsKey(operationKey)) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(operationKey, operation);
        block12: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CACHE: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, RemoteStoreResourceDefinition.Attribute.CACHE);
                    continue block12;
                }
                case SOCKET_TIMEOUT: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, RemoteStoreResourceDefinition.Attribute.SOCKET_TIMEOUT);
                    continue block12;
                }
                case TCP_NO_DELAY: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, RemoteStoreResourceDefinition.Attribute.TCP_NO_DELAY);
                    continue block12;
                }
                case REMOTE_SERVERS: {
                    if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_4_0)) {
                        InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, RemoteStoreResourceDefinition.Attribute.SOCKET_BINDINGS);
                        continue block12;
                    }
                }
                default: {
                    this.parseStoreAttribute(reader, i, operation);
                }
            }
        }
        this.applyLegacyStoreAttributeDefaults(operation);
        block13: while (reader.hasNext() && reader.nextTag() != 2) {
            XMLElement element = XMLElement.forName(reader.getLocalName());
            switch (element) {
                case REMOTE_SERVER: {
                    if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_4_0)) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    block14: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                        XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
                        switch (attribute) {
                            case OUTBOUND_SOCKET_BINDING: {
                                InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, RemoteStoreResourceDefinition.Attribute.SOCKET_BINDINGS);
                                continue block14;
                            }
                            default: {
                                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                            }
                        }
                    }
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block13;
                }
            }
            this.parseStoreElement(reader, address, operations);
        }
        if (!operation.hasDefined(RemoteStoreResourceDefinition.Attribute.SOCKET_BINDINGS.getName())) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(XMLAttribute.REMOTE_SERVERS.getLocalName()));
        }
    }

    private void parseHotRodStore(XMLExtendedStreamReader reader, PathAddress cacheAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = cacheAddress.append(new PathElement[]{HotRodStoreResourceDefinition.PATH});
        PathAddress operationKey = cacheAddress.append(new PathElement[]{StoreResourceDefinition.WILDCARD_PATH});
        if (operations.containsKey(operationKey)) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(operationKey, operation);
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CACHE_CONFIGURATION: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, HotRodStoreResourceDefinition.Attribute.CACHE_CONFIGURATION);
                    continue block4;
                }
                case REMOTE_CACHE_CONTAINER: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, HotRodStoreResourceDefinition.Attribute.REMOTE_CACHE_CONTAINER);
                    continue block4;
                }
                default: {
                    this.parseStoreAttribute(reader, i, operation);
                }
            }
        }
        this.applyLegacyStoreAttributeDefaults(operation);
        while (reader.hasNext() && reader.nextTag() != 2) {
            this.parseStoreElement(reader, address, operations);
        }
    }

    private void parseJDBCStore(XMLExtendedStreamReader reader, PathAddress cacheAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = cacheAddress.append(new PathElement[]{JDBCStoreResourceDefinition.PATH});
        PathAddress operationKey = cacheAddress.append(new PathElement[]{StoreResourceDefinition.WILDCARD_PATH});
        if (operations.containsKey(operationKey)) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(operationKey, operation);
        this.parseJDBCStoreAttributes(reader, operationKey, operations);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            XMLElement element = XMLElement.forName(reader.getLocalName());
            switch (element) {
                case TABLE: {
                    this.parseJDBCStoreStringTable(reader, address, operations);
                    continue block3;
                }
            }
            this.parseStoreElement(reader, address, operations);
        }
    }

    private void parseBinaryKeyedJDBCStore(XMLExtendedStreamReader reader, PathAddress cacheAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = cacheAddress.append(new PathElement[]{JDBCStoreResourceDefinition.PATH});
        PathAddress operationKey = cacheAddress.append(new PathElement[]{StoreResourceDefinition.WILDCARD_PATH});
        if (operations.containsKey(operationKey)) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(operationKey, operation);
        this.parseJDBCStoreAttributes(reader, operationKey, operations);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            XMLElement element = XMLElement.forName(reader.getLocalName());
            switch (element) {
                case BINARY_KEYED_TABLE: {
                    this.parseJDBCStoreBinaryTable(reader, address, operations);
                    continue block3;
                }
            }
            this.parseStoreElement(reader, address, operations);
        }
    }

    private void parseStringKeyedJDBCStore(XMLExtendedStreamReader reader, PathAddress cacheAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = cacheAddress.append(new PathElement[]{JDBCStoreResourceDefinition.PATH});
        PathAddress operationKey = cacheAddress.append(new PathElement[]{StoreResourceDefinition.WILDCARD_PATH});
        if (operations.containsKey(operationKey)) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(operationKey, operation);
        this.parseJDBCStoreAttributes(reader, operationKey, operations);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            XMLElement element = XMLElement.forName(reader.getLocalName());
            switch (element) {
                case STRING_KEYED_TABLE: {
                    this.parseJDBCStoreStringTable(reader, address, operations);
                    continue block3;
                }
            }
            this.parseStoreElement(reader, address, operations);
        }
    }

    private void parseMixedKeyedJDBCStore(XMLExtendedStreamReader reader, PathAddress cacheAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = cacheAddress.append(new PathElement[]{JDBCStoreResourceDefinition.PATH});
        PathAddress operationKey = cacheAddress.append(new PathElement[]{StoreResourceDefinition.WILDCARD_PATH});
        if (operations.containsKey(operationKey)) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(operationKey, operation);
        this.parseJDBCStoreAttributes(reader, operationKey, operations);
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            XMLElement element = XMLElement.forName(reader.getLocalName());
            switch (element) {
                case BINARY_KEYED_TABLE: {
                    this.parseJDBCStoreBinaryTable(reader, address, operations);
                    continue block4;
                }
                case STRING_KEYED_TABLE: {
                    this.parseJDBCStoreStringTable(reader, address, operations);
                    continue block4;
                }
            }
            this.parseStoreElement(reader, address, operations);
        }
    }

    private void parseJDBCStoreAttributes(XMLExtendedStreamReader reader, PathAddress operationKey, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        ModelNode operation = operations.get(operationKey);
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case DATASOURCE: {
                    if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_4_0)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    String jndiName = reader.getAttributeValue(i);
                    String dataSourceName = jndiName.substring(jndiName.lastIndexOf(47) + 1);
                    operation.get(JDBCStoreResourceDefinition.Attribute.DATA_SOURCE.getName()).set(dataSourceName);
                    continue block5;
                }
                case DIALECT: {
                    if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_2_0)) {
                        InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, JDBCStoreResourceDefinition.Attribute.DIALECT);
                        continue block5;
                    }
                }
                case DATA_SOURCE: {
                    if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_4_0)) {
                        InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, JDBCStoreResourceDefinition.Attribute.DATA_SOURCE);
                        continue block5;
                    }
                }
                default: {
                    this.parseStoreAttribute(reader, i, operation);
                }
            }
        }
        this.applyLegacyStoreAttributeDefaults(operation);
    }

    private void parseJDBCStoreBinaryTable(XMLExtendedStreamReader reader, PathAddress storeAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = storeAddress.append(new PathElement[]{StringTableResourceDefinition.PATH});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(storeAddress.getParent().append(new PathElement[]{StoreResourceDefinition.WILDCARD_PATH}).append(new PathElement[]{StringTableResourceDefinition.PATH}), operation);
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case PREFIX: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, StringTableResourceDefinition.Attribute.PREFIX);
                    continue block3;
                }
                default: {
                    this.parseJDBCStoreTableAttribute(reader, i, operation);
                }
            }
        }
        this.parseJDBCStoreTableElements(reader, operation);
    }

    private void parseJDBCStoreStringTable(XMLExtendedStreamReader reader, PathAddress storeAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = storeAddress.append(new PathElement[]{StringTableResourceDefinition.PATH});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(storeAddress.getParent().append(new PathElement[]{StoreResourceDefinition.WILDCARD_PATH}).append(new PathElement[]{StringTableResourceDefinition.PATH}), operation);
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case PREFIX: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, StringTableResourceDefinition.Attribute.PREFIX);
                    continue block3;
                }
                default: {
                    this.parseJDBCStoreTableAttribute(reader, i, operation);
                }
            }
        }
        this.parseJDBCStoreTableElements(reader, operation);
    }

    private void parseJDBCStoreTableAttribute(XMLExtendedStreamReader reader, int index, ModelNode operation) throws XMLStreamException {
        XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(index));
        switch (attribute) {
            case FETCH_SIZE: {
                InfinispanSubsystemXMLReader.readAttribute(reader, index, operation, TableResourceDefinition.Attribute.FETCH_SIZE);
                break;
            }
            case BATCH_SIZE: {
                if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_5_0)) {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)index);
                }
                ClusteringLogger.ROOT_LOGGER.attributeIgnored(attribute.getLocalName(), reader.getLocalName());
                break;
            }
            case CREATE_ON_START: {
                if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_9_0)) {
                    InfinispanSubsystemXMLReader.readAttribute(reader, index, operation, TableResourceDefinition.Attribute.CREATE_ON_START);
                    break;
                }
            }
            case DROP_ON_STOP: {
                if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_9_0)) {
                    InfinispanSubsystemXMLReader.readAttribute(reader, index, operation, TableResourceDefinition.Attribute.DROP_ON_STOP);
                    break;
                }
            }
            default: {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)index);
            }
        }
    }

    private void parseJDBCStoreTableElements(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            XMLElement element = XMLElement.forName(reader.getLocalName());
            switch (element) {
                case ID_COLUMN: {
                    this.parseJDBCStoreColumn(reader, TableResourceDefinition.ColumnAttribute.ID, operation.get(TableResourceDefinition.ColumnAttribute.ID.getName()).setEmptyObject());
                    continue block6;
                }
                case DATA_COLUMN: {
                    this.parseJDBCStoreColumn(reader, TableResourceDefinition.ColumnAttribute.DATA, operation.get(TableResourceDefinition.ColumnAttribute.DATA.getName()).setEmptyObject());
                    continue block6;
                }
                case TIMESTAMP_COLUMN: {
                    this.parseJDBCStoreColumn(reader, TableResourceDefinition.ColumnAttribute.TIMESTAMP, operation.get(TableResourceDefinition.ColumnAttribute.TIMESTAMP.getName()).setEmptyObject());
                    continue block6;
                }
                case SEGMENT_COLUMN: {
                    if (!this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_10_0)) break;
                    this.parseJDBCStoreColumn(reader, TableResourceDefinition.ColumnAttribute.SEGMENT, operation.get(TableResourceDefinition.ColumnAttribute.SEGMENT.getName()).setEmptyObject());
                    continue block6;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseJDBCStoreColumn(XMLExtendedStreamReader reader, TableResourceDefinition.ColumnAttribute columnAttribute, ModelNode column) throws XMLStreamException {
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, column, columnAttribute.getColumnName());
                    continue block4;
                }
                case TYPE: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, column, columnAttribute.getColumnType());
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseStoreAttribute(XMLExtendedStreamReader reader, int index, ModelNode operation) throws XMLStreamException {
        XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(index));
        switch (attribute) {
            case SHARED: {
                InfinispanSubsystemXMLReader.readAttribute(reader, index, operation, StoreResourceDefinition.Attribute.SHARED);
                break;
            }
            case PRELOAD: {
                InfinispanSubsystemXMLReader.readAttribute(reader, index, operation, StoreResourceDefinition.Attribute.PRELOAD);
                break;
            }
            case PASSIVATION: {
                InfinispanSubsystemXMLReader.readAttribute(reader, index, operation, StoreResourceDefinition.Attribute.PASSIVATION);
                break;
            }
            case FETCH_STATE: {
                InfinispanSubsystemXMLReader.readAttribute(reader, index, operation, StoreResourceDefinition.DeprecatedAttribute.FETCH_STATE);
                break;
            }
            case PURGE: {
                InfinispanSubsystemXMLReader.readAttribute(reader, index, operation, StoreResourceDefinition.Attribute.PURGE);
                break;
            }
            case SINGLETON: {
                if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_14_0)) {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)index);
                }
                ClusteringLogger.ROOT_LOGGER.attributeIgnored(attribute.getLocalName(), reader.getLocalName());
                break;
            }
            case MAX_BATCH_SIZE: {
                if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_5_0)) {
                    InfinispanSubsystemXMLReader.readAttribute(reader, index, operation, StoreResourceDefinition.Attribute.MAX_BATCH_SIZE);
                    break;
                }
            }
            case SEGMENTED: {
                if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_14_0)) {
                    InfinispanSubsystemXMLReader.readAttribute(reader, index, operation, StoreResourceDefinition.Attribute.SEGMENTED);
                    break;
                }
            }
            default: {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)index);
            }
        }
    }

    private void parseStoreElement(XMLExtendedStreamReader reader, PathAddress storeAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        ModelNode operation = operations.get(storeAddress.getParent().append(new PathElement[]{StoreResourceDefinition.WILDCARD_PATH}));
        XMLElement element = XMLElement.forName(reader.getLocalName());
        switch (element) {
            case PROPERTY: {
                ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)XMLAttribute.NAME.getLocalName());
                InfinispanSubsystemXMLReader.readElement(reader, operation, StoreResourceDefinition.Attribute.PROPERTIES);
                break;
            }
            case WRITE_BEHIND: {
                this.parseStoreWriteBehind(reader, storeAddress, operations);
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
    }

    private void parseStoreWriteBehind(XMLExtendedStreamReader reader, PathAddress storeAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = storeAddress.append(new PathElement[]{StoreWriteBehindResourceDefinition.PATH});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(storeAddress.append(new PathElement[]{StoreWriteResourceDefinition.WILDCARD_PATH}), operation);
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case FLUSH_LOCK_TIMEOUT: {
                    if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_4_0)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    ClusteringLogger.ROOT_LOGGER.attributeIgnored(attribute.getLocalName(), reader.getLocalName());
                    continue block6;
                }
                case MODIFICATION_QUEUE_SIZE: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, StoreWriteBehindResourceDefinition.Attribute.MODIFICATION_QUEUE_SIZE);
                    continue block6;
                }
                case SHUTDOWN_TIMEOUT: {
                    if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_4_0)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    ClusteringLogger.ROOT_LOGGER.attributeIgnored(attribute.getLocalName(), reader.getLocalName());
                    continue block6;
                }
                case THREAD_POOL_SIZE: {
                    if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_11_0)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    ClusteringLogger.ROOT_LOGGER.attributeIgnored(attribute.getLocalName(), reader.getLocalName());
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private <P extends ThreadPoolDefinition & ResourceDefinitionProvider> void parseThreadPool(P pool, XMLExtendedStreamReader reader, PathAddress parentAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = parentAddress.append(new PathElement[]{((ResourceDefinitionProvider)pool).getPathElement()});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case MIN_THREADS: {
                    if (pool.getMinThreads() == null) continue block6;
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, pool.getMinThreads());
                    continue block6;
                }
                case MAX_THREADS: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, pool.getMaxThreads());
                    continue block6;
                }
                case QUEUE_LENGTH: {
                    if (pool.getQueueLength() == null) continue block6;
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, pool.getQueueLength());
                    continue block6;
                }
                case KEEPALIVE_TIME: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, pool.getKeepAliveTime());
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private <P extends ScheduledThreadPoolDefinition & ResourceDefinitionProvider> void parseScheduledThreadPool(P pool, XMLExtendedStreamReader reader, PathAddress parentAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = parentAddress.append(new PathElement[]{((ResourceDefinitionProvider)pool).getPathElement()});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case MAX_THREADS: {
                    if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_10_0)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, pool.getMinThreads());
                    continue block5;
                }
                case KEEPALIVE_TIME: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, pool.getKeepAliveTime());
                    continue block5;
                }
                case MIN_THREADS: {
                    if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_10_0)) {
                        InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, pool.getMinThreads());
                        continue block5;
                    }
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseRemoteContainer(XMLExtendedStreamReader reader, PathAddress subsystemAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        String name = InfinispanSubsystemXMLReader.require(reader, XMLAttribute.NAME);
        PathAddress address = subsystemAddress.append(new PathElement[]{RemoteCacheContainerResourceDefinition.pathElement(name)});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        block26: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    continue block26;
                }
                case CONNECTION_TIMEOUT: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, RemoteCacheContainerResourceDefinition.Attribute.CONNECTION_TIMEOUT);
                    continue block26;
                }
                case DEFAULT_REMOTE_CLUSTER: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, RemoteCacheContainerResourceDefinition.Attribute.DEFAULT_REMOTE_CLUSTER);
                    continue block26;
                }
                case KEY_SIZE_ESTIMATE: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, RemoteCacheContainerResourceDefinition.DeprecatedAttribute.KEY_SIZE_ESTIMATE);
                    continue block26;
                }
                case MAX_RETRIES: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, RemoteCacheContainerResourceDefinition.Attribute.MAX_RETRIES);
                    continue block26;
                }
                case MODULE: {
                    if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_12_0)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, RemoteCacheContainerResourceDefinition.ListAttribute.MODULES);
                    continue block26;
                }
                case PROTOCOL_VERSION: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, RemoteCacheContainerResourceDefinition.Attribute.PROTOCOL_VERSION);
                    continue block26;
                }
                case SOCKET_TIMEOUT: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, RemoteCacheContainerResourceDefinition.Attribute.SOCKET_TIMEOUT);
                    continue block26;
                }
                case TCP_NO_DELAY: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, RemoteCacheContainerResourceDefinition.Attribute.TCP_NO_DELAY);
                    continue block26;
                }
                case TCP_KEEP_ALIVE: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, RemoteCacheContainerResourceDefinition.Attribute.TCP_KEEP_ALIVE);
                    continue block26;
                }
                case VALUE_SIZE_ESTIMATE: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, RemoteCacheContainerResourceDefinition.DeprecatedAttribute.VALUE_SIZE_ESTIMATE);
                    continue block26;
                }
                case STATISTICS_ENABLED: {
                    if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_9_0)) {
                        InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, RemoteCacheContainerResourceDefinition.Attribute.STATISTICS_ENABLED);
                        continue block26;
                    }
                }
                case MODULES: {
                    if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_12_0)) {
                        InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, RemoteCacheContainerResourceDefinition.ListAttribute.MODULES);
                        continue block26;
                    }
                }
                case MARSHALLER: {
                    if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_13_0)) {
                        InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, RemoteCacheContainerResourceDefinition.Attribute.MARSHALLER);
                        continue block26;
                    }
                }
                case TRANSACTION_TIMEOUT: {
                    if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_13_0)) {
                        InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, RemoteCacheContainerResourceDefinition.Attribute.TRANSACTION_TIMEOUT);
                        continue block26;
                    }
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!operation.hasDefined(CacheContainerResourceDefinition.Attribute.MARSHALLER.getName()) && !this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_14_0)) {
            operation.get(CacheContainerResourceDefinition.Attribute.MARSHALLER.getName()).set(new ModelNode(InfinispanMarshallerFactory.LEGACY.name()));
        }
        block27: while (reader.hasNext() && reader.nextTag() != 2) {
            XMLElement element = XMLElement.forName(reader.getLocalName());
            switch (element) {
                case ASYNC_THREAD_POOL: {
                    this.parseThreadPool(ThreadPoolResourceDefinition.CLIENT, reader, address, operations);
                    continue block27;
                }
                case CONNECTION_POOL: {
                    this.parseConnectionPool(reader, address, operations);
                    continue block27;
                }
                case INVALIDATION_NEAR_CACHE: {
                    if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_14_0)) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    ClusteringLogger.ROOT_LOGGER.elementIgnored(reader.getLocalName());
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block27;
                }
                case REMOTE_CLUSTERS: {
                    this.parseRemoteClusters(reader, address, operations);
                    continue block27;
                }
                case SECURITY: {
                    this.parseRemoteCacheContainerSecurity(reader, address, operations);
                    continue block27;
                }
                case TRANSACTION: {
                    if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_14_0)) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    if (this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_8_0)) {
                        ClusteringLogger.ROOT_LOGGER.elementIgnored(reader.getLocalName());
                        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                        continue block27;
                    }
                }
                case PROPERTY: {
                    if (!this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_11_0) && (!this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_9_1) || this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_10_0))) break;
                    ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)XMLAttribute.NAME.getLocalName());
                    InfinispanSubsystemXMLReader.readElement(reader, operation, RemoteCacheContainerResourceDefinition.Attribute.PROPERTIES);
                    continue block27;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseConnectionPool(XMLExtendedStreamReader reader, PathAddress cacheAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = cacheAddress.append(new PathElement[]{ConnectionPoolResourceDefinition.PATH});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case EXHAUSTED_ACTION: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, ConnectionPoolResourceDefinition.Attribute.EXHAUSTED_ACTION);
                    continue block7;
                }
                case MAX_ACTIVE: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, ConnectionPoolResourceDefinition.Attribute.MAX_ACTIVE);
                    continue block7;
                }
                case MAX_WAIT: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, ConnectionPoolResourceDefinition.Attribute.MAX_WAIT);
                    continue block7;
                }
                case MIN_EVICTABLE_IDLE_TIME: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, ConnectionPoolResourceDefinition.Attribute.MIN_EVICTABLE_IDLE_TIME);
                    continue block7;
                }
                case MIN_IDLE: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, ConnectionPoolResourceDefinition.Attribute.MIN_IDLE);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseRemoteClusters(XMLExtendedStreamReader reader, PathAddress containerAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            XMLElement element = XMLElement.forName(reader.getLocalName());
            switch (element) {
                case REMOTE_CLUSTER: {
                    this.parseRemoteCluster(reader, containerAddress, operations);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseRemoteCluster(XMLExtendedStreamReader reader, PathAddress clustersAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        String remoteCluster = InfinispanSubsystemXMLReader.require(reader, XMLAttribute.NAME);
        PathAddress address = clustersAddress.append(new PathElement[]{RemoteClusterResourceDefinition.pathElement(remoteCluster)});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    continue block4;
                }
                case SOCKET_BINDINGS: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, RemoteClusterResourceDefinition.Attribute.SOCKET_BINDINGS);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseRemoteCacheContainerSecurity(XMLExtendedStreamReader reader, PathAddress containerAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = containerAddress.append(new PathElement[]{SecurityResourceDefinition.PATH});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SSL_CONTEXT: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, SecurityResourceDefinition.Attribute.SSL_CONTEXT);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private static String require(XMLExtendedStreamReader reader, XMLAttribute attribute) throws XMLStreamException {
        String value = reader.getAttributeValue(null, attribute.getLocalName());
        if (value == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, (String[])new String[]{attribute.getLocalName()});
        }
        return value;
    }

    private static void readAttribute(XMLExtendedStreamReader reader, int index, ModelNode operation, Attribute attribute) throws XMLStreamException {
        InfinispanSubsystemXMLReader.setAttribute(reader, reader.getAttributeValue(index), operation, attribute);
    }

    private static void setAttribute(XMLExtendedStreamReader reader, String value, ModelNode operation, Attribute attribute) throws XMLStreamException {
        AttributeDefinition definition = (AttributeDefinition)attribute.getDefinition();
        definition.getParser().parseAndSetParameter(definition, value, operation, (XMLStreamReader)reader);
    }

    private static void readElement(XMLExtendedStreamReader reader, ModelNode operation, Attribute attribute) throws XMLStreamException {
        AttributeDefinition definition = (AttributeDefinition)attribute.getDefinition();
        AttributeParser parser = definition.getParser();
        if (parser.isParseAsElement()) {
            parser.parseElement(definition, reader, operation);
        } else {
            parser.parseAndSetParameter(definition, reader.getElementText(), operation, (XMLStreamReader)reader);
        }
    }
}

