/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron.oidc;

import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceChangeListener;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.util.ETag;
import io.undertow.util.MimeMappings;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.server.mgmt.domain.ExtensibleHttpManagement;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.elytron.oidc.CredentialDefinition;
import org.wildfly.extension.elytron.oidc.ElytronOidcExtension;
import org.wildfly.extension.elytron.oidc.OidcConfigService;
import org.wildfly.extension.elytron.oidc.ProviderAttributeDefinitions;
import org.wildfly.extension.elytron.oidc.RedirectRewriteRuleDefinition;
import org.wildfly.extension.elytron.oidc.SecureDeploymentDefinition;
import org.wildfly.extension.elytron.oidc._private.ElytronOidcLogger;

class SecureServerDefinition
extends SimpleResourceDefinition {
    private static String HTTP_MANAGEMENT_CONTEXT = "http-management-context";

    SecureServerDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"secure-server"), ElytronOidcExtension.getResourceDescriptionResolver("secure-server")).setAddHandler((OperationStepHandler)SecureServerAddHandler.INSTANCE).setRemoveHandler((OperationStepHandler)SecureServerRemoveHandler.INSTANCE).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        for (AttributeDefinition attributeDefinition : SecureDeploymentDefinition.ALL_ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(attributeDefinition, null, (OperationStepHandler)SecureServerWriteAttributeHandler.INSTANCE);
        }
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerSubModel((ResourceDefinition)new CredentialDefinition());
        resourceRegistration.registerSubModel((ResourceDefinition)new RedirectRewriteRuleDefinition());
    }

    private static Service<Void> createHttpManagementConfigContextService(final String secureServerName, final InjectedValue<ExtensibleHttpManagement> httpConfigContext) {
        final String contextName = "/oidc/" + secureServerName + "/";
        return new Service<Void>(){

            public void start(StartContext startContext) throws StartException {
                ExtensibleHttpManagement extensibleHttpManagement = (ExtensibleHttpManagement)httpConfigContext.getValue();
                extensibleHttpManagement.addStaticContext(contextName, new ResourceManager(){

                    public Resource getResource(String path) throws IOException {
                        OidcConfigService oidcConfigService = OidcConfigService.getInstance();
                        final String config = oidcConfigService.getJSON(secureServerName, true);
                        if (config == null) {
                            return null;
                        }
                        return new Resource(){

                            public String getPath() {
                                return null;
                            }

                            public Date getLastModified() {
                                return null;
                            }

                            public String getLastModifiedString() {
                                return null;
                            }

                            public ETag getETag() {
                                return null;
                            }

                            public String getName() {
                                return null;
                            }

                            public boolean isDirectory() {
                                return false;
                            }

                            public List<Resource> list() {
                                return Collections.emptyList();
                            }

                            public String getContentType(MimeMappings mimeMappings) {
                                return "application/json";
                            }

                            public void serve(Sender sender, HttpServerExchange exchange, IoCallback completionCallback) {
                                sender.send(config);
                            }

                            public Long getContentLength() {
                                return config.length();
                            }

                            public String getCacheKey() {
                                return null;
                            }

                            public File getFile() {
                                return null;
                            }

                            public Path getFilePath() {
                                return null;
                            }

                            public File getResourceManagerRoot() {
                                return null;
                            }

                            public Path getResourceManagerRootPath() {
                                return null;
                            }

                            public URL getUrl() {
                                return null;
                            }
                        };
                    }

                    public boolean isResourceChangeListenerSupported() {
                        return false;
                    }

                    public void registerResourceChangeListener(ResourceChangeListener listener) {
                    }

                    public void removeResourceChangeListener(ResourceChangeListener listener) {
                    }

                    public void close() throws IOException {
                    }
                });
            }

            public void stop(StopContext stopContext) {
                ((ExtensibleHttpManagement)httpConfigContext.getValue()).removeContext(contextName);
            }

            public Void getValue() throws IllegalStateException, IllegalArgumentException {
                return null;
            }
        };
    }

    static class SecureServerRemoveHandler
    extends AbstractRemoveStepHandler {
        public static SecureServerRemoveHandler INSTANCE = new SecureServerRemoveHandler();

        SecureServerRemoveHandler() {
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            OidcConfigService oidcConfigService = OidcConfigService.getInstance();
            oidcConfigService.removeSecureDeployment(context.getCurrentAddressValue());
        }
    }

    static class SecureServerWriteAttributeHandler
    extends AbstractWriteAttributeHandler<OidcConfigService> {
        public static final SecureServerWriteAttributeHandler INSTANCE = new SecureServerWriteAttributeHandler();

        SecureServerWriteAttributeHandler() {
            super((AttributeDefinition[])SecureDeploymentDefinition.ALL_ATTRIBUTES.toArray(new SimpleAttributeDefinition[SecureDeploymentDefinition.ALL_ATTRIBUTES.size()]));
        }

        protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<OidcConfigService> handbackHolder) throws OperationFailedException {
            OidcConfigService oidcConfigService = OidcConfigService.getInstance();
            oidcConfigService.updateSecureDeployment(context.getCurrentAddressValue(), attributeName, resolvedValue);
            handbackHolder.setHandback((Object)oidcConfigService);
            return false;
        }

        protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, OidcConfigService oidcConfigService) throws OperationFailedException {
            oidcConfigService.updateSecureDeployment(context.getCurrentAddressValue(), attributeName, valueToRestore);
        }
    }

    static class SecureServerAddHandler
    extends AbstractAddStepHandler {
        public static SecureServerAddHandler INSTANCE = new SecureServerAddHandler();
        static final String HTTP_MANAGEMENT_HTTP_EXTENSIBLE_CAPABILITY = "org.wildfly.management.http.extensible";

        private SecureServerAddHandler() {
            super(SecureDeploymentDefinition.ALL_ATTRIBUTES);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            super.performRuntime(context, operation, model);
            String clientId = SecureDeploymentDefinition.CLIENT_ID.resolveModelAttribute(context, model).asStringOrNull();
            String resource = SecureDeploymentDefinition.RESOURCE.resolveModelAttribute(context, model).asStringOrNull();
            if (clientId == null && resource == null) {
                throw ElytronOidcLogger.ROOT_LOGGER.resourceOrClientIdMustBeConfigured();
            }
            boolean disableTrustManager = ProviderAttributeDefinitions.DISABLE_TRUST_MANAGER.resolveModelAttribute(context, model).asBoolean();
            if (disableTrustManager) {
                ElytronOidcLogger.ROOT_LOGGER.disableTrustManagerSetToTrue();
            }
            OidcConfigService oidcConfigService = OidcConfigService.getInstance();
            oidcConfigService.addSecureDeployment(context.getCurrentAddressValue(), context.resolveExpressions(model));
            ServiceTarget serviceTarget = context.getServiceTarget();
            InjectedValue extensibleHttpManagement = new InjectedValue();
            String secureServerName = context.getCurrentAddressValue();
            ServiceName serviceName = ServiceName.of((String[])new String[]{"secure-server", secureServerName});
            serviceTarget.addService(serviceName.append(new String[]{HTTP_MANAGEMENT_CONTEXT}), SecureServerDefinition.createHttpManagementConfigContextService(secureServerName, (InjectedValue<ExtensibleHttpManagement>)extensibleHttpManagement)).addDependency(context.getCapabilityServiceName(HTTP_MANAGEMENT_HTTP_EXTENSIBLE_CAPABILITY, ExtensibleHttpManagement.class), ExtensibleHttpManagement.class, (Injector)extensibleHttpManagement).setInitialMode(ServiceController.Mode.ACTIVE).install();
        }
    }
}

