/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.deployment;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.ee.structure.JBossDescriptorPropertyReplacement;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLMapper;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;
import org.wildfly.extension.messaging.activemq.deployment.MessagingAttachments;
import org.wildfly.extension.messaging.activemq.deployment.MessagingDeploymentParser_1_0;
import org.wildfly.extension.messaging.activemq.deployment.Namespace;
import org.wildfly.extension.messaging.activemq.deployment.ParseResult;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

public class MessagingXmlParsingDeploymentUnitProcessor
implements DeploymentUnitProcessor {
    private static final XMLInputFactory INPUT_FACTORY = XMLInputFactory.newInstance();
    private static final String[] LOCATIONS = new String[]{"WEB-INF", "META-INF"};
    private static final QName ROOT_1_0 = new QName(Namespace.MESSAGING_DEPLOYMENT_1_0.getUriString(), "messaging-deployment");
    private static final QName ROOT_NO_NAMESPACE = new QName("messaging-deployment");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        Set<VirtualFile> files = this.messageDestinations(deploymentUnit);
        XMLMapper mapper = XMLMapper.Factory.create();
        MessagingDeploymentParser_1_0 messagingDeploymentParser_1_0 = new MessagingDeploymentParser_1_0(JBossDescriptorPropertyReplacement.propertyReplacer((DeploymentUnit)deploymentUnit));
        mapper.registerRootElement(ROOT_1_0, (XMLElementReader)messagingDeploymentParser_1_0);
        mapper.registerRootElement(ROOT_NO_NAMESPACE, (XMLElementReader)messagingDeploymentParser_1_0);
        for (VirtualFile file : files) {
            FileInputStream xmlStream = null;
            try {
                File f = file.getPhysicalFile();
                xmlStream = new FileInputStream(f);
                try {
                    XMLInputFactory inputFactory = INPUT_FACTORY;
                    this.setIfSupported(inputFactory, "javax.xml.stream.isValidating", Boolean.FALSE);
                    this.setIfSupported(inputFactory, "javax.xml.stream.supportDTD", Boolean.FALSE);
                    XMLStreamReader streamReader = inputFactory.createXMLStreamReader(xmlStream);
                    ParseResult result = new ParseResult();
                    try {
                        mapper.parseDocument((Object)result, streamReader);
                        deploymentUnit.addToAttachmentList(MessagingAttachments.PARSE_RESULT, (Object)result);
                    }
                    finally {
                        MessagingXmlParsingDeploymentUnitProcessor.safeClose(streamReader, f.getAbsolutePath());
                    }
                }
                catch (XMLStreamException e) {
                    throw MessagingLogger.ROOT_LOGGER.couldNotParseDeployment(f.getPath(), (Throwable)e);
                }
            }
            catch (Exception e) {
                try {
                    throw new DeploymentUnitProcessingException(e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    VFSUtils.safeClose(xmlStream);
                    throw throwable;
                }
            }
            VFSUtils.safeClose((Closeable)xmlStream);
        }
    }

    private void setIfSupported(XMLInputFactory inputFactory, String property, Object value) {
        if (inputFactory.isPropertySupported(property)) {
            inputFactory.setProperty(property, value);
        }
    }

    private Set<VirtualFile> messageDestinations(DeploymentUnit deploymentUnit) {
        VirtualFile deploymentRoot = ((ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot();
        if (deploymentRoot == null || !deploymentRoot.exists()) {
            return Collections.emptySet();
        }
        String deploymentRootName = deploymentRoot.getName().toLowerCase(Locale.ENGLISH);
        if (deploymentRootName.endsWith("-jms.xml")) {
            return Collections.singleton(deploymentRoot);
        }
        HashSet<VirtualFile> ret = new HashSet<VirtualFile>();
        for (String location : LOCATIONS) {
            VirtualFile loc = deploymentRoot.getChild(location);
            if (!loc.exists()) continue;
            for (VirtualFile file : loc.getChildren()) {
                if (!file.getName().endsWith("-jms.xml")) continue;
                ret.add(file);
            }
        }
        return ret;
    }

    private static void safeClose(XMLStreamReader closeable, String file) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (XMLStreamException e) {
                MessagingLogger.ROOT_LOGGER.couldNotCloseFile(file, (Throwable)e);
            }
        }
    }
}

