/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.spi;

import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.NoResultException;
import jakarta.persistence.Parameter;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Tuple;
import jakarta.persistence.criteria.CompoundSelection;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Calendar;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.NonUniqueResultException;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.TypeMismatchException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.graph.spi.AppliedGraph;
import org.hibernate.jpa.internal.util.LockModeTypeHelper;
import org.hibernate.metamodel.model.domain.BasicDomainType;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.query.BindableType;
import org.hibernate.query.IllegalQueryOperationException;
import org.hibernate.query.QueryParameter;
import org.hibernate.query.QueryTypeMismatchException;
import org.hibernate.query.SelectionQuery;
import org.hibernate.query.criteria.JpaSelection;
import org.hibernate.query.internal.ScrollableResultsIterator;
import org.hibernate.query.named.NamedQueryMemento;
import org.hibernate.query.spi.AbstractCommonQueryContract;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.spi.MutableQueryOptions;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.spi.NamedSqmQueryMemento;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.select.SqmQueryGroup;
import org.hibernate.query.sqm.tree.select.SqmQueryPart;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelection;
import org.hibernate.sql.exec.internal.CallbackImpl;
import org.hibernate.sql.exec.spi.Callback;
import org.hibernate.sql.results.internal.TupleMetadata;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.PrimitiveJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public abstract class AbstractSelectionQuery<R>
extends AbstractCommonQueryContract
implements SelectionQuery<R>,
DomainQueryExecutionContext {
    public static final String CRITERIA_HQL_STRING = "<criteria>";
    private Callback callback;
    private FlushMode sessionFlushMode;
    private CacheMode sessionCacheMode;

    public AbstractSelectionQuery(SharedSessionContractImplementor session) {
        super(session);
    }

    protected TupleMetadata buildTupleMetadata(SqmStatement<?> statement, Class<R> resultType) {
        if (resultType != null && Tuple.class.isAssignableFrom(resultType)) {
            List<SqmSelection<?>> selections = ((SqmQueryPart)((SqmSelectStatement)statement).getQueryPart()).getFirstQuerySpec().getSelectClause().getSelections();
            if (this.getQueryOptions().getTupleTransformer() == null) {
                IdentityHashMap<Object, Integer> tupleElementMap;
                if (selections.size() == 1 && selections.get(0).getSelectableNode() instanceof CompoundSelection) {
                    List<JpaSelection<?>> selectionItems = selections.get(0).getSelectableNode().getSelectionItems();
                    tupleElementMap = new IdentityHashMap(selectionItems.size());
                    for (int i = 0; i < selectionItems.size(); ++i) {
                        tupleElementMap.put(selectionItems.get(i), i);
                    }
                } else {
                    tupleElementMap = new IdentityHashMap(selections.size());
                    for (int i = 0; i < selections.size(); ++i) {
                        SqmSelection<?> selection = selections.get(i);
                        tupleElementMap.put(selection.getSelectableNode(), i);
                    }
                }
                return new TupleMetadata(tupleElementMap);
            }
            throw new IllegalArgumentException("Illegal combination of Tuple resultType and (non-JpaTupleBuilder) TupleTransformer : " + this.getQueryOptions().getTupleTransformer());
        }
        return null;
    }

    protected void applyOptions(NamedSqmQueryMemento memento) {
        this.applyOptions((NamedQueryMemento)memento);
        if (memento.getFirstResult() != null) {
            this.setFirstResult(memento.getFirstResult());
        }
        if (memento.getMaxResults() != null) {
            this.setMaxResults(memento.getMaxResults());
        }
        if (memento.getParameterTypes() != null) {
            for (Map.Entry<String, String> entry : memento.getParameterTypes().entrySet()) {
                QueryParameter parameter = this.getParameterMetadata().getQueryParameter(entry.getKey());
                BasicType type = this.getSessionFactory().getTypeConfiguration().getBasicTypeRegistry().getRegisteredType(entry.getValue());
                parameter.applyAnticipatedType(type);
            }
        }
    }

    protected void applyOptions(NamedQueryMemento memento) {
        if (memento.getHints() != null) {
            memento.getHints().forEach(this::applyHint);
        }
        if (memento.getCacheable() != null) {
            this.setCacheable(memento.getCacheable());
        }
        if (memento.getCacheRegion() != null) {
            this.setCacheRegion(memento.getCacheRegion());
        }
        if (memento.getCacheMode() != null) {
            this.setCacheMode(memento.getCacheMode());
        }
        if (memento.getFlushMode() != null) {
            this.setHibernateFlushMode(memento.getFlushMode());
        }
        if (memento.getReadOnly() != null) {
            this.setReadOnly(memento.getReadOnly());
        }
        if (memento.getTimeout() != null) {
            this.setTimeout(memento.getTimeout());
        }
        if (memento.getFetchSize() != null) {
            this.setFetchSize(memento.getFetchSize());
        }
        if (memento.getComment() != null) {
            this.setComment(memento.getComment());
        }
    }

    protected abstract String getQueryString();

    protected void visitQueryReturnType(SqmQueryPart<R> queryPart, Class<R> resultType, SessionFactoryImplementor factory) {
        assert (this.getQueryString().equals(CRITERIA_HQL_STRING));
        if (queryPart instanceof SqmQuerySpec) {
            SqmQuerySpec sqmQuerySpec = (SqmQuerySpec)queryPart;
            List<SqmSelection<?>> sqmSelections = sqmQuerySpec.getSelectClause().getSelections();
            if (sqmSelections == null || sqmSelections.isEmpty()) {
                List<SqmRoot<?>> sqmRoots = sqmQuerySpec.getFromClause().getRoots();
                if (sqmRoots == null || sqmRoots.isEmpty()) {
                    throw new IllegalArgumentException("Criteria did not define any query roots");
                }
                if (sqmRoots.size() == 1) {
                    SqmRoot<?> sqmRoot = sqmRoots.get(0);
                    sqmQuerySpec.getSelectClause().add(sqmRoot, (String)null);
                } else {
                    throw new IllegalArgumentException();
                }
            }
            if (resultType != null) {
                AbstractSelectionQuery.checkQueryReturnType(sqmQuerySpec, resultType, factory);
            }
        } else {
            SqmQueryGroup queryGroup = (SqmQueryGroup)queryPart;
            for (SqmQueryPart sqmQueryPart : queryGroup.getQueryParts()) {
                this.visitQueryReturnType(sqmQueryPart, resultType, factory);
            }
        }
    }

    protected static <T> void checkQueryReturnType(SqmQuerySpec<T> querySpec, Class<T> resultClass, SessionFactoryImplementor sessionFactory) {
        if (resultClass == null || resultClass == Object.class) {
            return;
        }
        List<SqmSelection<?>> selections = querySpec.getSelectClause().getSelections();
        if (!resultClass.isArray() && !Tuple.class.isAssignableFrom(resultClass)) {
            SqmParameter sqmParameter;
            boolean jpaQueryComplianceEnabled = sessionFactory.getSessionFactoryOptions().getJpaCompliance().isJpaQueryComplianceEnabled();
            if (selections.size() != 1) {
                String errorMessage = "Query result-type error - multiple selections: use Tuple or array";
                if (jpaQueryComplianceEnabled) {
                    throw new IllegalArgumentException("Query result-type error - multiple selections: use Tuple or array");
                }
                throw new QueryTypeMismatchException("Query result-type error - multiple selections: use Tuple or array");
            }
            SqmSelection<?> sqmSelection = selections.get(0);
            if (sqmSelection.getSelectableNode() instanceof SqmParameter && ((sqmParameter = (SqmParameter)sqmSelection.getSelectableNode()).getNodeType() == null || sqmParameter.getNodeType().getExpressibleJavaType() == null)) {
                return;
            }
            if (jpaQueryComplianceEnabled) {
                return;
            }
            AbstractSelectionQuery.verifyResultType(resultClass, sqmSelection.getNodeType(), sessionFactory);
        }
    }

    protected static <T> void verifyResultType(Class<T> resultClass, SqmExpressible<?> sqmExpressible, SessionFactoryImplementor sessionFactory) {
        assert (sqmExpressible != null);
        JavaType<?> expressibleJavaType = sqmExpressible.getExpressibleJavaType();
        assert (expressibleJavaType != null);
        Class<?> javaTypeClass = expressibleJavaType.getJavaTypeClass();
        if (!resultClass.isAssignableFrom(javaTypeClass)) {
            if (expressibleJavaType instanceof PrimitiveJavaType) {
                if (((PrimitiveJavaType)expressibleJavaType).getPrimitiveClass() == resultClass) {
                    return;
                }
                AbstractSelectionQuery.throwQueryTypeMismatchException(resultClass, sqmExpressible);
            }
            if (javaTypeClass == java.util.Date.class) {
                DomainType<?> domainType;
                JdbcType jdbcType = null;
                if (sqmExpressible instanceof BasicDomainType) {
                    jdbcType = ((BasicDomainType)sqmExpressible).getJdbcType();
                } else if (sqmExpressible instanceof SqmPathSource && (domainType = ((SqmPathSource)sqmExpressible).getSqmPathType()) instanceof BasicDomainType) {
                    jdbcType = ((BasicDomainType)domainType).getJdbcType();
                }
                if (jdbcType != null) {
                    switch (jdbcType.getDefaultSqlTypeCode()) {
                        case 91: {
                            if (!resultClass.isAssignableFrom(Date.class)) break;
                            return;
                        }
                        case 92: {
                            if (!resultClass.isAssignableFrom(Time.class)) break;
                            return;
                        }
                        case 93: {
                            if (!resultClass.isAssignableFrom(Timestamp.class)) break;
                            return;
                        }
                    }
                }
            }
            AbstractSelectionQuery.throwQueryTypeMismatchException(resultClass, sqmExpressible);
        }
    }

    private static <T> void throwQueryTypeMismatchException(Class<T> resultClass, SqmExpressible<?> sqmExpressible) {
        String errorMessage = String.format("Specified result type [%s] did not match Query selection type [%s] - multiple selections: use Tuple or array", resultClass.getName(), sqmExpressible.getExpressibleJavaType().getJavaType().getTypeName());
        throw new QueryTypeMismatchException(errorMessage);
    }

    @Override
    public List<R> list() {
        this.beforeQuery();
        boolean success = false;
        try {
            List<R> result = this.doList();
            success = true;
            List<R> list = result;
            return list;
        }
        catch (IllegalQueryOperationException e) {
            throw new IllegalStateException((Throwable)((Object)e));
        }
        catch (TypeMismatchException e) {
            throw new IllegalArgumentException((Throwable)((Object)e));
        }
        catch (HibernateException he) {
            throw this.getSession().getExceptionConverter().convert(he, this.getQueryOptions().getLockOptions());
        }
        finally {
            this.afterQuery(success);
        }
    }

    protected void beforeQuery() {
        CacheMode effectiveCacheMode;
        this.getQueryParameterBindings().validate();
        this.getSession().prepareForQueryExecution(this.requiresTxn(this.getQueryOptions().getLockOptions().findGreatestLockMode()));
        this.prepareForExecution();
        assert (this.sessionFlushMode == null);
        assert (this.sessionCacheMode == null);
        FlushMode effectiveFlushMode = this.getHibernateFlushMode();
        if (effectiveFlushMode != null) {
            this.sessionFlushMode = this.getSession().getHibernateFlushMode();
            this.getSession().setHibernateFlushMode(effectiveFlushMode);
        }
        if ((effectiveCacheMode = this.getCacheMode()) != null) {
            this.sessionCacheMode = this.getSession().getCacheMode();
            this.getSession().setCacheMode(effectiveCacheMode);
        }
    }

    protected abstract void prepareForExecution();

    protected void afterQuery(boolean success) {
        this.afterQuery();
        if (!this.getSession().isTransactionInProgress()) {
            this.getSession().getJdbcCoordinator().getLogicalConnection().afterTransaction();
        }
        this.getSession().afterOperation(success);
    }

    protected void afterQuery() {
        if (this.sessionFlushMode != null) {
            this.getSession().setHibernateFlushMode(this.sessionFlushMode);
            this.sessionFlushMode = null;
        }
        if (this.sessionCacheMode != null) {
            this.getSession().setCacheMode(this.sessionCacheMode);
            this.sessionCacheMode = null;
        }
    }

    protected boolean requiresTxn(LockMode lockMode) {
        return lockMode != null && lockMode.greaterThan(LockMode.READ);
    }

    protected abstract List<R> doList();

    @Override
    public ScrollableResultsImplementor<R> scroll() {
        return this.scroll(this.getSession().getFactory().getJdbcServices().getJdbcEnvironment().getDialect().defaultScrollMode());
    }

    @Override
    public ScrollableResultsImplementor<R> scroll(ScrollMode scrollMode) {
        this.beforeQuery();
        try {
            ScrollableResultsImplementor<R> scrollableResultsImplementor = this.doScroll(scrollMode);
            return scrollableResultsImplementor;
        }
        finally {
            this.afterQuery();
        }
    }

    protected abstract ScrollableResultsImplementor<R> doScroll(ScrollMode var1);

    @Override
    public Stream stream() {
        ScrollableResults scrollableResults = this.scroll(ScrollMode.FORWARD_ONLY);
        ScrollableResultsIterator iterator = new ScrollableResultsIterator(scrollableResults);
        Spliterator spliterator = Spliterators.spliteratorUnknownSize(iterator, 256);
        Stream stream = StreamSupport.stream(spliterator, false);
        return (Stream)stream.onClose(((ScrollableResultsImplementor)scrollableResults)::close);
    }

    @Override
    public R uniqueResult() {
        return AbstractSelectionQuery.uniqueElement(this.list());
    }

    @Override
    public R getSingleResult() {
        try {
            List<R> list = this.list();
            if (list.isEmpty()) {
                throw new NoResultException(String.format("No result found for query [%s]", this.getQueryString()));
            }
            return AbstractSelectionQuery.uniqueElement(list);
        }
        catch (HibernateException e) {
            throw this.getSession().getExceptionConverter().convert(e, this.getQueryOptions().getLockOptions());
        }
    }

    protected static <T> T uniqueElement(List<T> list) throws NonUniqueResultException {
        int size = list.size();
        if (size == 0) {
            return null;
        }
        T first = list.get(0);
        for (int i = 1; i < size; ++i) {
            if (list.get(i) == first) continue;
            throw new NonUniqueResultException(list.size());
        }
        return first;
    }

    @Override
    public Optional<R> uniqueResultOptional() {
        return Optional.ofNullable(this.uniqueResult());
    }

    @Override
    public R getSingleResultOrNull() {
        try {
            return AbstractSelectionQuery.uniqueElement(this.list());
        }
        catch (HibernateException e) {
            throw this.getSession().getExceptionConverter().convert(e, this.getLockOptions());
        }
    }

    protected static boolean hasLimit(SqmSelectStatement<?> sqm, MutableQueryOptions queryOptions) {
        return queryOptions.hasLimit() || sqm.getFetch() != null || sqm.getOffset() != null;
    }

    protected static boolean hasAppliedGraph(MutableQueryOptions queryOptions) {
        return queryOptions.getAppliedGraph() != null && queryOptions.getAppliedGraph().getSemantic() != null;
    }

    @Override
    public Callback getCallback() {
        if (this.callback == null) {
            this.callback = new CallbackImpl();
        }
        return this.callback;
    }

    protected void resetCallback() {
        this.callback = null;
    }

    @Override
    public FlushModeType getFlushMode() {
        return this.getQueryOptions().getFlushMode().toJpaFlushMode();
    }

    @Override
    public SelectionQuery<R> setFlushMode(FlushModeType flushMode) {
        this.getQueryOptions().setFlushMode(FlushMode.fromJpaFlushMode(flushMode));
        return this;
    }

    @Override
    public SelectionQuery<R> setMaxResults(int maxResult) {
        super.applyMaxResults(maxResult);
        return this;
    }

    @Override
    public SelectionQuery<R> setFirstResult(int startPosition) {
        this.getSession().checkOpen();
        if (startPosition < 0) {
            throw new IllegalArgumentException("first-result value cannot be negative : " + startPosition);
        }
        this.getQueryOptions().getLimit().setFirstRow(startPosition);
        return this;
    }

    @Override
    public SelectionQuery<R> setHint(String hintName, Object value) {
        super.setHint(hintName, value);
        return this;
    }

    @Override
    public LockOptions getLockOptions() {
        return this.getQueryOptions().getLockOptions();
    }

    @Override
    public LockModeType getLockMode() {
        return LockModeTypeHelper.getLockModeType(this.getHibernateLockMode());
    }

    @Override
    public SelectionQuery<R> setLockMode(LockModeType lockMode) {
        this.setHibernateLockMode(LockModeTypeHelper.getLockMode(lockMode));
        return this;
    }

    @Override
    public SelectionQuery<R> setLockMode(String alias, LockMode lockMode) {
        this.getQueryOptions().getLockOptions().setAliasSpecificLockMode(alias, lockMode);
        return this;
    }

    @Override
    public LockMode getHibernateLockMode() {
        return this.getLockOptions().getLockMode();
    }

    @Override
    public SelectionQuery<R> setHibernateLockMode(LockMode lockMode) {
        this.getLockOptions().setLockMode(lockMode);
        return this;
    }

    @Override
    @Deprecated
    public SelectionQuery<R> setAliasSpecificLockMode(String alias, LockMode lockMode) {
        this.getLockOptions().setAliasSpecificLockMode(alias, lockMode);
        return this;
    }

    @Override
    public SelectionQuery<R> setFollowOnLocking(boolean enable) {
        this.getLockOptions().setFollowOnLocking(enable);
        return this;
    }

    @Override
    protected void collectHints(Map<String, Object> hints) {
        AppliedGraph appliedGraph;
        super.collectHints(hints);
        if (this.isReadOnly()) {
            hints.put("org.hibernate.readOnly", true);
        }
        this.putIfNotNull(hints, "org.hibernate.fetchSize", this.getFetchSize());
        if (this.isCacheable()) {
            hints.put("org.hibernate.cacheable", true);
            this.putIfNotNull(hints, "org.hibernate.cacheRegion", this.getCacheRegion());
            this.putIfNotNull(hints, "org.hibernate.cacheMode", this.getCacheMode());
            this.putIfNotNull(hints, "jakarta.persistence.cache.retrieveMode", (Enum<?>)this.getQueryOptions().getCacheRetrieveMode());
            this.putIfNotNull(hints, "jakarta.persistence.cache.storeMode", (Enum<?>)this.getQueryOptions().getCacheStoreMode());
            this.putIfNotNull(hints, "javax.persistence.cache.retrieveMode", (Enum<?>)this.getQueryOptions().getCacheRetrieveMode());
            this.putIfNotNull(hints, "javax.persistence.cache.storeMode", (Enum<?>)this.getQueryOptions().getCacheStoreMode());
        }
        if ((appliedGraph = this.getQueryOptions().getAppliedGraph()) != null && appliedGraph.getSemantic() != null) {
            hints.put(appliedGraph.getSemantic().getJakartaHintName(), appliedGraph);
            hints.put(appliedGraph.getSemantic().getJpaHintName(), appliedGraph);
        }
        this.putIfNotNull(hints, "hibernate.query.followOnLocking", this.getQueryOptions().getLockOptions().getFollowOnLocking());
    }

    @Override
    public Integer getFetchSize() {
        return this.getQueryOptions().getFetchSize();
    }

    @Override
    public SelectionQuery<R> setFetchSize(int fetchSize) {
        this.getQueryOptions().setFetchSize(fetchSize);
        return this;
    }

    @Override
    public boolean isReadOnly() {
        return this.getQueryOptions().isReadOnly() == null ? this.getSession().isDefaultReadOnly() : this.getQueryOptions().isReadOnly().booleanValue();
    }

    @Override
    public SelectionQuery<R> setReadOnly(boolean readOnly) {
        this.getQueryOptions().setReadOnly(readOnly);
        return this;
    }

    @Override
    public CacheMode getCacheMode() {
        return this.getQueryOptions().getCacheMode();
    }

    @Override
    public CacheStoreMode getCacheStoreMode() {
        return this.getCacheMode().getJpaStoreMode();
    }

    @Override
    public CacheRetrieveMode getCacheRetrieveMode() {
        return this.getCacheMode().getJpaRetrieveMode();
    }

    @Override
    public SelectionQuery<R> setCacheMode(CacheMode cacheMode) {
        this.getQueryOptions().setCacheMode(cacheMode);
        return this;
    }

    @Override
    public SelectionQuery<R> setCacheRetrieveMode(CacheRetrieveMode cacheRetrieveMode) {
        return this.setCacheMode(CacheMode.fromJpaModes(cacheRetrieveMode, this.getQueryOptions().getCacheMode().getJpaStoreMode()));
    }

    @Override
    public SelectionQuery<R> setCacheStoreMode(CacheStoreMode cacheStoreMode) {
        return this.setCacheMode(CacheMode.fromJpaModes(this.getQueryOptions().getCacheMode().getJpaRetrieveMode(), cacheStoreMode));
    }

    @Override
    public boolean isCacheable() {
        return this.getQueryOptions().isResultCachingEnabled() == Boolean.TRUE;
    }

    @Override
    public SelectionQuery<R> setCacheable(boolean cacheable) {
        this.getQueryOptions().setResultCachingEnabled(cacheable);
        return this;
    }

    @Override
    public String getCacheRegion() {
        return this.getQueryOptions().getResultCacheRegionName();
    }

    @Override
    public SelectionQuery<R> setCacheRegion(String regionName) {
        this.getQueryOptions().setResultCacheRegionName(regionName);
        return this;
    }

    @Override
    public SelectionQuery<R> setHibernateFlushMode(FlushMode flushMode) {
        super.setHibernateFlushMode(flushMode);
        return this;
    }

    @Override
    public SelectionQuery<R> setTimeout(int timeout) {
        super.setTimeout(timeout);
        return this;
    }

    @Override
    public SelectionQuery<R> setComment(String comment) {
        super.setComment(comment);
        return this;
    }

    @Override
    public SelectionQuery<R> setParameter(String name, Object value) {
        super.setParameter(name, value);
        return this;
    }

    @Override
    public <P> SelectionQuery<R> setParameter(String name, P value, Class<P> javaType) {
        super.setParameter(name, value, javaType);
        return this;
    }

    @Override
    public <P> SelectionQuery<R> setParameter(String name, P value, BindableType<P> type) {
        super.setParameter(name, value, type);
        return this;
    }

    @Override
    public SelectionQuery<R> setParameter(String name, Instant value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public SelectionQuery<R> setParameter(int position, Object value) {
        super.setParameter(position, value);
        return this;
    }

    @Override
    public <P> SelectionQuery<R> setParameter(int position, P value, Class<P> javaType) {
        super.setParameter(position, value, javaType);
        return this;
    }

    @Override
    public <P> SelectionQuery<R> setParameter(int position, P value, BindableType<P> type) {
        super.setParameter(position, value, type);
        return this;
    }

    @Override
    public SelectionQuery<R> setParameter(int position, Instant value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public <P> SelectionQuery<R> setParameter(QueryParameter<P> parameter, P value) {
        super.setParameter(parameter, value);
        return this;
    }

    @Override
    public <P> SelectionQuery<R> setParameter(QueryParameter<P> parameter, P value, Class<P> javaType) {
        super.setParameter(parameter, value, javaType);
        return this;
    }

    @Override
    public <P> SelectionQuery<R> setParameter(QueryParameter<P> parameter, P value, BindableType<P> type) {
        super.setParameter(parameter, value, type);
        return this;
    }

    @Override
    public <P> SelectionQuery<R> setParameter(Parameter<P> parameter, P value) {
        super.setParameter(parameter, value);
        return this;
    }

    @Override
    public SelectionQuery<R> setParameter(Parameter<Calendar> param, Calendar value, TemporalType temporalType) {
        super.setParameter(param, value, temporalType);
        return this;
    }

    @Override
    public SelectionQuery<R> setParameter(Parameter<java.util.Date> param, java.util.Date value, TemporalType temporalType) {
        super.setParameter(param, value, temporalType);
        return this;
    }

    @Override
    public SelectionQuery<R> setParameter(String name, Calendar value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public SelectionQuery<R> setParameter(String name, java.util.Date value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public SelectionQuery<R> setParameter(int position, Calendar value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public SelectionQuery<R> setParameter(int position, java.util.Date value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public SelectionQuery<R> setParameterList(String name, Collection values) {
        super.setParameterList(name, values);
        return this;
    }

    @Override
    public <P> SelectionQuery<R> setParameterList(String name, Collection<? extends P> values, Class<P> javaType) {
        super.setParameterList(name, values, javaType);
        return this;
    }

    @Override
    public <P> SelectionQuery<R> setParameterList(String name, Collection<? extends P> values, BindableType<P> type) {
        super.setParameterList(name, values, type);
        return this;
    }

    @Override
    public SelectionQuery<R> setParameterList(String name, Object[] values) {
        super.setParameterList(name, values);
        return this;
    }

    @Override
    public <P> SelectionQuery<R> setParameterList(String name, P[] values, Class<P> javaType) {
        super.setParameterList(name, values, javaType);
        return this;
    }

    @Override
    public <P> SelectionQuery<R> setParameterList(String name, P[] values, BindableType<P> type) {
        super.setParameterList(name, values, type);
        return this;
    }

    @Override
    public SelectionQuery<R> setParameterList(int position, Collection values) {
        super.setParameterList(position, values);
        return this;
    }

    @Override
    public <P> SelectionQuery<R> setParameterList(int position, Collection<? extends P> values, Class<P> javaType) {
        super.setParameterList(position, values, javaType);
        return this;
    }

    @Override
    public <P> SelectionQuery<R> setParameterList(int position, Collection<? extends P> values, BindableType<P> type) {
        super.setParameterList(position, values, type);
        return this;
    }

    @Override
    public SelectionQuery<R> setParameterList(int position, Object[] values) {
        super.setParameterList(position, values);
        return this;
    }

    @Override
    public <P> SelectionQuery<R> setParameterList(int position, P[] values, Class<P> javaType) {
        super.setParameterList(position, values, javaType);
        return this;
    }

    @Override
    public <P> SelectionQuery<R> setParameterList(int position, P[] values, BindableType<P> type) {
        super.setParameterList(position, values, type);
        return this;
    }

    @Override
    public <P> SelectionQuery<R> setParameterList(QueryParameter<P> parameter, Collection<? extends P> values) {
        super.setParameterList(parameter, values);
        return this;
    }

    @Override
    public <P> SelectionQuery<R> setParameterList(QueryParameter<P> parameter, Collection<? extends P> values, Class<P> javaType) {
        super.setParameterList(parameter, values, javaType);
        return this;
    }

    @Override
    public <P> SelectionQuery<R> setParameterList(QueryParameter<P> parameter, Collection<? extends P> values, BindableType<P> type) {
        super.setParameterList(parameter, values, type);
        return this;
    }

    @Override
    public <P> SelectionQuery<R> setParameterList(QueryParameter<P> parameter, P[] values) {
        super.setParameterList(parameter, values);
        return this;
    }

    @Override
    public <P> SelectionQuery<R> setParameterList(QueryParameter<P> parameter, P[] values, Class<P> javaType) {
        super.setParameterList(parameter, values, javaType);
        return this;
    }

    @Override
    public <P> SelectionQuery<R> setParameterList(QueryParameter<P> parameter, P[] values, BindableType<P> type) {
        super.setParameterList(parameter, values, type);
        return this;
    }

    @Override
    public SelectionQuery<R> setProperties(Map map) {
        super.setProperties(map);
        return this;
    }

    @Override
    public SelectionQuery<R> setProperties(Object bean) {
        super.setProperties(bean);
        return this;
    }

    public SessionFactoryImplementor getSessionFactory() {
        return this.getSession().getFactory();
    }
}

