/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.web;

import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.web.service.routing.RoutingProvider;
import org.wildfly.extension.clustering.web.InfinispanRoutingProviderResourceDefinition;
import org.wildfly.extension.clustering.web.RoutingProviderServiceConfigurator;
import org.wildfly.extension.clustering.web.routing.infinispan.InfinispanRoutingConfiguration;
import org.wildfly.extension.clustering.web.routing.infinispan.InfinispanRoutingProvider;

public class InfinispanRoutingProviderServiceConfigurator
extends RoutingProviderServiceConfigurator
implements InfinispanRoutingConfiguration {
    private volatile String containerName;
    private volatile String cacheName;

    public InfinispanRoutingProviderServiceConfigurator(PathAddress address) {
        super(address, InfinispanRoutingProviderResourceDefinition.Capability.INFINISPAN_ROUTING_PROVIDER.getServiceName(address));
    }

    public ServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.containerName = InfinispanRoutingProviderResourceDefinition.Attribute.CACHE_CONTAINER.resolveModelAttribute((ExpressionResolver)context, model).asString();
        this.cacheName = InfinispanRoutingProviderResourceDefinition.Attribute.CACHE.resolveModelAttribute((ExpressionResolver)context, model).asStringOrNull();
        return super.configure(context, model);
    }

    @Override
    public RoutingProvider get() {
        return new InfinispanRoutingProvider(this);
    }

    public String getContainerName() {
        return this.containerName;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    @Override
    public void accept(ConfigurationBuilder builder) {
    }
}

