/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import org.wildfly.security.ssl.CipherSuitePredicate;
import org.wildfly.security.ssl.MechanismDatabase;

final class OrCipherSuitePredicate
extends CipherSuitePredicate {
    private final CipherSuitePredicate[] predicates;

    OrCipherSuitePredicate(CipherSuitePredicate ... predicates) {
        this.predicates = predicates;
    }

    @Override
    void toString(StringBuilder b) {
        b.append("any of (");
        int length = this.predicates.length;
        if (length > 0) {
            b.append(this.predicates[0]);
            for (int i = 1; i < length; ++i) {
                b.append(", ").append(this.predicates[i]);
            }
        }
        b.append(")");
    }

    @Override
    boolean test(MechanismDatabase.Entry entry) {
        for (CipherSuitePredicate predicate : this.predicates) {
            if (predicate == null || !predicate.test(entry)) continue;
            return true;
        }
        return false;
    }

    @Override
    boolean isAlwaysTrue() {
        for (CipherSuitePredicate predicate : this.predicates) {
            if (predicate == null || !predicate.isAlwaysTrue()) continue;
            return true;
        }
        return false;
    }

    @Override
    boolean isAlwaysFalse() {
        for (CipherSuitePredicate predicate : this.predicates) {
            if (predicate == null || predicate.isAlwaysFalse()) continue;
            return false;
        }
        return true;
    }
}

