/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.command.impl.parser;

import org.aesh.command.impl.internal.OptionType;
import org.aesh.command.impl.internal.ProcessedOption;
import org.aesh.command.parser.OptionParser;
import org.aesh.command.parser.OptionParserException;
import org.aesh.parser.ParsedLineIterator;
import org.aesh.readline.util.Parser;

public class AeshOptionParser
implements OptionParser {
    private static final String EQUALS = "=";
    private Status status;

    @Override
    public void parse(ParsedLineIterator parsedLineIterator, ProcessedOption option) throws OptionParserException {
        if (option.isProperty()) {
            this.processProperty(parsedLineIterator, option);
        } else {
            this.preProcessOption(option, parsedLineIterator);
            while (this.status != Status.NULL && parsedLineIterator.hasNextWord()) {
                String word = parsedLineIterator.peekWord();
                ProcessedOption nextOption = option.parent().searchAllOptions(word);
                if (nextOption == null) {
                    this.doParse(parsedLineIterator, option);
                    continue;
                }
                if (option.hasValue() && option.getValue() == null) {
                    throw new OptionParserException("Option " + option.name() + " was specified, but no value was given.");
                }
                return;
            }
            if (option.hasValue() && (option.getValue() == null || option.getValue().length() == 0)) {
                throw new OptionParserException("Option " + option.name() + " was specified, but no value was given.");
            }
        }
    }

    private void doParse(ParsedLineIterator iterator, ProcessedOption option) throws OptionParserException {
        if (this.status == Status.ACTIVE) {
            this.addValueToOption(option, iterator);
        } else if (this.status == Status.NULL) {
            this.preProcessOption(option, iterator);
        }
    }

    private void preProcessOption(ProcessedOption option, ParsedLineIterator iterator) throws OptionParserException {
        String word = iterator.peekWord();
        if (word.indexOf(" ") < word.indexOf(EQUALS)) {
            word = Parser.switchSpacesToEscapedSpacesInWord((String)word);
        }
        if (option.isLongNameUsed()) {
            if (word.length() - 2 != option.name().length()) {
                this.processOption(option, word.substring(2), option.name());
            } else if (option.getOptionType() == OptionType.BOOLEAN) {
                option.addValue("true");
                this.status = Status.NULL;
            } else {
                this.status = Status.OPTION_FOUND;
            }
        } else if (word.length() > 2) {
            this.processOption(option, word.substring(1), option.shortName());
        } else if (option.getOptionType() == OptionType.BOOLEAN) {
            option.addValue("true");
            this.status = Status.NULL;
        } else {
            this.status = Status.OPTION_FOUND;
        }
        if (this.status == Status.OPTION_FOUND) {
            this.status = option.hasValue() ? Status.ACTIVE : Status.NULL;
        }
        if (iterator.isNextWordCursorWord()) {
            option.setCursorOption(true);
        }
        iterator.pollParsedWord();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processOption(ProcessedOption option, String line, String name) throws OptionParserException {
        String rest = line.substring(name.length());
        if (option.getOptionType().equals((Object)OptionType.LIST)) {
            this.processList(option, rest);
            return;
        } else if (!rest.contains(EQUALS)) {
            if (rest.length() <= 0 || option.isLongNameUsed()) throw new OptionParserException("Option: - must be followed by a valid operator");
            option.setLongNameUsed(false);
            if (option.hasValue()) {
                this.doAddValueToOption(option, rest);
                return;
            }
            option.addValue("true");
            for (char shortName : rest.toCharArray()) {
                ProcessedOption currOption = option.parent().findOption(String.valueOf(shortName));
                if (currOption == null) throw new OptionParserException("Option: -" + shortName + " was not found.");
                if (currOption.hasValue()) {
                    throw new OptionParserException("Option: -" + shortName + " can not be grouped with other options since it need to be given a value");
                }
                currOption.setLongNameUsed(false);
                currOption.addValue("true");
            }
            return;
        } else {
            this.doAddValueToOption(option, line.substring(line.indexOf(EQUALS) + 1));
        }
    }

    private void addValueToOption(ProcessedOption currOption, ParsedLineIterator iterator) {
        if (iterator.isNextWordCursorWord()) {
            currOption.setCursorValue(true);
        }
        String word = iterator.pollWord();
        this.doAddValueToOption(currOption, word);
    }

    private void doAddValueToOption(ProcessedOption currOption, String word) {
        if (currOption.hasMultipleValues()) {
            if (word.contains(String.valueOf(currOption.getValueSeparator()))) {
                for (String value : word.split(String.valueOf(currOption.getValueSeparator()))) {
                    currOption.addValue(value.trim());
                }
                if (word.endsWith(String.valueOf(currOption.getValueSeparator()))) {
                    currOption.setEndsWithSeparator(true);
                }
                this.status = Status.NULL;
            } else {
                currOption.addValue(word);
            }
        } else {
            currOption.addValue(word);
            this.status = Status.NULL;
        }
    }

    private void processList(ProcessedOption currOption, String rest) {
        if (rest.length() > 1 && rest.startsWith(EQUALS)) {
            if (rest.indexOf(currOption.getValueSeparator()) > -1) {
                for (String value : rest.substring(1).split(String.valueOf(currOption.getValueSeparator()))) {
                    currOption.addValue(value.trim());
                }
                if (rest.endsWith(String.valueOf(currOption.getValueSeparator()))) {
                    currOption.setEndsWithSeparator(true);
                }
            } else {
                currOption.addValue(rest.substring(1));
            }
            this.status = Status.NULL;
        }
    }

    private void processProperty(ParsedLineIterator iterator, ProcessedOption currOption) throws OptionParserException {
        String name;
        String word = currOption.isLongNameUsed() ? iterator.pollWord().substring(2) : iterator.pollWord().substring(1);
        String string = name = currOption.isLongNameUsed() ? currOption.name() : currOption.shortName();
        if (word.length() < 1 + name.length() || !word.contains(EQUALS)) {
            throw new OptionParserException("Option " + currOption.getDisplayName() + ", must be part of a property");
        }
        String propertyName = word.substring(name.length(), word.indexOf(EQUALS));
        String value = word.substring(word.indexOf(EQUALS) + 1);
        if (value.length() < 1) {
            throw new OptionParserException("Option " + currOption.getDisplayName() + ", must have a value");
        }
        currOption.addProperty(propertyName, value);
        this.status = Status.NULL;
    }

    private static enum Status {
        NULL,
        OPTION_FOUND,
        ACTIVE;

    }
}

