/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller;

import java.io.Serializable;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;

public class ServerIdentity
implements Serializable {
    private static final long serialVersionUID = -5853735093238463353L;
    private final String hostName;
    private final String serverName;
    private final String serverGroupName;
    private volatile PathAddress pathAddress;

    public ServerIdentity(String hostName, String serverGroupName, String serverName) {
        this.hostName = hostName;
        this.serverGroupName = serverGroupName;
        this.serverName = serverName;
    }

    public String getServerGroupName() {
        return this.serverGroupName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public PathAddress toPathAddress() {
        if (this.pathAddress == null) {
            this.pathAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"host", (String)this.hostName), PathElement.pathElement((String)"server", (String)this.serverName)});
        }
        return this.pathAddress;
    }

    public int hashCode() {
        int result = 17;
        result += 31 * this.serverName.hashCode();
        return result += 31 * this.hostName.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ServerIdentity) {
            ServerIdentity other = (ServerIdentity)obj;
            return this.serverName.equals(other.serverName) && this.hostName.equals(other.hostName);
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{name=" + this.serverName + ", host=" + this.hostName + ", server-group=" + this.serverGroupName + "}";
    }
}

