/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.projection.impl;

import org.hibernate.search.backend.lucene.lowlevel.collector.impl.IdentifierValues;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.Values;
import org.hibernate.search.backend.lucene.reporting.impl.LuceneSearchHints;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.projection.impl.AbstractLuceneProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionExtractContext;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionRequestContext;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionTransformContext;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.projection.spi.ProjectionTypeKeys;

public class LuceneIdProjection<I>
extends AbstractLuceneProjection<I>
implements LuceneSearchProjection.Extractor<String, I> {
    private final ProjectionConverter<String, I> converter;

    LuceneIdProjection(LuceneSearchIndexScope<?> scope, ProjectionConverter<String, I> converter) {
        super(scope);
        this.converter = converter;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public LuceneSearchProjection.Extractor<?, I> request(ProjectionRequestContext context) {
        context.checkNotNested(ProjectionTypeKeys.ID, LuceneSearchHints.INSTANCE.idProjectionNestingNotSupportedHint());
        return this;
    }

    @Override
    public Values<String> values(ProjectionExtractContext context) {
        return new IdentifierValues(context.idReader());
    }

    @Override
    public I transform(LoadingResult<?> loadingResult, String extractedData, ProjectionTransformContext context) {
        return (I)this.converter.fromDocumentValue((Object)extractedData, context.fromDocumentValueConvertContext());
    }
}

