/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import jakarta.servlet.ServletContext;
import java.util.List;
import java.util.Map;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Immutability;
import org.wildfly.clustering.service.ServiceNameProvider;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.clustering.web.WebDeploymentConfiguration;
import org.wildfly.clustering.web.container.SessionManagementProvider;
import org.wildfly.clustering.web.container.SessionManagerFactoryConfiguration;
import org.wildfly.clustering.web.routing.RouteLocator;
import org.wildfly.clustering.web.service.session.DistributableSessionManagementProvider;
import org.wildfly.clustering.web.session.DistributableSessionManagementConfiguration;
import org.wildfly.clustering.web.session.SessionManagerFactory;
import org.wildfly.clustering.web.undertow.routing.DistributableAffinityLocatorServiceConfigurator;
import org.wildfly.clustering.web.undertow.routing.DistributableSessionIdentifierCodecServiceConfigurator;
import org.wildfly.clustering.web.undertow.session.DistributableSessionManagerFactoryServiceConfigurator;
import org.wildfly.clustering.web.undertow.session.SessionManagerFactoryConfigurationAdapter;
import org.wildfly.clustering.web.undertow.session.WebDeploymentConfigurationAdapter;
import org.wildfly.extension.undertow.session.SessionConfigWrapperFactoryServiceConfigurator;

public class UndertowDistributableSessionManagementProvider<C extends DistributableSessionManagementConfiguration<DeploymentUnit>>
implements SessionManagementProvider {
    private final DistributableSessionManagementProvider<C> provider;
    private final Immutability immutability;

    public UndertowDistributableSessionManagementProvider(DistributableSessionManagementProvider<C> provider, Immutability immutability) {
        this.provider = provider;
        this.immutability = immutability;
    }

    public Iterable<CapabilityServiceConfigurator> getSessionManagerFactoryServiceConfigurators(ServiceName name, SessionManagerFactoryConfiguration configuration) {
        CapabilityServiceConfigurator configurator = this.provider.getSessionManagerFactoryServiceConfigurator(new SessionManagerFactoryConfigurationAdapter<DistributableSessionManagementConfiguration>(configuration, this.provider.getSessionManagementConfiguration(), this.immutability));
        return List.of(configurator, new DistributableSessionManagerFactoryServiceConfigurator(name, configuration, (SupplierDependency<SessionManagerFactory<ServletContext, Map<String, Object>, Batch>>)new ServiceSupplierDependency((ServiceNameProvider)configurator)));
    }

    public Iterable<CapabilityServiceConfigurator> getSessionAffinityServiceConfigurators(ServiceName name, org.wildfly.clustering.web.container.WebDeploymentConfiguration configuration) {
        CapabilityServiceConfigurator routeLocatorConfigurator = this.provider.getRouteLocatorServiceConfigurator((WebDeploymentConfiguration)new WebDeploymentConfigurationAdapter(configuration));
        DistributableSessionIdentifierCodecServiceConfigurator codecConfigurator = new DistributableSessionIdentifierCodecServiceConfigurator(name.append(new String[]{"codec"}), (SupplierDependency<RouteLocator>)new ServiceSupplierDependency((ServiceNameProvider)routeLocatorConfigurator));
        DistributableAffinityLocatorServiceConfigurator affinityLocatorConfigurator = new DistributableAffinityLocatorServiceConfigurator(name.append(new String[]{"affinity"}), (SupplierDependency<RouteLocator>)new ServiceSupplierDependency((ServiceNameProvider)routeLocatorConfigurator));
        SessionConfigWrapperFactoryServiceConfigurator wrapperFactoryConfigurator = new SessionConfigWrapperFactoryServiceConfigurator(name, (SupplierDependency)new ServiceSupplierDependency((ServiceNameProvider)codecConfigurator), (SupplierDependency)new ServiceSupplierDependency((ServiceNameProvider)affinityLocatorConfigurator));
        return List.of(routeLocatorConfigurator, codecConfigurator, affinityLocatorConfigurator, wrapperFactoryConfigurator);
    }
}

