/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal;

import java.util.HashMap;
import java.util.Iterator;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmHibernateMapping;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.envers.boot.model.RootPersistentEntity;
import org.hibernate.envers.boot.spi.EnversMetadataBuildingContext;
import org.hibernate.envers.configuration.Configuration;
import org.hibernate.envers.configuration.internal.ClassesAuditingData;
import org.hibernate.envers.configuration.internal.PersistentClassGraphDefiner;
import org.hibernate.envers.configuration.internal.metadata.AuditMetadataGenerator;
import org.hibernate.envers.configuration.internal.metadata.EntityMappingData;
import org.hibernate.envers.configuration.internal.metadata.reader.AnnotationsMetadataReader;
import org.hibernate.envers.configuration.internal.metadata.reader.ClassAuditingData;
import org.hibernate.envers.internal.entities.EntitiesConfigurations;
import org.hibernate.envers.internal.tools.StringTools;
import org.hibernate.envers.internal.tools.graph.GraphTopologicalSort;
import org.hibernate.mapping.PersistentClass;

public class EntitiesConfigurator {
    public EntitiesConfigurations configure(EnversMetadataBuildingContext metadataBuildingContext) {
        RootPersistentEntity revisionInfoMapping;
        EntityMappingData mappingData;
        InFlightMetadataCollector metadata = metadataBuildingContext.getMetadataCollector();
        Configuration configuration = metadataBuildingContext.getConfiguration();
        Iterator<PersistentClass> classes = GraphTopologicalSort.sort(new PersistentClassGraphDefiner((MetadataImplementor)metadata)).iterator();
        ClassesAuditingData classesAuditingData = new ClassesAuditingData();
        AnnotationsMetadataReader reader = new AnnotationsMetadataReader(metadataBuildingContext);
        while (classes.hasNext()) {
            PersistentClass pc = classes.next();
            if (pc.getClassName() == null) continue;
            classesAuditingData.addClassAuditingData(reader.getAuditData(pc));
        }
        classesAuditingData.updateCalculatedFields();
        AuditMetadataGenerator auditMetaGen = new AuditMetadataGenerator(metadataBuildingContext);
        HashMap<PersistentClass, EntityMappingData> mappings = new HashMap<PersistentClass, EntityMappingData>();
        for (ClassAuditingData auditData : classesAuditingData.getAllClassAuditedData()) {
            mappingData = new EntityMappingData();
            PersistentClass persistentClass = auditData.getPersistentClass();
            if (auditData.isAudited()) {
                if (!StringTools.isEmpty(auditData.getAuditTable().value())) {
                    String entityName = persistentClass.getEntityName();
                    String auditTableName = auditData.getAuditTable().value();
                    configuration.addCustomAuditTableName(entityName, auditTableName);
                }
                auditMetaGen.generateFirstPass(auditData, mappingData, true);
            } else {
                auditMetaGen.generateFirstPass(auditData, mappingData, false);
            }
            mappings.put(persistentClass, mappingData);
        }
        for (ClassAuditingData auditingData : classesAuditingData.getAllClassAuditedData()) {
            mappingData = (EntityMappingData)mappings.get(auditingData.getPersistentClass());
            if (!auditingData.isAudited()) continue;
            auditMetaGen.generateSecondPass(auditingData, mappingData);
            mappingData.build();
            metadataBuildingContext.getMappingCollector().addDocument(mappingData.getMapping());
            for (JaxbHbmHibernateMapping additionalMapping : mappingData.getAdditionalMappings()) {
                metadataBuildingContext.getMappingCollector().addDocument(additionalMapping);
            }
        }
        if (!auditMetaGen.getAuditedEntityConfigurations().isEmpty() && (revisionInfoMapping = configuration.getRevisionInfo().getRevisionInfoMapping()) != null) {
            EntityMappingData mappingData2 = new EntityMappingData();
            mappingData2.addMapping(revisionInfoMapping);
            mappingData2.build();
            metadataBuildingContext.getMappingCollector().addDocument(mappingData2.getMapping());
        }
        return new EntitiesConfigurations(auditMetaGen.getAuditedEntityConfigurations(), auditMetaGen.getNotAuditedEntityConfigurations());
    }
}

