/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.ContentTypeConfiguration;
import org.infinispan.configuration.cache.EncodingConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;

public class ContentTypeConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<ContentTypeConfiguration> {
    private final AttributeSet attributes;
    private final Enum<?> element;

    protected ContentTypeConfigurationBuilder(Enum<?> element, EncodingConfigurationBuilder builder) {
        super(builder.getBuilder());
        this.element = element;
        this.attributes = ContentTypeConfiguration.attributeDefinitionSet();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public boolean isObjectStorage() {
        return MediaType.APPLICATION_OBJECT.match(this.mediaType());
    }

    public boolean isProtobufStorage() {
        return MediaType.APPLICATION_PROTOSTREAM.match(this.mediaType());
    }

    public ContentTypeConfigurationBuilder mediaType(String mediaType) {
        this.attributes.attribute(ContentTypeConfiguration.MEDIA_TYPE).set((Object)MediaType.fromString((String)mediaType));
        return this;
    }

    public MediaType mediaType() {
        return (MediaType)this.attributes.attribute(ContentTypeConfiguration.MEDIA_TYPE).get();
    }

    public ContentTypeConfiguration create() {
        throw new UnsupportedOperationException();
    }

    ContentTypeConfiguration create(MediaType globalType) {
        return new ContentTypeConfiguration(this.element, this.attributes.protect(), globalType);
    }

    public ContentTypeConfigurationBuilder read(ContentTypeConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
    }
}

