/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.jaxb;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.Provider;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletionStage;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.jboss.resteasy.plugins.providers.jaxb.AbstractJAXBProvider;
import org.jboss.resteasy.plugins.providers.jaxb.JAXBUnmarshalException;
import org.jboss.resteasy.plugins.providers.jaxb.SecureUnmarshaller;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.spi.AsyncOutputStream;
import org.jboss.resteasy.spi.util.Types;
import org.jboss.resteasy.util.NoContent;
import org.xml.sax.InputSource;

@Provider
@Produces(value={"application/xml", "application/*+xml", "text/xml", "text/*+xml"})
@Consumes(value={"application/xml", "application/*+xml", "text/xml", "text/*+xml"})
public class JAXBElementProvider
extends AbstractJAXBProvider<JAXBElement<?>> {
    @Override
    protected boolean isReadWritable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return JAXBElement.class.equals(type);
    }

    @Override
    public JAXBElement<?> readFrom(Class<JAXBElement<?>> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        JAXBElement result;
        LogMessages.LOGGER.debugf("Provider : %s,  Method : readFrom", (Object)((Object)((Object)this)).getClass().getName());
        NoContent.contentLengthCheck(httpHeaders);
        Class typeArg = Object.class;
        if (genericType != null) {
            typeArg = Types.getTypeArgument((Type)genericType);
        }
        JAXBContext jaxb = null;
        try {
            jaxb = this.findJAXBContext(typeArg, annotations, mediaType, true);
        }
        catch (JAXBException e) {
            throw new JAXBUnmarshalException(e);
        }
        try {
            Unmarshaller unmarshaller = jaxb.createUnmarshaller();
            unmarshaller = JAXBElementProvider.decorateUnmarshaller(type, annotations, mediaType, unmarshaller);
            if (this.needsSecurity()) {
                unmarshaller = new SecureUnmarshaller(unmarshaller, this.isDisableExternalEntities(), this.isEnableSecureProcessingFeature(), this.isDisableDTDs());
                SAXSource source = null;
                source = JAXBElementProvider.getCharset(mediaType) == null ? new SAXSource(new InputSource(new InputStreamReader(entityStream, StandardCharsets.UTF_8))) : new SAXSource(new InputSource(entityStream));
                result = unmarshaller.unmarshal((Source)source, typeArg);
            } else if (JAXBElementProvider.getCharset(mediaType) == null) {
                InputSource is = new InputSource(entityStream);
                is.setEncoding(StandardCharsets.UTF_8.name());
                StreamSource source = new StreamSource(new InputStreamReader(entityStream, StandardCharsets.UTF_8));
                source.setInputStream(entityStream);
                result = unmarshaller.unmarshal((Source)source, typeArg);
            } else {
                JAXBElement e;
                result = e = unmarshaller.unmarshal((Source)new StreamSource(entityStream), typeArg);
            }
        }
        catch (JAXBException e) {
            throw new JAXBUnmarshalException(e);
        }
        JAXBElement element = result;
        return element;
    }

    @Override
    public void writeTo(JAXBElement<?> t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream outputStream) throws IOException {
        LogMessages.LOGGER.debugf("Provider : %s,  Method : writeTo", (Object)((Object)((Object)this)).getClass().getName());
        Class typeArg = Object.class;
        if (genericType != null) {
            typeArg = Types.getTypeArgument((Type)genericType);
        }
        super.writeTo(t, typeArg, genericType, annotations, mediaType, httpHeaders, outputStream);
    }

    public CompletionStage<Void> asyncWriteTo(JAXBElement<?> t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, AsyncOutputStream outputStream) {
        LogMessages.LOGGER.debugf("Provider : %s,  Method : writeTo", (Object)((Object)((Object)this)).getClass().getName());
        Class typeArg = Object.class;
        if (genericType != null) {
            typeArg = Types.getTypeArgument((Type)genericType);
        }
        return super.asyncWriteTo(t, typeArg, genericType, annotations, mediaType, httpHeaders, outputStream);
    }
}

