/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra;

import jakarta.jms.ConnectionMetaData;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQRAConnectionMetaData
implements ConnectionMetaData {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String DEFAULT_PROP_FILE_NAME = "jms-version.properties";
    private static final String JMS_VERSION_NAME;
    private static final int JMS_MAJOR_VERSION;
    private static final int JMS_MINOR_VERSION;

    public ActiveMQRAConnectionMetaData() {
        logger.trace("constructor()");
    }

    public String getJMSVersion() {
        logger.trace("getJMSVersion()");
        return JMS_VERSION_NAME;
    }

    public int getJMSMajorVersion() {
        logger.trace("getJMSMajorVersion()");
        return JMS_MAJOR_VERSION;
    }

    public int getJMSMinorVersion() {
        logger.trace("getJMSMinorVersion()");
        return JMS_MINOR_VERSION;
    }

    public String getJMSProviderName() {
        logger.trace("getJMSProviderName()");
        return "ActiveMQ Artemis";
    }

    public String getProviderVersion() {
        logger.trace("getJMSProviderName()");
        return "2.4";
    }

    public int getProviderMajorVersion() {
        logger.trace("getProviderMajorVersion()");
        return 2;
    }

    public int getProviderMinorVersion() {
        logger.trace("getProviderMinorVersion()");
        return 4;
    }

    public Enumeration<Object> getJMSXPropertyNames() {
        Vector<String> v = new Vector<String>();
        v.add("JMSXGroupID");
        v.add("JMSXGroupSeq");
        v.add("JMSXDeliveryCount");
        return v.elements();
    }

    static {
        Properties versionProps = new Properties();
        try (InputStream in = ActiveMQRAConnectionMetaData.class.getClassLoader().getResourceAsStream(DEFAULT_PROP_FILE_NAME);){
            if (in != null) {
                versionProps.load(in);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        JMS_VERSION_NAME = versionProps.getProperty("activemq.version.implementation.versionName", "2.0");
        JMS_MAJOR_VERSION = Integer.valueOf(versionProps.getProperty("activemq.version.implementation.majorVersion", "2"));
        JMS_MINOR_VERSION = Integer.valueOf(versionProps.getProperty("activemq.version.implementation.minorVersion", "0"));
    }
}

