/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.index.impl;

import org.hibernate.search.backend.lucene.document.impl.LuceneIndexEntryFactory;
import org.hibernate.search.backend.lucene.document.model.dsl.impl.LuceneIndexRootBuilder;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexModel;
import org.hibernate.search.backend.lucene.index.impl.IndexManagerBackendContext;
import org.hibernate.search.backend.lucene.index.impl.LuceneIndexManagerImpl;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexRootBuilder;
import org.hibernate.search.engine.backend.index.spi.IndexManagerBuilder;
import org.hibernate.search.util.common.impl.SuppressingCloser;

public class LuceneIndexManagerBuilder
implements IndexManagerBuilder {
    private final IndexManagerBackendContext backendContext;
    private final String indexName;
    private final LuceneIndexRootBuilder schemaRootNodeBuilder;

    public LuceneIndexManagerBuilder(IndexManagerBackendContext backendContext, String indexName, LuceneIndexRootBuilder schemaRootNodeBuilder) {
        this.backendContext = backendContext;
        this.indexName = indexName;
        this.schemaRootNodeBuilder = schemaRootNodeBuilder;
    }

    public void closeOnFailure() {
    }

    public IndexRootBuilder schemaRootNodeBuilder() {
        return this.schemaRootNodeBuilder;
    }

    public LuceneIndexManagerImpl build() {
        LuceneIndexModel model = null;
        try {
            model = this.schemaRootNodeBuilder.build(this.indexName);
            LuceneIndexEntryFactory indexEntryFactory = this.backendContext.createLuceneIndexEntryFactory(model);
            return new LuceneIndexManagerImpl(this.backendContext, this.indexName, model, indexEntryFactory);
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).push((AutoCloseable)model);
            throw e;
        }
    }
}

