/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.model.jvm;

import java.util.Set;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;

final class JVMAddHandler
extends AbstractAddStepHandler {
    public static final String OPERATION_NAME = "add";
    private final AttributeDefinition[] attrs;

    JVMAddHandler(AttributeDefinition[] attrs) {
        this.attrs = attrs;
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        super.populateModel(context, operation, resource);
        ModelNode model = resource.getModel();
        final PathAddress jvm = PathAddress.pathAddress((ModelNode)operation.require("address"));
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                Set children;
                Resource root;
                try {
                    root = context.readResourceFromRoot(context.getCurrentAddress().getParent(), false);
                }
                catch (Resource.NoSuchResourceException e) {
                    return;
                }
                ImmutableManagementResourceRegistration registration = context.getResourceRegistration();
                int maxOccurs = registration.getMaxOccurs();
                if (maxOccurs != Integer.MAX_VALUE && (children = root.getChildren("jvm")).size() > 1) {
                    for (Resource.ResourceEntry entry : children) {
                        if (entry.getName().equals(jvm.getLastElement().getValue())) continue;
                        throw ControllerLogger.ROOT_LOGGER.cannotAddMoreThanOneJvmForServerOrHost(jvm, PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"jvm", (String)entry.getName())}));
                    }
                }
            }
        }, OperationContext.Stage.MODEL);
        for (AttributeDefinition attr : this.attrs) {
            attr.validateAndSet(operation, model);
        }
    }

    protected boolean requiresRuntime(OperationContext context) {
        return false;
    }
}

