/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.coordination.outboxpolling.cfg;

import java.lang.invoke.MethodHandles;
import org.hibernate.id.uuid.CustomVersionOneStrategy;
import org.hibernate.id.uuid.StandardRandomStrategy;
import org.hibernate.search.engine.cfg.spi.ParseUtils;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.logging.impl.Log;
import org.hibernate.search.util.common.annotation.Incubating;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

@Incubating
public enum UuidGenerationStrategy {
    AUTO("auto"){

        @Override
        public String strategy() {
            return RANDOM.strategy();
        }
    }
    ,
    RANDOM("random"){

        @Override
        public String strategy() {
            return StandardRandomStrategy.class.getName();
        }
    }
    ,
    TIME("time"){

        @Override
        public String strategy() {
            return CustomVersionOneStrategy.class.getName();
        }
    };

    private final String externalRepresentation;
    private static final Log log;

    private UuidGenerationStrategy(String externalRepresentation) {
        this.externalRepresentation = externalRepresentation;
    }

    public String externalRepresentation() {
        return this.externalRepresentation;
    }

    public abstract String strategy();

    public static UuidGenerationStrategy of(String value) {
        return (UuidGenerationStrategy)((Object)ParseUtils.parseDiscreteValues((Object[])UuidGenerationStrategy.values(), UuidGenerationStrategy::externalRepresentation, log::invalidUuidGenerationStrategyName, (String)value));
    }

    static {
        log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    }
}

