/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.coordination.outboxpolling.event.impl;

import java.lang.invoke.MethodHandles;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.engine.reporting.FailureContext;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.cluster.impl.Agent;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.cluster.impl.AgentPersister;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.cluster.impl.AgentState;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.cluster.impl.AgentType;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.cluster.impl.ClusterDescriptor;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.cluster.impl.ShardAssignmentDescriptor;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.event.impl.AbstractAgentClusterLink;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.event.impl.ClusterTarget;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.event.impl.OutboxPollingEventProcessingInstructions;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.event.impl.ShardAssignment;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.logging.impl.Log;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.spi.ToStringTreeAppender;
import org.jboss.logging.Logger;

public final class OutboxPollingEventProcessorClusterLink
extends AbstractAgentClusterLink<OutboxPollingEventProcessingInstructions> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final ShardAssignment.Provider shardAssignmentProvider;
    final boolean shardAssignmentIsStatic;
    ShardAssignment lastShardAssignment;

    public OutboxPollingEventProcessorClusterLink(String agentName, FailureHandler failureHandler, Clock clock, ShardAssignment.Provider shardAssignmentProvider, Duration pollingInterval, Duration pulseInterval, Duration pulseExpiration, ShardAssignmentDescriptor staticShardAssignment) {
        super(new AgentPersister(staticShardAssignment == null ? AgentType.EVENT_PROCESSING_DYNAMIC_SHARDING : AgentType.EVENT_PROCESSING_STATIC_SHARDING, agentName, staticShardAssignment), failureHandler, clock, pollingInterval, pulseInterval, pulseExpiration);
        this.shardAssignmentProvider = shardAssignmentProvider;
        if (staticShardAssignment == null) {
            this.shardAssignmentIsStatic = false;
            this.lastShardAssignment = null;
        } else {
            this.shardAssignmentIsStatic = true;
            this.lastShardAssignment = shardAssignmentProvider.create(staticShardAssignment);
        }
    }

    @Override
    public void appendTo(ToStringTreeAppender appender) {
        super.appendTo(appender);
        appender.attribute("shardAssignmentProvider", (Object)this.shardAssignmentProvider).attribute("shardAssignmentIsStatic", (Object)this.shardAssignmentIsStatic);
    }

    @Override
    protected AbstractAgentClusterLink.WriteAction<OutboxPollingEventProcessingInstructions> doPulse(List<Agent> allAgentsInIdOrder, Agent currentSelf) {
        ClusterTarget clusterTarget;
        for (Agent agent : allAgentsInIdOrder) {
            if (!AgentType.MASS_INDEXING.equals((Object)agent.getType())) continue;
            log.logf(currentSelf.getState() != AgentState.SUSPENDED ? Logger.Level.INFO : Logger.Level.TRACE, "Agent '%s': another agent '%s' is currently mass indexing", this.selfReference(), agent);
            return (now, self, agentPersister) -> {
                agentPersister.setSuspended(self);
                return this.instructCommitAndRetryPulseAfterDelay(now, this.pulseInterval);
            };
        }
        try {
            clusterTarget = ClusterTarget.create(allAgentsInIdOrder);
        }
        catch (SearchException e) {
            FailureContext.Builder contextBuilder = FailureContext.builder();
            contextBuilder.throwable((Throwable)log.outboxEventProcessorPulseFailed(this.selfReference(), e.getMessage(), allAgentsInIdOrder, (RuntimeException)((Object)e)));
            contextBuilder.failingOperation((Object)log.outboxEventProcessorPulse(this.selfReference()));
            this.failureHandler.handle(contextBuilder.build());
            return (now, self, agentPersister) -> {
                agentPersister.setSuspended(self);
                return this.instructCommitAndRetryPulseAfterDelay(now, this.pulseInterval);
            };
        }
        Optional<ShardAssignmentDescriptor> shardAssignmentOptional = ShardAssignmentDescriptor.fromClusterMemberList(clusterTarget.descriptor.memberIdsInShardOrder, this.selfReference().id);
        if (!shardAssignmentOptional.isPresent()) {
            log.logf(currentSelf.getState() != AgentState.SUSPENDED ? Logger.Level.INFO : Logger.Level.TRACE, "Agent '%s': this agent is superfluous and will not perform event processing, because other agents are enough to handle all the shards. Target cluster: %s.", this.selfReference(), clusterTarget.descriptor);
            return (now, self, agentPersister) -> {
                agentPersister.setSuspended(self);
                return this.instructCommitAndRetryPulseAfterDelay(now, this.pulseInterval);
            };
        }
        ShardAssignmentDescriptor targetShardAssignment = shardAssignmentOptional.get();
        if (clusterTarget.descriptor.memberIdsInShardOrder.contains(null)) {
            log.logf(currentSelf.getState() != AgentState.SUSPENDED ? Logger.Level.INFO : Logger.Level.TRACE, "Agent '%s': some cluster members are missing; this agent will wait until they are present. Target cluster: %s.", this.selfReference(), clusterTarget.descriptor);
            return (now, self, agentPersister) -> {
                agentPersister.setSuspended(self);
                return this.instructCommitAndRetryPulseAfterDelay(now, this.pollingInterval);
            };
        }
        ShardAssignmentDescriptor persistedShardAssignment = currentSelf.getShardAssignment();
        if (!targetShardAssignment.equals(persistedShardAssignment)) {
            log.infof("Agent '%s': the persisted shard assignment (%s) does not match the target. Target assignment: %s. Cluster: %s.", new Object[]{this.selfReference(), persistedShardAssignment, targetShardAssignment, clusterTarget.descriptor});
            return (now, self, agentPersister) -> {
                agentPersister.setWaiting(self, clusterTarget.descriptor, targetShardAssignment);
                return this.instructCommitAndRetryPulseAfterDelay(now, this.pollingInterval);
            };
        }
        if (!this.excludedAgentsAreOutOfCluster(clusterTarget.excluded)) {
            return (now, self, agentPersister) -> {
                agentPersister.setWaiting(self, clusterTarget.descriptor, targetShardAssignment);
                return this.instructCommitAndRetryPulseAfterDelay(now, this.pollingInterval);
            };
        }
        if (!this.clusterMembersAreInCluster(clusterTarget.membersInShardOrder, clusterTarget.descriptor)) {
            return (now, self, agentPersister) -> {
                agentPersister.setWaiting(self, clusterTarget.descriptor, targetShardAssignment);
                return this.instructCommitAndRetryPulseAfterDelay(now, this.pollingInterval);
            };
        }
        if (this.lastShardAssignment == null || !targetShardAssignment.equals(this.lastShardAssignment.descriptor)) {
            if (this.shardAssignmentIsStatic) {
                throw new AssertionFailure("Agent '" + this.selfReference() + "' has a static shard assignment, but the target shard assignment (" + targetShardAssignment + ") does not match the static shard assignment (" + this.lastShardAssignment + ")");
            }
            log.infof("Agent '%s': assigning to %s", this.selfReference(), targetShardAssignment);
            this.lastShardAssignment = this.shardAssignmentProvider.create(targetShardAssignment);
        }
        return (now, self, agentPersister) -> {
            agentPersister.setRunning(self, clusterTarget.descriptor);
            return this.instructProceedWithEventProcessing(now);
        };
    }

    private boolean excludedAgentsAreOutOfCluster(List<Agent> excludedAgents) {
        if (excludedAgents.isEmpty()) {
            return true;
        }
        AgentState expectedState = AgentState.SUSPENDED;
        for (Agent agent : excludedAgents) {
            if (expectedState.equals((Object)agent.getState())) continue;
            log.tracef("Agent '%s': waiting for agent '%s', which has not reached state '%s' yet", this.selfReference(), agent.getReference(), (Object)expectedState);
            return false;
        }
        log.tracef("Agent '%s': agents excluded from the cluster reached the expected state %s", this.selfReference(), (Object)expectedState);
        return true;
    }

    private boolean clusterMembersAreInCluster(List<Agent> clusterMembersInShardOrder, ClusterDescriptor clusterDescriptor) {
        int expectedTotalShardCount = clusterMembersInShardOrder.size();
        int expectedAssignedShardIndex = 0;
        Set<AgentState> expectedStates = AgentState.WAITING_OR_RUNNING;
        for (Agent agent : clusterMembersInShardOrder) {
            AgentState state = agent.getState();
            if (!expectedStates.contains((Object)agent.getState())) {
                log.tracef("Agent '%s': waiting for agent '%s', whose state %s is not in the expected %s yet", new Object[]{this.selfReference(), agent.getReference(), state, expectedStates});
                return false;
            }
            Integer totalShardCount = agent.getTotalShardCount();
            if (totalShardCount == null || expectedTotalShardCount != totalShardCount) {
                log.tracef("Agent '%s': waiting for agent '%s', whose total shard count %s is not the expected %s yet", new Object[]{this.selfReference(), agent.getReference(), totalShardCount, expectedTotalShardCount});
                return false;
            }
            Integer assignedShardIndex = agent.getAssignedShardIndex();
            if (assignedShardIndex == null || expectedAssignedShardIndex != assignedShardIndex) {
                log.tracef("Agent '%s': waiting for agent '%s', whose assigned shard index %s is not the expected %s yet", new Object[]{this.selfReference(), agent.getReference(), assignedShardIndex, expectedAssignedShardIndex});
                return false;
            }
            ++expectedAssignedShardIndex;
        }
        log.tracef("Agent '%s': all cluster members reached the expected states %s and shard assignment %s", this.selfReference(), expectedStates, clusterDescriptor);
        return true;
    }

    @Override
    protected OutboxPollingEventProcessingInstructions instructCommitAndRetryPulseAfterDelay(Instant now, Duration delay) {
        Instant expiration = now.plus(delay);
        log.tracef("Agent '%s': instructions are to not process events and to retry a pulse in %s, around %s", this.selfReference(), delay, expiration);
        return new OutboxPollingEventProcessingInstructions(this.clock, expiration, Optional.empty());
    }

    private OutboxPollingEventProcessingInstructions instructProceedWithEventProcessing(Instant now) {
        Instant expiration = now.plus(this.pulseInterval);
        log.tracef("Agent '%s': instructions are to process events and to retry a pulse in %s, around %s", this.selfReference(), this.pulseInterval, expiration);
        return new OutboxPollingEventProcessingInstructions(this.clock, expiration, Optional.of(this.lastShardAssignment.eventFinder));
    }
}

