/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.common.constraint.Assert;
import io.smallrye.common.function.Functions;
import io.smallrye.config.ConfigMappingClass;
import io.smallrye.config.ConfigMappingContext;
import io.smallrye.config.ConfigMappingInterface;
import io.smallrye.config.ConfigMappingLoader;
import io.smallrye.config.ConfigMappingObject;
import io.smallrye.config.ConfigMessages;
import io.smallrye.config.ConfigValidationException;
import io.smallrye.config.DefaultValuesConfigSource;
import io.smallrye.config.EnvConfigSource;
import io.smallrye.config.KeyMap;
import io.smallrye.config.NameIterator;
import io.smallrye.config.SecretKeys;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.common.utils.StringUtil;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.IntFunction;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.Converter;

final class ConfigMappingProvider
implements Serializable {
    private static final long serialVersionUID = 3977667610888849912L;
    private static final BiConsumer<ConfigMappingContext, NameIterator> DO_NOTHING = Functions.discardingBiConsumer();
    private static final KeyMap<BiConsumer<ConfigMappingContext, NameIterator>> IGNORE_EVERYTHING;
    private final Map<String, List<Class<?>>> roots;
    private final KeyMap<BiConsumer<ConfigMappingContext, NameIterator>> matchActions;
    private final Map<String, ConfigMappingInterface.Property> properties;
    private final KeyMap<String> defaultValues;
    private final boolean validateUnknown;

    ConfigMappingProvider(Builder builder) {
        this.roots = new HashMap(builder.roots);
        this.matchActions = new KeyMap();
        this.properties = new HashMap<String, ConfigMappingInterface.Property>();
        this.defaultValues = new KeyMap();
        this.validateUnknown = builder.validateUnknown;
        ArrayDeque<String> currentPath = new ArrayDeque<String>();
        NameIterator nameIterator = NameIterator.empty();
        for (Map.Entry<String, List<Class<?>>> entry : this.roots.entrySet()) {
            try (NameIterator rootNi = nameIterator.with(entry.getKey());){
                while (rootNi.hasNext()) {
                    String nextSegment = rootNi.getNextSegment();
                    if (!nextSegment.isEmpty()) {
                        currentPath.add(nextSegment);
                    }
                    rootNi.next();
                }
            }
            List<Class<?>> roots = entry.getValue();
            for (Class clazz : roots) {
                GetRootAction ef = new GetRootAction(clazz, entry.getKey());
                ConfigMappingInterface mapping = ConfigMappingLoader.getConfigMapping(clazz);
                this.processEagerGroup(currentPath, this.matchActions, this.defaultValues, mapping.getNamingStrategy(), mapping, ef);
            }
            currentPath.clear();
        }
        for (String[] ignoredPath : builder.ignored) {
            KeyMap<BiConsumer<ConfigMappingContext, NameIterator>> found;
            int len;
            if (ignoredPath[(len = ignoredPath.length) - 1].equals("**")) {
                found = this.matchActions.findOrAdd(ignoredPath, 0, len - 1);
                found.putRootValue(DO_NOTHING);
                ConfigMappingProvider.ignoreRecursively(found);
                continue;
            }
            found = this.matchActions.findOrAdd(ignoredPath);
            found.putRootValue(DO_NOTHING);
        }
    }

    static void ignoreRecursively(KeyMap<BiConsumer<ConfigMappingContext, NameIterator>> root) {
        if (root.getRootValue() == null) {
            root.putRootValue(DO_NOTHING);
        }
        if (root.getAny() == null) {
            root.putAny(IGNORE_EVERYTHING);
        } else {
            KeyMap<BiConsumer<ConfigMappingContext, NameIterator>> any = root.getAny();
            if (root != any) {
                ConfigMappingProvider.ignoreRecursively(any);
            }
        }
        for (KeyMap value : root.values()) {
            ConfigMappingProvider.ignoreRecursively(value);
        }
    }

    private void processEagerGroup(ArrayDeque<String> currentPath, KeyMap<BiConsumer<ConfigMappingContext, NameIterator>> matchActions, KeyMap<String> defaultValues, ConfigMappingInterface.NamingStrategy namingStrategy, ConfigMappingInterface group, BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject> getEnclosingFunction) {
        int sc = group.getSuperTypeCount();
        for (int i = 0; i < sc; ++i) {
            this.processEagerGroup(currentPath, matchActions, defaultValues, namingStrategy, group.getSuperType(i), getEnclosingFunction);
        }
        Class<?> type = group.getInterfaceType();
        HashSet<String> usedProperties = new HashSet<String>();
        for (int i = 0; i < group.getPropertyCount(); ++i) {
            ConfigMappingInterface.Property property = group.getProperty(i);
            String memberName = property.getMethod().getName();
            ArrayDeque<String> propertyPath = new ArrayDeque<String>(currentPath);
            if (!usedProperties.add(memberName)) continue;
            if (!property.isParentPropertyName()) {
                NameIterator ni = new NameIterator(property.hasPropertyName() ? property.getPropertyName() : ConfigMappingProvider.propertyName(property, group, namingStrategy));
                while (ni.hasNext()) {
                    propertyPath.add(ni.getNextSegment());
                    ni.next();
                }
            }
            this.processProperty(propertyPath, matchActions, defaultValues, namingStrategy, group, getEnclosingFunction, type, memberName, property);
        }
    }

    private void processProperty(ArrayDeque<String> currentPath, KeyMap<BiConsumer<ConfigMappingContext, NameIterator>> matchActions, KeyMap<String> defaultValues, ConfigMappingInterface.NamingStrategy namingStrategy, ConfigMappingInterface group, BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject> getEnclosingFunction, Class<?> type, String memberName, ConfigMappingInterface.Property property) {
        if (property.isOptional()) {
            ConfigMappingInterface.MayBeOptionalProperty nestedProperty = property.asOptional().getNestedProperty();
            this.processOptionalProperty(currentPath, matchActions, defaultValues, namingStrategy, group, getEnclosingFunction, type, memberName, nestedProperty);
        } else if (property.isGroup()) {
            this.processEagerGroup(currentPath, matchActions, defaultValues, namingStrategy, property.asGroup().getGroupType(), new GetOrCreateEnclosingGroupInGroup(getEnclosingFunction, group, property.asGroup(), currentPath));
        } else if (property.isPrimitive()) {
            ConfigMappingInterface.PrimitiveProperty primitiveProperty = property.asPrimitive();
            if (primitiveProperty.hasDefaultValue()) {
                defaultValues.findOrAdd(currentPath).putRootValue(primitiveProperty.getDefaultValue());
                if (ConfigMappingProvider.isCollection(currentPath)) {
                    defaultValues.findOrAdd(ConfigMappingProvider.inlineCollectionPath(currentPath)).putRootValue(primitiveProperty.getDefaultValue());
                }
            }
            this.addAction(currentPath, property, DO_NOTHING);
            if (ConfigMappingProvider.isCollection(currentPath)) {
                this.addAction(ConfigMappingProvider.inlineCollectionPath(currentPath), property, DO_NOTHING);
            }
        } else if (property.isLeaf()) {
            ConfigMappingInterface.LeafProperty leafProperty = property.asLeaf();
            if (leafProperty.hasDefaultValue()) {
                defaultValues.findOrAdd(currentPath).putRootValue(leafProperty.getDefaultValue());
                if (ConfigMappingProvider.isCollection(currentPath)) {
                    defaultValues.findOrAdd(ConfigMappingProvider.inlineCollectionPath(currentPath)).putRootValue(leafProperty.getDefaultValue());
                }
            }
            this.addAction(currentPath, property, DO_NOTHING);
            if (ConfigMappingProvider.isCollection(currentPath)) {
                this.addAction(ConfigMappingProvider.inlineCollectionPath(currentPath), property, DO_NOTHING);
            }
        } else if (property.isMap()) {
            this.processLazyMapInGroup(currentPath, matchActions, defaultValues, property.asMap(), getEnclosingFunction, namingStrategy, group);
        } else if (property.isCollection()) {
            ConfigMappingInterface.CollectionProperty collectionProperty = property.asCollection();
            currentPath.addLast(currentPath.removeLast() + "[*]");
            this.processProperty(currentPath, matchActions, defaultValues, namingStrategy, group, getEnclosingFunction, type, memberName, collectionProperty.getElement());
        }
    }

    private void processOptionalProperty(ArrayDeque<String> currentPath, KeyMap<BiConsumer<ConfigMappingContext, NameIterator>> matchActions, KeyMap<String> defaultValues, ConfigMappingInterface.NamingStrategy namingStrategy, ConfigMappingInterface group, BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject> getEnclosingFunction, Class<?> type, String memberName, ConfigMappingInterface.Property property) {
        if (property.isGroup()) {
            ConfigMappingInterface.GroupProperty nestedGroup = property.asGroup();
            GetOrCreateEnclosingGroupInGroup matchAction = new GetOrCreateEnclosingGroupInGroup(getEnclosingFunction, group, nestedGroup, currentPath);
            this.processLazyGroupInGroup(currentPath, matchActions, defaultValues, namingStrategy, nestedGroup.getGroupType(), matchAction, new HashSet<String>());
        } else if (property.isLeaf()) {
            ConfigMappingInterface.LeafProperty leafProperty = property.asLeaf();
            if (leafProperty.hasDefaultValue()) {
                defaultValues.findOrAdd(currentPath).putRootValue(leafProperty.getDefaultValue());
                if (ConfigMappingProvider.isCollection(currentPath)) {
                    defaultValues.findOrAdd(ConfigMappingProvider.inlineCollectionPath(currentPath)).putRootValue(leafProperty.getDefaultValue());
                }
            }
            this.addAction(currentPath, property, DO_NOTHING);
            if (ConfigMappingProvider.isCollection(currentPath)) {
                this.addAction(ConfigMappingProvider.inlineCollectionPath(currentPath), property, DO_NOTHING);
            }
        } else if (property.isCollection()) {
            ConfigMappingInterface.CollectionProperty collectionProperty = property.asCollection();
            currentPath.addLast(currentPath.removeLast() + "[*]");
            this.processProperty(currentPath, matchActions, defaultValues, namingStrategy, group, getEnclosingFunction, type, memberName, collectionProperty.getElement());
        }
    }

    private void processLazyGroupInGroup(ArrayDeque<String> currentPath, KeyMap<BiConsumer<ConfigMappingContext, NameIterator>> matchActions, KeyMap<String> defaultValues, ConfigMappingInterface.NamingStrategy namingStrategy, ConfigMappingInterface group, BiConsumer<ConfigMappingContext, NameIterator> matchAction, HashSet<String> usedProperties) {
        int pc = group.getPropertyCount();
        int pathLen = currentPath.size();
        for (int i = 0; i < pc; ++i) {
            ConfigMappingInterface.Property property = group.getProperty(i);
            if (!property.isParentPropertyName()) {
                NameIterator ni = new NameIterator(property.hasPropertyName() ? property.getPropertyName() : ConfigMappingProvider.propertyName(property, group, namingStrategy));
                while (ni.hasNext()) {
                    currentPath.add(ni.getNextSegment());
                    ni.next();
                }
            }
            if (usedProperties.add(String.join((CharSequence)".", String.join((CharSequence)".", currentPath), property.getMethod().getName()))) {
                boolean optional = property.isOptional();
                this.processLazyPropertyInGroup(currentPath, matchActions, defaultValues, matchAction, usedProperties, namingStrategy, group, optional, property);
            }
            while (currentPath.size() > pathLen) {
                currentPath.removeLast();
            }
        }
        int sc = group.getSuperTypeCount();
        for (int i = 0; i < sc; ++i) {
            this.processLazyGroupInGroup(currentPath, matchActions, defaultValues, namingStrategy, group.getSuperType(i), matchAction, usedProperties);
        }
    }

    private void processLazyPropertyInGroup(ArrayDeque<String> currentPath, KeyMap<BiConsumer<ConfigMappingContext, NameIterator>> matchActions, KeyMap<String> defaultValues, BiConsumer<ConfigMappingContext, NameIterator> matchAction, HashSet<String> usedProperties, ConfigMappingInterface.NamingStrategy namingStrategy, ConfigMappingInterface group, boolean optional, ConfigMappingInterface.Property property) {
        if (optional && property.asOptional().getNestedProperty().isGroup()) {
            ConfigMappingInterface.GroupProperty nestedGroup = property.asOptional().getNestedProperty().asGroup();
            GetOrCreateEnclosingGroupInGroup nestedEnclosingFunction = new GetOrCreateEnclosingGroupInGroup(property.isParentPropertyName() ? new GetNestedEnclosing(matchAction) : new ConsumeOneAndThenFn<ConfigMappingObject>(new GetNestedEnclosing(matchAction)), group, nestedGroup, currentPath);
            this.processLazyGroupInGroup(currentPath, matchActions, defaultValues, namingStrategy, nestedGroup.getGroupType(), nestedEnclosingFunction, new HashSet<String>());
        } else if (property.isGroup()) {
            ConfigMappingInterface.GroupProperty asGroup = property.asGroup();
            GetOrCreateEnclosingGroupInGroup nestedEnclosingFunction = new GetOrCreateEnclosingGroupInGroup(property.isParentPropertyName() ? new GetNestedEnclosing(matchAction) : new ConsumeOneAndThenFn<ConfigMappingObject>(new GetNestedEnclosing(matchAction)), group, asGroup, currentPath);
            this.processLazyGroupInGroup(currentPath, matchActions, defaultValues, namingStrategy, asGroup.getGroupType(), nestedEnclosingFunction, usedProperties);
        } else if (property.isLeaf() || property.isPrimitive() || optional && property.asOptional().getNestedProperty().isLeaf()) {
            ConsumeOneAndThen actualAction = property.isParentPropertyName() ? matchAction : new ConsumeOneAndThen(matchAction);
            this.addAction(currentPath, property, actualAction);
            if (ConfigMappingProvider.isCollection(currentPath)) {
                this.addAction(ConfigMappingProvider.inlineCollectionPath(currentPath), property, actualAction);
            }
            if (property.isPrimitive()) {
                ConfigMappingInterface.PrimitiveProperty primitiveProperty = property.asPrimitive();
                if (primitiveProperty.hasDefaultValue()) {
                    defaultValues.findOrAdd(currentPath).putRootValue(primitiveProperty.getDefaultValue());
                    if (ConfigMappingProvider.isCollection(currentPath)) {
                        defaultValues.findOrAdd(ConfigMappingProvider.inlineCollectionPath(currentPath)).putRootValue(primitiveProperty.getDefaultValue());
                    }
                }
            } else if (property.isLeaf() && optional) {
                ConfigMappingInterface.LeafProperty leafProperty = property.asOptional().getNestedProperty().asLeaf();
                if (leafProperty.hasDefaultValue()) {
                    defaultValues.findOrAdd(currentPath).putRootValue(leafProperty.getDefaultValue());
                    if (ConfigMappingProvider.isCollection(currentPath)) {
                        defaultValues.findOrAdd(ConfigMappingProvider.inlineCollectionPath(currentPath)).putRootValue(leafProperty.getDefaultValue());
                    }
                }
            } else {
                ConfigMappingInterface.LeafProperty leafProperty = property.asLeaf();
                if (leafProperty.hasDefaultValue()) {
                    defaultValues.findOrAdd(currentPath).putRootValue(leafProperty.getDefaultValue());
                    if (ConfigMappingProvider.isCollection(currentPath)) {
                        defaultValues.findOrAdd(ConfigMappingProvider.inlineCollectionPath(currentPath)).putRootValue(leafProperty.getDefaultValue());
                    }
                }
            }
        } else if (property.isMap()) {
            GetNestedEnclosing nestedMatchAction = new GetNestedEnclosing(matchAction);
            this.processLazyMapInGroup(currentPath, matchActions, defaultValues, property.asMap(), nestedMatchAction, namingStrategy, group);
        } else if (property.isCollection() || optional && property.asOptional().getNestedProperty().isCollection()) {
            ConfigMappingInterface.CollectionProperty collectionProperty = optional ? property.asOptional().getNestedProperty().asCollection() : property.asCollection();
            currentPath.addLast(currentPath.removeLast() + "[*]");
            this.processLazyPropertyInGroup(currentPath, matchActions, defaultValues, matchAction, usedProperties, namingStrategy, group, false, collectionProperty.getElement());
        }
    }

    private void processLazyMapInGroup(ArrayDeque<String> currentPath, KeyMap<BiConsumer<ConfigMappingContext, NameIterator>> matchActions, KeyMap<String> defaultValues, ConfigMappingInterface.MapProperty property, BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject> getEnclosingGroup, ConfigMappingInterface.NamingStrategy namingStrategy, ConfigMappingInterface enclosingGroup) {
        GetOrCreateEnclosingMapInGroup getEnclosingMap = new GetOrCreateEnclosingMapInGroup(getEnclosingGroup, enclosingGroup, property, currentPath);
        this.processLazyMap(currentPath, matchActions, defaultValues, property, getEnclosingMap, namingStrategy, enclosingGroup);
    }

    private void processLazyMap(ArrayDeque<String> currentPath, KeyMap<BiConsumer<ConfigMappingContext, NameIterator>> matchActions, KeyMap<String> defaultValues, ConfigMappingInterface.MapProperty property, BiFunction<ConfigMappingContext, NameIterator, Map<?, ?>> getEnclosingMap, ConfigMappingInterface.NamingStrategy namingStrategy, ConfigMappingInterface enclosingGroup) {
        ConfigMappingInterface.Property valueProperty = property.getValueProperty();
        Class<Converter<?>> keyConvertWith = property.hasKeyConvertWith() ? property.getKeyConvertWith() : null;
        Class<?> keyRawType = property.getKeyRawType();
        ArrayDeque<String> unnamedPath = new ArrayDeque<String>(currentPath);
        currentPath.addLast("*");
        this.processLazyMapValue(currentPath, matchActions, defaultValues, property, valueProperty, false, keyConvertWith, keyRawType, getEnclosingMap, namingStrategy, enclosingGroup);
        if (property.hasKeyUnnamed()) {
            this.processLazyMapValue(unnamedPath, matchActions, defaultValues, property, valueProperty, true, keyConvertWith, keyRawType, getEnclosingMap, namingStrategy, enclosingGroup);
        }
    }

    private void processLazyMapValue(ArrayDeque<String> currentPath, KeyMap<BiConsumer<ConfigMappingContext, NameIterator>> matchActions, KeyMap<String> defaultValues, ConfigMappingInterface.MapProperty mapProperty, ConfigMappingInterface.Property property, boolean keyUnnamed, Class<? extends Converter<?>> keyConvertWith, Class<?> keyRawType, BiFunction<ConfigMappingContext, NameIterator, Map<?, ?>> getEnclosingMap, ConfigMappingInterface.NamingStrategy namingStrategy, ConfigMappingInterface enclosingGroup) {
        if (property.isLeaf()) {
            ConfigMappingInterface.LeafProperty leafProperty = property.asLeaf();
            Class<? extends Converter<?>> valConvertWith = leafProperty.getConvertWith();
            Class<?> valueRawType = leafProperty.getValueRawType();
            String mapPath = String.join((CharSequence)".", currentPath);
            this.addAction(currentPath, mapProperty, (mc, ni) -> {
                String configKey;
                String rawMapKey;
                NameIterator niMapPath = ConfigMappingProvider.mapPath(mapPath, ni);
                Map map = (Map)getEnclosingMap.apply((ConfigMappingContext)mc, niMapPath);
                boolean indexed = ConfigMappingProvider.isIndexed(ni.getPreviousSegment());
                if (indexed && ni.hasPrevious()) {
                    rawMapKey = ConfigMappingProvider.normalizeIfIndexed(niMapPath.getName().substring(niMapPath.getPosition() + 1));
                    configKey = niMapPath.getAllPreviousSegmentsWith(rawMapKey);
                } else {
                    rawMapKey = niMapPath.getName().substring(niMapPath.getPosition() + 1);
                    configKey = ni.getAllPreviousSegments();
                }
                if (rawMapKey.charAt(0) == '\"' && rawMapKey.charAt(rawMapKey.length() - 1) == '\"') {
                    rawMapKey = rawMapKey.substring(1, rawMapKey.length() - 1);
                }
                SmallRyeConfig config = mc.getConfig();
                Converter keyConv = keyConvertWith != null ? mc.getConverterInstance(keyConvertWith) : config.requireConverter(keyRawType);
                Converter valueConv = valConvertWith != null ? mc.getConverterInstance(valConvertWith) : config.requireConverter(valueRawType);
                if (mapProperty.getValueProperty().isCollection() && valConvertWith == null) {
                    ConfigMappingInterface.CollectionProperty collectionProperty = mapProperty.getValueProperty().asCollection();
                    Class<?> collectionRawType = collectionProperty.getCollectionRawType();
                    IntFunction<Collection<?>> collectionFactory = ConfigMappingContext.createCollectionFactory(collectionRawType);
                    map.put(keyConv.convert(rawMapKey), config.getValues(configKey, valueConv, collectionFactory));
                } else {
                    map.put(keyConv.convert(rawMapKey), config.getValue(configKey, valueConv));
                }
            });
            KeyMap<BiConsumer<ConfigMappingContext, NameIterator>> mapAction = matchActions.find(mapPath);
            if (mapAction != null) {
                mapAction.putAny(matchActions.find(mapPath));
            }
            if (ConfigMappingProvider.isCollection(currentPath)) {
                this.addAction(ConfigMappingProvider.inlineCollectionPath(currentPath), leafProperty, DO_NOTHING);
            }
        } else if (property.isMap()) {
            this.processLazyMap(currentPath, matchActions, defaultValues, property.asMap(), (mc, ni) -> {
                if (!keyUnnamed) {
                    ni.previous();
                }
                Map enclosingMap = (Map)getEnclosingMap.apply((ConfigMappingContext)mc, (NameIterator)ni);
                if (!keyUnnamed) {
                    ni.next();
                }
                String rawMapKey = keyUnnamed ? mapProperty.getKeyUnnamed() : ni.getPreviousSegment();
                SmallRyeConfig config = mc.getConfig();
                Converter keyConv = keyConvertWith != null ? mc.getConverterInstance(keyConvertWith) : config.requireConverter(keyRawType);
                Object key = rawMapKey != null ? keyConv.convert(rawMapKey) : null;
                return (Map)enclosingMap.computeIfAbsent(key, map -> new HashMap());
            }, namingStrategy, enclosingGroup);
        } else if (property.isGroup()) {
            GetOrCreateEnclosingGroupInMap ef = new GetOrCreateEnclosingGroupInMap(getEnclosingMap, mapProperty, keyUnnamed, enclosingGroup, property.asGroup(), currentPath);
            this.processLazyGroupInGroup(currentPath, matchActions, defaultValues, namingStrategy, property.asGroup().getGroupType(), ef, new HashSet<String>());
        } else if (property.isCollection()) {
            ConfigMappingInterface.CollectionProperty collectionProperty = property.asCollection();
            ConfigMappingInterface.Property element = collectionProperty.getElement();
            if (!(element.hasConvertWith() || keyUnnamed || element.isLeaf())) {
                currentPath.addLast(currentPath.removeLast() + "[*]");
            }
            this.processLazyMapValue(currentPath, matchActions, defaultValues, mapProperty, element, keyUnnamed, keyConvertWith, keyRawType, getEnclosingMap, namingStrategy, enclosingGroup);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private void addAction(ArrayDeque<String> currentPath, ConfigMappingInterface.Property property, BiConsumer<ConfigMappingContext, NameIterator> action) {
        KeyMap<BiConsumer<ConfigMappingContext, NameIterator>> current = this.matchActions.findOrAdd(currentPath);
        ConfigMappingInterface.Property previous = this.properties.put(String.join((CharSequence)".", currentPath), property);
        if (current.hasRootValue() && current.getRootValue() != action && previous != null && !previous.equals(property)) {
            throw ConfigMessages.msg.ambiguousMapping(String.join((CharSequence)".", currentPath), property.getMethod().toString(), previous.getMethod().toString());
        }
        current.putRootValue(action);
    }

    private static boolean isCollection(ArrayDeque<String> currentPath) {
        return !currentPath.isEmpty() && currentPath.getLast().endsWith("[*]");
    }

    private static ArrayDeque<String> inlineCollectionPath(ArrayDeque<String> currentPath) {
        ArrayDeque<String> inlineCollectionPath = new ArrayDeque<String>(currentPath);
        String last = inlineCollectionPath.removeLast();
        inlineCollectionPath.addLast(last.substring(0, last.length() - 3));
        return inlineCollectionPath;
    }

    private static String indexName(String name, String groupPath, NameIterator nameIterator) {
        int i;
        String group = new NameIterator(groupPath, true).getPreviousSegment();
        String property = nameIterator.getAllPreviousSegments();
        int start = property.lastIndexOf(ConfigMappingProvider.normalizeIfIndexed(group));
        if (start != -1 && (i = start + ConfigMappingProvider.normalizeIfIndexed(group).length()) < property.length() && property.charAt(i) == '[') {
            while (true) {
                if (property.charAt(i) == ']') {
                    try {
                        int index = Integer.parseInt(property.substring(start + ConfigMappingProvider.normalizeIfIndexed(group).length() + 1, i));
                        return name + "[" + index + "]";
                    }
                    catch (NumberFormatException numberFormatException) {
                        break;
                    }
                }
                if (i >= property.length() - 1) break;
                ++i;
            }
        }
        return name;
    }

    private static NameIterator mapPath(String mapPath, NameIterator propertyName) {
        int segments = 0;
        NameIterator countSegments = new NameIterator(mapPath);
        while (countSegments.hasNext()) {
            ++segments;
            countSegments.next();
        }
        if (mapPath.endsWith("*") || mapPath.endsWith("*[*]")) {
            --segments;
        }
        NameIterator propertyMap = new NameIterator(propertyName.getName());
        propertyMap.next(segments);
        return propertyMap;
    }

    private static String propertyName(ConfigMappingInterface.Property property, ConfigMappingInterface group, ConfigMappingInterface.NamingStrategy namingStrategy) {
        return (String)ConfigMappingProvider.namingStrategy(namingStrategy, group.getNamingStrategy()).apply(property.getPropertyName());
    }

    private static ConfigMappingInterface.NamingStrategy namingStrategy(ConfigMappingInterface.NamingStrategy parent, ConfigMappingInterface.NamingStrategy current) {
        if (!current.isDefault()) {
            return current;
        }
        return parent;
    }

    public static Builder builder() {
        return new Builder();
    }

    KeyMap<BiConsumer<ConfigMappingContext, NameIterator>> getMatchActions() {
        return this.matchActions;
    }

    Map<String, ConfigMappingInterface.Property> getProperties() {
        return this.properties;
    }

    KeyMap<String> getDefaultValues() {
        return this.defaultValues;
    }

    ConfigMappingContext mapConfiguration(SmallRyeConfig config) throws ConfigValidationException {
        for (ConfigSource configSource : config.getConfigSources()) {
            if (!(configSource instanceof DefaultValuesConfigSource)) continue;
            DefaultValuesConfigSource defaultValuesConfigSource = (DefaultValuesConfigSource)configSource;
            defaultValuesConfigSource.registerDefaults(this.defaultValues);
        }
        config.addPropertyNames(ConfigMappingProvider.additionalMappedProperties(new HashSet<String>(this.getProperties().keySet()), this.roots.keySet(), config));
        return SecretKeys.doUnlocked(() -> this.mapConfigurationInternal(config));
    }

    private ConfigMappingContext mapConfigurationInternal(SmallRyeConfig config) throws ConfigValidationException {
        Assert.checkNotNullParam((String)"config", (Object)config);
        ConfigMappingContext context = new ConfigMappingContext(config);
        if (this.roots.isEmpty()) {
            return context;
        }
        config.cachePropertyNames(true);
        for (Map.Entry<String, List<Class<?>>> entry : this.roots.entrySet()) {
            String path = entry.getKey();
            List<Class<?>> roots = entry.getValue();
            for (Class<?> root : roots) {
                StringBuilder sb = context.getStringBuilder();
                sb.replace(0, sb.length(), path);
                ConfigMappingObject group = (ConfigMappingObject)context.constructRoot(root);
                context.registerRoot(root, path, group);
            }
        }
        for (String name : ConfigMappingProvider.filterPropertiesInRoots(config.getPropertyNames(), this.roots.keySet())) {
            NameIterator ni = new NameIterator(name);
            BiConsumer<ConfigMappingContext, NameIterator> action = this.matchActions.findRootValue(ni);
            if (action != null) {
                action.accept(context, ni);
                continue;
            }
            context.unknownProperty(name);
        }
        context.validateUnknown(config.getOptionalValue("smallrye.config.mapping.validate-unknown", Boolean.TYPE).orElse(this.validateUnknown));
        List<ConfigValidationException.Problem> problems = context.getProblems();
        if (!problems.isEmpty()) {
            throw new ConfigValidationException(problems.toArray(ConfigValidationException.Problem.NO_PROBLEMS));
        }
        context.fillInOptionals();
        config.cachePropertyNames(false);
        return context;
    }

    private static Iterable<String> filterPropertiesInRoots(Iterable<String> properties, Set<String> roots) {
        if (roots.isEmpty()) {
            return properties;
        }
        if (roots.contains("")) {
            return properties;
        }
        ArrayList<String> matchedProperties = new ArrayList<String>();
        for (String property : properties) {
            for (String root : roots) {
                char c;
                if (property.length() <= root.length() || (c = property.charAt(root.length())) != '.' && c != '[' || !property.startsWith(root)) continue;
                matchedProperties.add(property);
            }
        }
        return matchedProperties;
    }

    private static Set<String> additionalMappedProperties(Set<String> mappedProperties, Set<String> roots, SmallRyeConfig config) {
        HashSet envProperties = new HashSet();
        for (ConfigSource configSource : config.getConfigSources(EnvConfigSource.class)) {
            envProperties.addAll(configSource.getPropertyNames());
        }
        for (String string : config.getPropertyNames()) {
            mappedProperties.remove(string);
        }
        HashSet<String> envRoots = new HashSet<String>(roots.size());
        for (String string : roots) {
            envRoots.add(StringUtil.replaceNonAlphanumericByUnderscores((String)string));
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (String envProperty : envProperties) {
            boolean matched = false;
            for (String envRoot : envRoots) {
                if (envProperty.length() < envRoot.length() || !envRoot.equalsIgnoreCase(envProperty.substring(0, envRoot.length()))) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            hashSet.add(envProperty);
        }
        envProperties.removeAll(hashSet);
        HashSet<String> hashSet2 = new HashSet<String>();
        NameIterator nameIterator = NameIterator.empty();
        StringBuilder sb = null;
        for (String mappedProperty : mappedProperties) {
            HashSet<String> matchedEnvProperties = new HashSet<String>();
            for (String envProperty : envProperties) {
                if (StringUtil.equalsIgnoreCaseReplacingNonAlphanumericByUnderscores((String)envProperty, (CharSequence)mappedProperty)) {
                    hashSet2.add(mappedProperty);
                    matchedEnvProperties.add(envProperty);
                    break;
                }
                NameIterator ni = nameIterator.with(mappedProperty);
                try {
                    if (sb == null) {
                        sb = new StringBuilder();
                    } else {
                        sb.setLength(0);
                    }
                    while (ni.hasNext()) {
                        int initialLength = sb.length();
                        if (ConfigMappingProvider.isIndexed(ni.getNextSegment(sb), initialLength)) {
                            String propertySegment = sb.substring(initialLength);
                            sb.setLength(initialLength);
                            int position = ni.getPosition();
                            int firstSquareBracket = propertySegment.indexOf("[");
                            int indexStart = firstSquareBracket + position + 1;
                            if (envProperty.length() >= indexStart && envProperty.toLowerCase().startsWith(StringUtil.replaceNonAlphanumericByUnderscores((String)(sb + propertySegment.substring(0, indexStart - position - 1) + "_")))) {
                                int indexEnd = envProperty.indexOf(95, indexStart + 1);
                                sb.append(propertySegment, 0, firstSquareBracket + 1).append(envProperty, indexStart + 1, indexEnd).append(']');
                            }
                        }
                        ni.next();
                        if (!ni.hasNext()) continue;
                        sb.append(".");
                    }
                    if (!StringUtil.equalsIgnoreCaseReplacingNonAlphanumericByUnderscores((String)envProperty, (CharSequence)sb)) continue;
                    hashSet2.add(sb.toString());
                    matchedEnvProperties.add(envProperty);
                }
                finally {
                    if (ni == null) continue;
                    ni.close();
                }
            }
            envProperties.removeAll(matchedEnvProperties);
        }
        return hashSet2;
    }

    private static String normalizeIfIndexed(String propertyName) {
        int indexStart = propertyName.indexOf("[");
        int indexEnd = propertyName.indexOf("]");
        if (indexStart != -1 && indexEnd != -1) {
            String index = propertyName.substring(indexStart + 1, indexEnd);
            if (index.equals("*")) {
                return propertyName.substring(0, indexStart);
            }
            try {
                Integer.parseInt(index);
                return propertyName.substring(0, indexStart);
            }
            catch (NumberFormatException e) {
                return propertyName;
            }
        }
        return propertyName;
    }

    private static boolean isIndexed(String propertyName) {
        int indexStart = propertyName.indexOf("[");
        int indexEnd = propertyName.indexOf("]");
        if (indexStart != -1 && indexEnd != -1) {
            return ConfigMappingProvider.isIndexed0(propertyName, indexEnd, indexStart);
        }
        return false;
    }

    private static boolean isIndexed0(CharSequence propertyName, int indexEnd, int indexStart) {
        int indexLength = indexEnd - (indexStart + 1);
        if (indexLength == 1 && propertyName.charAt(indexStart + 1) == '*') {
            return true;
        }
        try {
            Integer.parseInt(propertyName, indexStart + 1, indexEnd, 10);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean isIndexed(StringBuilder propertyName, int start) {
        int indexStart = propertyName.indexOf("[", start);
        int indexEnd = propertyName.indexOf("]", start);
        if (indexStart != -1 && indexEnd != -1) {
            return ConfigMappingProvider.isIndexed0(propertyName, indexEnd, indexStart);
        }
        return false;
    }

    private static int getIndex(String propertyName) {
        int indexStart = propertyName.indexOf("[");
        int indexEnd = propertyName.indexOf("]");
        if (indexStart != -1 && indexEnd != -1) {
            try {
                return Integer.parseInt(propertyName.substring(indexStart + 1, indexEnd));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException();
            }
        }
        throw new IllegalArgumentException();
    }

    static {
        KeyMap<BiConsumer<ConfigMappingContext, NameIterator>> map = new KeyMap<BiConsumer<ConfigMappingContext, NameIterator>>();
        map.putRootValue(DO_NOTHING);
        map.putAny(map);
        IGNORE_EVERYTHING = map;
    }

    public static final class Builder {
        final Set<Class<?>> types = new HashSet();
        final Map<String, List<Class<?>>> roots = new HashMap();
        final List<String[]> ignored = new ArrayList<String[]>();
        boolean validateUnknown = true;

        Builder() {
        }

        public Builder addRoot(String path, Class<?> type) {
            Assert.checkNotNullParam((String)"path", (Object)path);
            Assert.checkNotNullParam((String)"type", type);
            this.types.add(type);
            this.roots.computeIfAbsent(path, k -> new ArrayList(4)).add(ConfigMappingLoader.getConfigMappingClass(type));
            return this;
        }

        public Builder addIgnored(String path) {
            Assert.checkNotNullParam((String)"path", (Object)path);
            this.ignored.add(path.split("\\."));
            return this;
        }

        public Builder validateUnknown(boolean validateUnknown) {
            this.validateUnknown = validateUnknown;
            return this;
        }

        public ConfigMappingProvider build() {
            boolean allConfigurationProperties = true;
            for (Class<?> type : this.types) {
                if (ConfigMappingClass.getConfigurationClass(type) != null) continue;
                allConfigurationProperties = false;
                break;
            }
            if (allConfigurationProperties) {
                this.validateUnknown = false;
            }
            return new ConfigMappingProvider(this);
        }
    }

    static class GetNestedEnclosing
    implements BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject> {
        private final BiConsumer<ConfigMappingContext, NameIterator> matchAction;

        public GetNestedEnclosing(BiConsumer<ConfigMappingContext, NameIterator> matchAction) {
            this.matchAction = matchAction;
        }

        @Override
        public ConfigMappingObject apply(ConfigMappingContext configMappingContext, NameIterator nameIterator) {
            if (this.matchAction instanceof BiFunction) {
                return (ConfigMappingObject)((BiFunction)((Object)this.matchAction)).apply(configMappingContext, nameIterator);
            }
            return null;
        }
    }

    static class GetFieldOfEnclosing
    implements BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject> {
        private final BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject> getEnclosingFunction;
        private final Class<?> type;
        private final String memberName;

        GetFieldOfEnclosing(BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject> getEnclosingFunction, Class<?> type, String memberName) {
            this.getEnclosingFunction = getEnclosingFunction;
            this.type = type;
            this.memberName = memberName;
        }

        @Override
        public ConfigMappingObject apply(ConfigMappingContext context, NameIterator ni) {
            ConfigMappingObject outer = this.getEnclosingFunction.apply(context, ni);
            return (ConfigMappingObject)context.getEnclosedField(this.type, this.memberName, outer);
        }
    }

    static class GetOrCreateEnclosingMapInGroup
    implements BiFunction<ConfigMappingContext, NameIterator, Map<?, ?>>,
    BiConsumer<ConfigMappingContext, NameIterator> {
        private final BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject> delegate;
        private final ConfigMappingInterface enclosingGroup;
        private final ConfigMappingInterface.MapProperty enclosedGroup;
        private final String groupPath;

        GetOrCreateEnclosingMapInGroup(BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject> delegate, ConfigMappingInterface enclosingGroup, ConfigMappingInterface.MapProperty enclosedGroup, ArrayDeque<String> path) {
            this.delegate = delegate;
            this.enclosingGroup = enclosingGroup;
            this.enclosedGroup = enclosedGroup;
            this.groupPath = String.join((CharSequence)".", path);
        }

        @Override
        public Map<?, ?> apply(ConfigMappingContext context, NameIterator ni) {
            boolean consumeName;
            boolean bl = consumeName = !this.enclosedGroup.isParentPropertyName();
            if (consumeName) {
                ni.previous();
            }
            ConfigMappingObject ourEnclosing = this.delegate.apply(context, ni);
            if (consumeName) {
                ni.next();
            }
            Class<?> enclosingType = this.enclosingGroup.getInterfaceType();
            String key = ConfigMappingProvider.indexName(this.enclosedGroup.getMethod().getName(), this.groupPath, ni);
            HashMap val = (HashMap)context.getEnclosedField(enclosingType, key, ourEnclosing);
            context.applyNamingStrategy(this.enclosingGroup.getNamingStrategy());
            if (val == null) {
                val = new HashMap();
                context.registerEnclosedField(enclosingType, key, ourEnclosing, val);
            }
            return val;
        }

        @Override
        public void accept(ConfigMappingContext context, NameIterator ni) {
            this.apply(context, ni);
        }
    }

    static class GetOrCreateEnclosingGroupInMap
    implements BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject>,
    BiConsumer<ConfigMappingContext, NameIterator> {
        private final BiFunction<ConfigMappingContext, NameIterator, Map<?, ?>> getEnclosingMap;
        private final ConfigMappingInterface.MapProperty enclosingMap;
        private final boolean keyUnnamed;
        private final ConfigMappingInterface enclosingGroup;
        private final ConfigMappingInterface.GroupProperty enclosedGroup;
        private final String mapPath;

        GetOrCreateEnclosingGroupInMap(BiFunction<ConfigMappingContext, NameIterator, Map<?, ?>> getEnclosingMap, ConfigMappingInterface.MapProperty enclosingMap, boolean keyUnnamed, ConfigMappingInterface enclosingGroup, ConfigMappingInterface.GroupProperty enclosedGroup, ArrayDeque<String> path) {
            this.getEnclosingMap = getEnclosingMap;
            this.enclosingMap = enclosingMap;
            this.keyUnnamed = keyUnnamed;
            this.enclosingGroup = enclosingGroup;
            this.enclosedGroup = enclosedGroup;
            this.mapPath = String.join((CharSequence)".", path);
        }

        @Override
        public ConfigMappingObject apply(ConfigMappingContext context, NameIterator ni) {
            NameIterator niMapPath = ConfigMappingProvider.mapPath(this.mapPath, ni);
            MapKey mapKey = this.mapKey(context, ni, niMapPath);
            Map<?, ?> ourEnclosing = this.getEnclosingMap.apply(context, niMapPath);
            ConfigMappingObject val = (ConfigMappingObject)context.getEnclosedField(this.enclosingGroup.getInterfaceType(), mapKey.getKey(), ourEnclosing);
            if (val == null) {
                StringBuilder sb = context.getStringBuilder();
                sb.replace(0, sb.length(), this.keyUnnamed ? niMapPath.getAllPreviousSegments() : niMapPath.getAllPreviousSegmentsWith(mapKey.getKey()));
                context.applyNamingStrategy(ConfigMappingProvider.namingStrategy(this.enclosedGroup.getGroupType().getNamingStrategy(), this.enclosingGroup.getNamingStrategy()));
                val = (ConfigMappingObject)context.constructGroup(this.enclosedGroup.getGroupType().getInterfaceType());
                context.registerEnclosedField(this.enclosingGroup.getInterfaceType(), mapKey.getKey(), ourEnclosing, val);
                if (this.enclosingMap.getValueProperty().isCollection()) {
                    ConfigMappingInterface.CollectionProperty collectionProperty = this.enclosingMap.getValueProperty().asCollection();
                    Collection<?> collection = (Collection<?>)ourEnclosing.get(mapKey.getConvertedKey());
                    if (collection == null) {
                        List<Integer> indexes;
                        Class<?> collectionRawType = collectionProperty.getCollectionRawType();
                        IntFunction<Collection<?>> collectionFactory = ConfigMappingContext.createCollectionFactory(collectionRawType);
                        collection = collectionFactory.apply((indexes = this.keyUnnamed ? List.of(Integer.valueOf(0)) : context.getConfig().getIndexedPropertiesIndexes(niMapPath.getAllPreviousSegmentsWith(mapKey.getNameKey()))).size());
                        if (collection instanceof List) {
                            for (Integer index : indexes) {
                                ((List)collection).add(index, null);
                            }
                        }
                        ourEnclosing.put(mapKey.getConvertedKey(), collection);
                    }
                    if (collection instanceof List) {
                        ((List)collection).set(mapKey.getIndex(), val);
                    } else {
                        collection.add(val);
                    }
                } else {
                    ourEnclosing.put(mapKey.getConvertedKey(), val);
                }
            }
            return val;
        }

        @Override
        public void accept(ConfigMappingContext context, NameIterator ni) {
            this.apply(context, ni);
        }

        private MapKey mapKey(ConfigMappingContext context, NameIterator ni, NameIterator mapPath) {
            if (this.keyUnnamed && this.enclosingMap.getKeyUnnamed() == null) {
                return new MapKey(null, null, null, 0);
            }
            Object rawKey = this.keyUnnamed ? this.enclosingMap.getKeyUnnamed() : mapPath.getNextSegment();
            mapPath.next();
            String pathKey = mapPath.getAllPreviousSegments();
            mapPath.previous();
            Converter converterKey = context.getKeyConverter(this.enclosingGroup.getInterfaceType(), this.enclosingMap.getMethod().getName(), this.enclosingMap.getLevels() - 1);
            Object nameKey = ConfigMappingProvider.normalizeIfIndexed((String)rawKey);
            Object convertedKey = converterKey.convert((String)rawKey);
            if (convertedKey.equals(rawKey)) {
                convertedKey = nameKey;
            }
            int index = -1;
            if (this.enclosingMap.getValueProperty().isCollection()) {
                int n = index = this.keyUnnamed ? 0 : ConfigMappingProvider.getIndex((String)rawKey);
            }
            if (pathKey.charAt(pathKey.length() - 1 - ((String)rawKey).length() + ((String)nameKey).length()) == '\"' && pathKey.charAt(pathKey.length() - 1 - ((String)rawKey).length() - 1) == '\"') {
                nameKey = "\"" + (String)nameKey + "\"";
                Object object = rawKey = this.enclosingMap.getValueProperty().isCollection() ? (String)nameKey + "[" + index + "]" : nameKey;
            }
            if (!this.keyUnnamed && ((String)(index >= 0 ? rawKey : nameKey)).equals(this.enclosingMap.getKeyUnnamed())) {
                throw ConfigMessages.msg.explicitNameInUnnamed(ni.getName(), (String)rawKey);
            }
            return new MapKey((String)rawKey, (String)nameKey, convertedKey, index);
        }

        static class MapKey {
            private final String rawKey;
            private final String nameKey;
            private final Object convertedKey;
            private final int index;

            public MapKey(String rawKey, String nameKey, Object convertedKey, int index) {
                this.rawKey = rawKey;
                this.nameKey = nameKey;
                this.convertedKey = convertedKey;
                this.index = index;
            }

            public String getKey() {
                return this.index >= 0 ? this.rawKey : this.nameKey;
            }

            public String getNameKey() {
                return this.nameKey;
            }

            public Object getConvertedKey() {
                return this.convertedKey;
            }

            public int getIndex() {
                return this.index;
            }
        }
    }

    static class GetOrCreateEnclosingGroupInGroup
    implements BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject>,
    BiConsumer<ConfigMappingContext, NameIterator> {
        private final BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject> delegate;
        private final ConfigMappingInterface enclosingGroup;
        private final ConfigMappingInterface.GroupProperty enclosedGroup;
        private final String groupPath;
        private final int groupDepth;

        GetOrCreateEnclosingGroupInGroup(BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject> delegate, ConfigMappingInterface enclosingGroup, ConfigMappingInterface.GroupProperty enclosedGroup, ArrayDeque<String> path) {
            this.delegate = delegate;
            this.enclosingGroup = enclosingGroup;
            this.enclosedGroup = enclosedGroup;
            this.groupPath = String.join((CharSequence)".", path);
            this.groupDepth = path.size();
        }

        @Override
        public ConfigMappingObject apply(ConfigMappingContext context, NameIterator ni) {
            ConfigMappingObject ourEnclosing = this.delegate.apply(context, ni);
            Class<?> enclosingType = this.enclosingGroup.getInterfaceType();
            String key = ConfigMappingProvider.indexName(this.enclosedGroup.getMethod().getName(), this.groupPath, ni);
            ConfigMappingObject val = (ConfigMappingObject)context.getEnclosedField(enclosingType, key, ourEnclosing);
            context.applyNamingStrategy(ConfigMappingProvider.namingStrategy(this.enclosedGroup.getGroupType().getNamingStrategy(), this.enclosingGroup.getNamingStrategy()));
            if (val == null) {
                NameIterator groupNi = new NameIterator(ni.getName());
                groupNi.next(this.groupDepth);
                StringBuilder sb = context.getStringBuilder();
                sb.replace(0, sb.length(), groupNi.getAllPreviousSegments());
                val = (ConfigMappingObject)context.constructGroup(this.enclosedGroup.getGroupType().getInterfaceType());
                context.registerEnclosedField(enclosingType, key, ourEnclosing, val);
            }
            return val;
        }

        @Override
        public void accept(ConfigMappingContext context, NameIterator nameIterator) {
            this.apply(context, nameIterator);
        }
    }

    static class GetRootAction
    implements BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject> {
        private final Class<?> root;
        private final String rootPath;

        GetRootAction(Class<?> root, String rootPath) {
            this.root = root;
            this.rootPath = rootPath;
        }

        @Override
        public ConfigMappingObject apply(ConfigMappingContext mc, NameIterator ni) {
            return mc.getRoot(this.root, this.rootPath);
        }
    }

    static final class ConsumeOneAndThenFn<T>
    implements BiFunction<ConfigMappingContext, NameIterator, T> {
        private final BiFunction<ConfigMappingContext, NameIterator, T> delegate;

        ConsumeOneAndThenFn(BiFunction<ConfigMappingContext, NameIterator, T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public T apply(ConfigMappingContext context, NameIterator nameIterator) {
            nameIterator.previous();
            T result = this.delegate.apply(context, nameIterator);
            nameIterator.next();
            return result;
        }
    }

    static final class ConsumeOneAndThen
    implements BiConsumer<ConfigMappingContext, NameIterator> {
        private final BiConsumer<ConfigMappingContext, NameIterator> delegate;

        ConsumeOneAndThen(BiConsumer<ConfigMappingContext, NameIterator> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void accept(ConfigMappingContext context, NameIterator nameIterator) {
            nameIterator.previous();
            this.delegate.accept(context, nameIterator);
            nameIterator.next();
        }
    }
}

