/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.io;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.xnio.BufferAllocator;
import org.xnio.ByteBufferSlicePool;
import org.xnio.Pool;

public class BufferPoolService
implements Service<Pool<ByteBuffer>> {
    private final Consumer<Pool<ByteBuffer>> byteBufferConsumer;
    private volatile Pool<ByteBuffer> bufferPool;
    private final int bufferSize;
    private final int buffersPerSlice;
    private final boolean directBuffers;

    public BufferPoolService(Consumer<Pool<ByteBuffer>> byteBufferConsumer, int bufferSize, int buffersPerSlice, boolean directBuffers) {
        this.byteBufferConsumer = byteBufferConsumer;
        this.bufferSize = bufferSize;
        this.buffersPerSlice = buffersPerSlice;
        this.directBuffers = directBuffers;
    }

    public void start(StartContext context) {
        this.bufferPool = new ByteBufferSlicePool(this.directBuffers ? BufferAllocator.DIRECT_BYTE_BUFFER_ALLOCATOR : BufferAllocator.BYTE_BUFFER_ALLOCATOR, this.bufferSize, this.buffersPerSlice * this.bufferSize);
        this.byteBufferConsumer.accept(this.bufferPool);
    }

    public void stop(StopContext context) {
        this.byteBufferConsumer.accept(null);
        ((ByteBufferSlicePool)this.bufferPool).clean();
        this.bufferPool = null;
    }

    public Pool<ByteBuffer> getValue() throws IllegalStateException, IllegalArgumentException {
        return this.bufferPool;
    }
}

