/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.logmanager.LogContext;

public final class LoggingProfileContextSelector {
    private static final LoggingProfileContextSelector INSTANCE = new LoggingProfileContextSelector();
    private final ConcurrentMap<String, LogContext> profileContexts = new ConcurrentHashMap<String, LogContext>();

    private LoggingProfileContextSelector() {
    }

    public static LoggingProfileContextSelector getInstance() {
        return INSTANCE;
    }

    protected LogContext getOrCreate(String loggingProfile) {
        LogContext current;
        LogContext result = (LogContext)this.profileContexts.get(loggingProfile);
        if (result == null && (current = this.profileContexts.putIfAbsent(loggingProfile, result = LogContext.create())) != null) {
            result = current;
        }
        return result;
    }

    public LogContext get(String loggingProfile) {
        return (LogContext)this.profileContexts.get(loggingProfile);
    }

    public boolean exists(String loggingProfile) {
        return this.profileContexts.containsKey(loggingProfile);
    }

    public LogContext remove(String loggingProfile) {
        return (LogContext)this.profileContexts.remove(loggingProfile);
    }
}

