/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.opentelemetry;

import io.smallrye.opentelemetry.api.OpenTelemetryConfig;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringAllowedValuesValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.opentelemetry.OpenTelemetryExtensionLogger;
import org.wildfly.extension.opentelemetry.OpenTelemetrySubsystemAdd;
import org.wildfly.extension.opentelemetry.OpenTelemetrySubsystemExtension;

class OpenTelemetrySubsystemDefinition
extends PersistentResourceDefinition {
    static final String OPENTELEMETRY_MODULE = "org.wildfly.extension.opentelemetry";
    private static final String[] ALLOWED_EXPORTERS = new String[]{"jaeger", "otlp"};
    private static final String[] ALLOWED_SAMPLERS = new String[]{"on", "off", "ratio"};
    private static final String[] ALLOWED_SPAN_PROCESSORS = new String[]{"batch", "simple"};
    public static final String DEFAULT_ENDPOINT = "http://localhost:14250";
    public static final String API_MODULE = "org.wildfly.extension.opentelemetry-api";
    public static final String[] EXPORTED_MODULES = new String[]{"io.opentelemetry.api", "io.opentelemetry.context", "io.opentelemetry.exporter", "io.opentelemetry.sdk", "io.smallrye.opentelemetry"};
    static final RuntimeCapability<Void> OPENTELEMETRY_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.extension.opentelemetry").addRequirements(new String[]{"org.wildfly.weld"}).build();
    public static final WildFlyOpenTelemetryConfigSupplier CONFIG_SUPPLIER = new WildFlyOpenTelemetryConfigSupplier();
    static final RuntimeCapability<WildFlyOpenTelemetryConfigSupplier> OPENTELEMETRY_CONFIG_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.extension.opentelemetry.config", (boolean)false, (Object)CONFIG_SUPPLIER).build();
    @Deprecated
    public static final SimpleAttributeDefinition SERVICE_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"service-name", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition EXPORTER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"exporter-type", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).setAttributeGroup("exporter")).setXmlName("type")).setDefaultValue(new ModelNode("jaeger"))).setValidator((ParameterValidator)new StringAllowedValuesValidator(ALLOWED_EXPORTERS))).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition ENDPOINT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"endpoint", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).setAttributeGroup("exporter")).setRestartAllServices()).setDefaultValue(new ModelNode("http://localhost:14250"))).build();
    @Deprecated
    public static final SimpleAttributeDefinition SPAN_PROCESSOR_TYPE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"span-processor-type", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).setXmlName("type")).setAttributeGroup("span-processor")).setRestartAllServices()).setDefaultValue(new ModelNode("batch"))).setValidator((ParameterValidator)new StringAllowedValuesValidator(ALLOWED_SPAN_PROCESSORS))).build();
    public static final SimpleAttributeDefinition BATCH_DELAY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"batch-delay", (ModelType)ModelType.LONG, (boolean)true).setAllowExpression(true)).setAttributeGroup("span-processor")).setRestartAllServices()).setDefaultValue(new ModelNode(5000))).build();
    public static final SimpleAttributeDefinition MAX_QUEUE_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"max-queue-size", (ModelType)ModelType.LONG, (boolean)true).setAllowExpression(true)).setAttributeGroup("span-processor")).setRestartAllServices()).setDefaultValue(new ModelNode(2048))).build();
    public static final SimpleAttributeDefinition MAX_EXPORT_BATCH_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"max-export-batch-size", (ModelType)ModelType.LONG, (boolean)true).setAllowExpression(true)).setAttributeGroup("span-processor")).setRestartAllServices()).setDefaultValue(new ModelNode(512))).build();
    public static final SimpleAttributeDefinition EXPORT_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"export-timeout", (ModelType)ModelType.LONG, (boolean)true).setAllowExpression(true)).setAttributeGroup("span-processor")).setRestartAllServices()).setDefaultValue(new ModelNode(30000))).build();
    public static final SimpleAttributeDefinition SAMPLER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"sampler-type", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).setXmlName("type")).setAttributeGroup("sampler")).setValidator((ParameterValidator)new StringAllowedValuesValidator(ALLOWED_SAMPLERS))).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition RATIO = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"ratio", (ModelType)ModelType.DOUBLE, (boolean)true).setAllowExpression(true)).setAttributeGroup("sampler")).setValidator((parameterName, value) -> {
        double val;
        if (value.isDefined() && value.getType() != ModelType.EXPRESSION && ((val = value.asDouble()) < 0.0 || val > 1.0)) {
            throw new OperationFailedException((Throwable)OpenTelemetryExtensionLogger.OTEL_LOGGER.invalidRatio());
        }
    })).setRestartAllServices()).build();
    public static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{SERVICE_NAME, EXPORTER, ENDPOINT, SPAN_PROCESSOR_TYPE, BATCH_DELAY, MAX_QUEUE_SIZE, MAX_EXPORT_BATCH_SIZE, EXPORT_TIMEOUT, SAMPLER, RATIO};

    protected OpenTelemetrySubsystemDefinition() {
        super(new SimpleResourceDefinition.Parameters(OpenTelemetrySubsystemExtension.SUBSYSTEM_PATH, (ResourceDescriptionResolver)OpenTelemetrySubsystemExtension.SUBSYSTEM_RESOLVER).setAddHandler((OperationStepHandler)new OpenTelemetrySubsystemAdd()).setRemoveHandler((OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE).setCapabilities(new RuntimeCapability[]{OPENTELEMETRY_CAPABILITY, OPENTELEMETRY_CONFIG_CAPABILITY}));
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(ATTRIBUTES);
    }

    static class WildFlyOpenTelemetryConfigSupplier
    implements Supplier<OpenTelemetryConfig>,
    Consumer<OpenTelemetryConfig> {
        private OpenTelemetryConfig config;

        WildFlyOpenTelemetryConfigSupplier() {
        }

        @Override
        public void accept(OpenTelemetryConfig openTelemetryConfig) {
            this.config = openTelemetryConfig;
        }

        @Override
        public OpenTelemetryConfig get() {
            return this.config;
        }
    }
}

