/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.hibernate.boot.model.process.internal.InferredBasicValueResolver;
import org.hibernate.boot.model.process.internal.UserTypeResolution;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.MetadataBuildingOptions;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.MappingHelper;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.resource.beans.spi.BeanInstanceProducer;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.BasicType;
import org.hibernate.type.CustomType;
import org.hibernate.type.JavaObjectType;
import org.hibernate.type.SerializableType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.type.spi.TypeConfigurationAware;
import org.hibernate.usertype.UserType;

public class TypeDefinition
implements Serializable {
    public static final AtomicInteger NAME_COUNTER = new AtomicInteger();
    private final String name;
    private final Class<?> typeImplementorClass;
    private final String[] registrationKeys;
    private final Map<String, String> parameters;
    private BasicValue.Resolution<?> reusableResolution;

    public TypeDefinition(String name, Class<?> typeImplementorClass, String[] registrationKeys, Map<String, String> parameters) {
        this.name = name;
        this.typeImplementorClass = typeImplementorClass;
        this.registrationKeys = registrationKeys;
        this.parameters = parameters;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getTypeImplementorClass() {
        return this.typeImplementorClass;
    }

    public String[] getRegistrationKeys() {
        return this.registrationKeys;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public BasicValue.Resolution<?> resolve(Map<?, ?> localConfigParameters, MutabilityPlan<?> explicitMutabilityPlan, MetadataBuildingContext context, JdbcTypeIndicators indicators) {
        if (CollectionHelper.isEmpty(localConfigParameters)) {
            if (this.reusableResolution == null) {
                this.reusableResolution = this.createResolution(this.name, Collections.emptyMap(), indicators, context);
            }
            return this.reusableResolution;
        }
        String name = this.name + ":" + NAME_COUNTER.getAndIncrement();
        return this.createResolution(name, localConfigParameters, indicators, context);
    }

    private BasicValue.Resolution<?> createResolution(String name, Map<?, ?> usageSiteProperties, JdbcTypeIndicators indicators, MetadataBuildingContext context) {
        return TypeDefinition.createResolution(name, this.typeImplementorClass, this.parameters, usageSiteProperties, indicators, context);
    }

    private static <T> BasicValue.Resolution<T> createResolution(String name, Class<T> typeImplementorClass, Map<?, ?> parameters, Map<?, ?> usageSiteProperties, JdbcTypeIndicators indicators, MetadataBuildingContext context) {
        boolean isKnownType;
        BootstrapContext bootstrapContext = context.getBootstrapContext();
        TypeConfiguration typeConfiguration = bootstrapContext.getTypeConfiguration();
        BeanInstanceProducer instanceProducer = bootstrapContext.getCustomTypeProducer();
        boolean bl = isKnownType = Type.class.isAssignableFrom(typeImplementorClass) || UserType.class.isAssignableFrom(typeImplementorClass);
        if (isKnownType) {
            T typeInstance = TypeDefinition.instantiateType(bootstrapContext.getServiceRegistry(), context.getBuildingOptions(), name, typeImplementorClass, instanceProducer);
            if (typeInstance instanceof TypeConfigurationAware) {
                TypeConfigurationAware configurationAware = (TypeConfigurationAware)typeInstance;
                configurationAware.setTypeConfiguration(typeConfiguration);
            }
            final Properties combinedTypeParameters = new Properties();
            if (parameters != null) {
                combinedTypeParameters.putAll(parameters);
            }
            if (usageSiteProperties != null) {
                combinedTypeParameters.putAll(usageSiteProperties);
            }
            MappingHelper.injectParameters(typeInstance, combinedTypeParameters);
            if (typeInstance instanceof UserType) {
                UserType userType = (UserType)typeInstance;
                CustomType customType = new CustomType(userType, typeConfiguration);
                return new UserTypeResolution(customType, null, combinedTypeParameters);
            }
            if (typeInstance instanceof BasicType) {
                final BasicType resolvedBasicType = (BasicType)typeInstance;
                return new BasicValue.Resolution<T>(){

                    @Override
                    public JdbcMapping getJdbcMapping() {
                        return resolvedBasicType;
                    }

                    @Override
                    public BasicType<T> getLegacyResolvedBasicType() {
                        return resolvedBasicType;
                    }

                    @Override
                    public Properties getCombinedTypeParameters() {
                        return combinedTypeParameters;
                    }

                    @Override
                    public JavaType<T> getDomainJavaType() {
                        return resolvedBasicType.getMappedJavaType();
                    }

                    @Override
                    public JavaType<?> getRelationalJavaType() {
                        return resolvedBasicType.getMappedJavaType();
                    }

                    @Override
                    public JdbcType getJdbcType() {
                        return resolvedBasicType.getJdbcType();
                    }

                    @Override
                    public BasicValueConverter<T, ?> getValueConverter() {
                        return resolvedBasicType.getValueConverter();
                    }

                    @Override
                    public MutabilityPlan<T> getMutabilityPlan() {
                        return resolvedBasicType.isMutable() ? this.getDomainJavaType().getMutabilityPlan() : ImmutableMutabilityPlan.instance();
                    }
                };
            }
        }
        return TypeDefinition.resolveLegacyCases(typeImplementorClass, indicators, typeConfiguration);
    }

    private static <T> BasicValue.Resolution<T> resolveLegacyCases(Class<T> typeImplementorClass, JdbcTypeIndicators indicators, TypeConfiguration typeConfiguration) {
        AbstractSingleColumnStandardBasicType legacyType;
        if (Serializable.class.isAssignableFrom(typeImplementorClass)) {
            legacyType = new SerializableType<T>(typeImplementorClass);
        } else if (typeImplementorClass.isInterface()) {
            legacyType = new JavaObjectType();
        } else {
            throw new IllegalArgumentException("Named type [" + typeImplementorClass + "] did not implement BasicType nor UserType");
        }
        return TypeDefinition.createBasicTypeResolution(legacyType, typeImplementorClass, indicators, typeConfiguration);
    }

    private static <T> BasicValue.Resolution<T> createBasicTypeResolution(final BasicType<T> type, Class<? extends T> typeImplementorClass, JdbcTypeIndicators indicators, TypeConfiguration typeConfiguration) {
        JavaType jtd = typeConfiguration.getJavaTypeRegistry().resolveDescriptor(typeImplementorClass);
        JdbcType jdbcType = typeConfiguration.getJdbcTypeRegistry().getDescriptor(-3);
        BasicType basicType = typeConfiguration.getBasicTypeRegistry().resolve(jtd, jdbcType);
        final BasicType resolved = InferredBasicValueResolver.resolveSqlTypeIndicators(indicators, basicType, jtd);
        return new BasicValue.Resolution<T>(){

            @Override
            public JdbcMapping getJdbcMapping() {
                return resolved;
            }

            @Override
            public BasicType<T> getLegacyResolvedBasicType() {
                return type;
            }

            @Override
            public JavaType<T> getDomainJavaType() {
                return resolved.getMappedJavaType();
            }

            @Override
            public JavaType<?> getRelationalJavaType() {
                return resolved.getMappedJavaType();
            }

            @Override
            public JdbcType getJdbcType() {
                return resolved.getJdbcType();
            }

            @Override
            public BasicValueConverter<T, ?> getValueConverter() {
                return resolved.getValueConverter();
            }

            @Override
            public MutabilityPlan<T> getMutabilityPlan() {
                return resolved.isMutable() ? this.getDomainJavaType().getMutabilityPlan() : ImmutableMutabilityPlan.instance();
            }
        };
    }

    private static <T> T instantiateType(StandardServiceRegistry serviceRegistry, MetadataBuildingOptions buildingOptions, String name, Class<T> typeImplementorClass, BeanInstanceProducer instanceProducer) {
        if (buildingOptions.disallowExtensionsInCdi()) {
            return name != null ? instanceProducer.produceBeanInstance(name, typeImplementorClass) : instanceProducer.produceBeanInstance(typeImplementorClass);
        }
        ManagedBeanRegistry beanRegistry = serviceRegistry.requireService(ManagedBeanRegistry.class);
        ManagedBean<T> typeBean = name != null ? beanRegistry.getBean(name, typeImplementorClass, instanceProducer) : beanRegistry.getBean(typeImplementorClass, instanceProducer);
        return typeBean.getBeanInstance();
    }

    public static BasicValue.Resolution<?> createLocalResolution(String name, Class<?> typeImplementorClass, Map<?, ?> localTypeParams, MetadataBuildingContext buildingContext) {
        return TypeDefinition.createResolution(name + ":" + NAME_COUNTER.getAndIncrement(), typeImplementorClass, localTypeParams, null, buildingContext.getBootstrapContext().getTypeConfiguration().getCurrentBaseSqlTypeIndicators(), buildingContext);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TypeDefinition)) {
            return false;
        }
        TypeDefinition that = (TypeDefinition)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.typeImplementorClass, that.typeImplementorClass) && Arrays.equals(this.registrationKeys, that.registrationKeys) && Objects.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.typeImplementorClass != null ? this.typeImplementorClass.hashCode() : 0);
        result = 31 * result + (this.registrationKeys != null ? Arrays.hashCode(this.registrationKeys) : 0);
        result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "TypeDefinition{name='" + this.name + "', typeImplementorClass=" + this.typeImplementorClass + ", registrationKeys=" + Arrays.toString(this.registrationKeys) + ", parameters=" + this.parameters + "}";
    }
}

