/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import org.hibernate.HibernateException;
import org.hibernate.Incubating;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.SessionFactory;
import org.hibernate.bytecode.enhance.spi.interceptor.EnhancementAsProxyLazinessInterceptor;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.entry.CacheEntry;
import org.hibernate.cache.spi.entry.ReferenceCacheEntryImpl;
import org.hibernate.cache.spi.entry.StandardCacheEntryImpl;
import org.hibernate.engine.internal.CacheHelper;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.internal.StatefulPersistenceContext;
import org.hibernate.engine.internal.TwoPhaseLoad;
import org.hibernate.engine.internal.Versioning;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.LoadEvent;
import org.hibernate.event.spi.LoadEventListener;
import org.hibernate.event.spi.PostLoadEvent;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.loader.ast.internal.LoaderHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.sql.results.LoadingLogger;
import org.hibernate.stat.internal.StatsHelper;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.type.Type;
import org.hibernate.type.TypeHelper;

public class CacheEntityLoaderHelper {
    public static final CacheEntityLoaderHelper INSTANCE = new CacheEntityLoaderHelper();
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(CacheEntityLoaderHelper.class);

    private CacheEntityLoaderHelper() {
    }

    @Incubating
    public PersistenceContextEntry loadFromSessionCache(EntityKey keyToLoad, LoadEventListener.LoadType options, LockOptions lockOptions, EventSource session) {
        Object old = session.getEntityUsingInterceptor(keyToLoad);
        if (old != null) {
            EntityPersister persister;
            EntityEntry oldEntry = session.getPersistenceContext().getEntry(old);
            if (options.isCheckDeleted() && oldEntry.getStatus().isDeletedOrGone()) {
                LoadingLogger.LOGGER.debug((Object)"Load request found matching entity in context, but it is scheduled for removal; returning null");
                return new PersistenceContextEntry(old, EntityStatus.REMOVED_ENTITY_MARKER);
            }
            if (options.isAllowNulls() && !(persister = session.getFactory().getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(keyToLoad.getEntityName())).isInstance(old)) {
                LOG.debugf("Load request found matching entity in context, but the matched entity was of an inconsistent return type.  Setting status as `%s`", (Object)EntityStatus.INCONSISTENT_RTN_CLASS_MARKER);
                return new PersistenceContextEntry(old, EntityStatus.INCONSISTENT_RTN_CLASS_MARKER);
            }
            LoaderHelper.upgradeLock(old, oldEntry, lockOptions, session);
        }
        return new PersistenceContextEntry(old, EntityStatus.MANAGED);
    }

    public static PersistenceContextEntry loadFromSessionCacheStatic(LoadEvent event, EntityKey keyToLoad, LoadEventListener.LoadType options) {
        return INSTANCE.loadFromSessionCache(event, keyToLoad, options);
    }

    public PersistenceContextEntry loadFromSessionCache(LoadEvent event, EntityKey keyToLoad, LoadEventListener.LoadType options) throws HibernateException {
        EventSource session = event.getSession();
        Object old = session.getEntityUsingInterceptor(keyToLoad);
        if (old != null) {
            EntityPersister persister;
            EntityEntry oldEntry = session.getPersistenceContext().getEntry(old);
            if (options.isCheckDeleted() && oldEntry.getStatus().isDeletedOrGone()) {
                LoadingLogger.LOGGER.debug((Object)"Load request found matching entity in context, but it is scheduled for removal; returning null");
                return new PersistenceContextEntry(old, EntityStatus.REMOVED_ENTITY_MARKER);
            }
            if (options.isAllowNulls() && !(persister = event.getSession().getFactory().getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(keyToLoad.getEntityName())).isInstance(old)) {
                LOG.debug("Load request found matching entity in context, but the matched entity was of an inconsistent return type; returning null");
                return new PersistenceContextEntry(old, EntityStatus.INCONSISTENT_RTN_CLASS_MARKER);
            }
            LoaderHelper.upgradeLock(old, oldEntry, event.getLockOptions(), event.getSession());
        }
        return new PersistenceContextEntry(old, EntityStatus.MANAGED);
    }

    public Object loadFromSecondLevelCache(LoadEvent event, EntityPersister persister, EntityKey entityKey) {
        Object entity = this.loadFromSecondLevelCache(event.getSession(), event.getInstanceToLoad(), event.getLockMode(), persister, entityKey);
        if (entity != null) {
            PostLoadEvent postLoadEvent = event.getPostLoadEvent().setEntity(entity).setId(event.getEntityId()).setPersister(persister);
            event.getSession().getSessionFactory().getFastSessionServices().firePostLoadEvent(postLoadEvent);
        }
        return entity;
    }

    public Object loadFromSecondLevelCache(EventSource source, Object entity, LockMode lockMode, EntityPersister persister, EntityKey entityKey) {
        boolean useCache;
        boolean bl = useCache = persister.canReadFromCache() && source.getCacheMode().isGetEnabled() && lockMode.lessThan(LockMode.READ);
        if (!useCache) {
            return null;
        }
        Object ce = this.getFromSharedCache(entityKey.getIdentifier(), persister, source);
        if (ce == null) {
            return null;
        }
        return this.processCachedEntry(entity, persister, ce, source, entityKey);
    }

    private Object getFromSharedCache(Object entityId, EntityPersister persister, SessionImplementor source) {
        EntityDataAccess cache = persister.getCacheAccessStrategy();
        SessionFactory factory = source.getFactory();
        Object ck = cache.generateCacheKey(entityId, persister, (SessionFactoryImplementor)factory, source.getTenantIdentifier());
        Object ce = CacheHelper.fromSharedCache(source, ck, persister.getCacheAccessStrategy());
        StatisticsImplementor statistics = factory.getStatistics();
        if (statistics.isStatisticsEnabled()) {
            if (ce == null) {
                statistics.entityCacheMiss(StatsHelper.INSTANCE.getRootEntityRole(persister), cache.getRegion().getName());
            } else {
                statistics.entityCacheHit(StatsHelper.INSTANCE.getRootEntityRole(persister), cache.getRegion().getName());
            }
        }
        return ce;
    }

    private Object processCachedEntry(Object instanceToLoad, EntityPersister persister, Object ce, EventSource source, EntityKey entityKey) {
        CacheEntry entry = (CacheEntry)persister.getCacheEntryStructure().destructure(ce, (SessionFactoryImplementor)source.getFactory());
        if (entry.isReferenceEntry()) {
            if (instanceToLoad != null) {
                throw new HibernateException("Attempt to load entity from cache using provided object instance, but cache is storing references: " + entityKey.getIdentifier());
            }
            return this.convertCacheReferenceEntryToEntity((ReferenceCacheEntryImpl)entry, source, entityKey);
        }
        Object entity = this.convertCacheEntryToEntity(entry, entityKey.getIdentifier(), source, persister, instanceToLoad, entityKey);
        if (!persister.isInstance(entity)) {
            PersistenceContext persistenceContext = source.getPersistenceContext();
            persistenceContext.removeEntry(entity);
            persistenceContext.removeEntity(entityKey);
            return null;
        }
        return entity;
    }

    private Object convertCacheReferenceEntryToEntity(ReferenceCacheEntryImpl referenceCacheEntry, SharedSessionContractImplementor session, EntityKey entityKey) {
        Object entity = referenceCacheEntry.getReference();
        if (entity == null) {
            throw new IllegalStateException("Reference cache entry contained null : " + referenceCacheEntry.toString());
        }
        this.makeEntityCircularReferenceSafe(referenceCacheEntry, session, entity, entityKey);
        return entity;
    }

    private void makeEntityCircularReferenceSafe(ReferenceCacheEntryImpl referenceCacheEntry, SharedSessionContractImplementor session, Object entity, EntityKey entityKey) {
        StatefulPersistenceContext statefulPersistenceContext = (StatefulPersistenceContext)session.getPersistenceContext();
        if (ManagedTypeHelper.isManagedEntity(entity)) {
            statefulPersistenceContext.addReferenceEntry(entity, Status.READ_ONLY);
        } else {
            TwoPhaseLoad.addUninitializedCachedEntity(entityKey, entity, referenceCacheEntry.getSubclassPersister(), LockMode.NONE, referenceCacheEntry.getVersion(), session);
        }
        statefulPersistenceContext.initializeNonLazyCollections();
    }

    private Object convertCacheEntryToEntity(CacheEntry entry, Object entityId, EventSource source, EntityPersister persister, Object instanceToLoad, EntityKey entityKey) {
        PersistentAttributeInterceptor persistentAttributeInterceptor;
        Object entity;
        SessionFactory factory = source.getFactory();
        if (LOG.isTraceEnabled()) {
            LOG.tracef("Converting second-level cache entry [%s] into entity : %s", entry, MessageHelper.infoString(persister, entityId, (SessionFactoryImplementor)factory));
        }
        EntityPersister subclassPersister = factory.getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(entry.getSubclass());
        Object object = entity = instanceToLoad == null ? source.instantiate(subclassPersister, entityId) : instanceToLoad;
        if (ManagedTypeHelper.isPersistentAttributeInterceptable(entity) && ((persistentAttributeInterceptor = ManagedTypeHelper.asPersistentAttributeInterceptable(entity).$$_hibernate_getInterceptor()) == null || persistentAttributeInterceptor instanceof EnhancementAsProxyLazinessInterceptor)) {
            persister.getBytecodeEnhancementMetadata().injectInterceptor(entity, entityId, (SharedSessionContractImplementor)source);
        }
        TwoPhaseLoad.addUninitializedCachedEntity(entityKey, entity, subclassPersister, LockMode.NONE, entry.getVersion(), source);
        PersistenceContext persistenceContext = source.getPersistenceContext();
        Type[] types = subclassPersister.getPropertyTypes();
        Object[] values = ((StandardCacheEntryImpl)entry).assemble(entity, entityId, subclassPersister, source.getInterceptor(), source);
        if (((StandardCacheEntryImpl)entry).isDeepCopyNeeded()) {
            TypeHelper.deepCopy(values, types, subclassPersister.getPropertyUpdateability(), values, source);
        }
        Object version = Versioning.getVersion(values, subclassPersister);
        LOG.tracef("Cached Version : %s", version);
        Object proxy = persistenceContext.getProxy(entityKey);
        boolean isReadOnly = proxy != null ? HibernateProxy.extractLazyInitializer(proxy).isReadOnly() : source.isDefaultReadOnly();
        persistenceContext.addEntry(entity, isReadOnly ? Status.READ_ONLY : Status.MANAGED, values, null, entityId, version, LockMode.NONE, true, subclassPersister, false);
        subclassPersister.afterInitialize(entity, source);
        persistenceContext.initializeNonLazyCollections();
        return entity;
    }

    public static class PersistenceContextEntry {
        private final Object entity;
        private final EntityStatus status;

        public PersistenceContextEntry(Object entity, EntityStatus status) {
            this.entity = entity;
            this.status = status;
        }

        public Object getEntity() {
            return this.entity;
        }

        public EntityStatus getStatus() {
            return this.status;
        }

        public boolean isManaged() {
            return EntityStatus.MANAGED == this.status;
        }
    }

    public static enum EntityStatus {
        MANAGED,
        REMOVED_ENTITY_MARKER,
        INCONSISTENT_RTN_CLASS_MARKER;

    }
}

