/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.sql.SQLException;
import java.util.ArrayList;
import org.hibernate.HibernateException;
import org.hibernate.SharedSessionContract;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.BinaryStream;
import org.hibernate.engine.jdbc.internal.BinaryStreamImpl;
import org.hibernate.internal.util.SerializationHelper;
import org.hibernate.tool.schema.extract.spi.ColumnTypeInformation;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.AbstractArrayJavaType;
import org.hibernate.type.descriptor.java.ByteArrayJavaType;
import org.hibernate.type.descriptor.java.CharacterArrayJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.spi.TypeConfiguration;

public class ArrayJavaType<T>
extends AbstractArrayJavaType<T[], T> {
    public ArrayJavaType(BasicType<T> baseDescriptor) {
        this(baseDescriptor.getJavaTypeDescriptor());
    }

    public ArrayJavaType(JavaType<T> baseDescriptor) {
        super(Array.newInstance(baseDescriptor.getJavaTypeClass(), 0).getClass(), baseDescriptor, new ArrayMutabilityPlan<T>(baseDescriptor));
    }

    @Override
    public BasicType<?> resolveType(TypeConfiguration typeConfiguration, Dialect dialect, BasicType<T> elementType, ColumnTypeInformation columnTypeInformation, JdbcTypeIndicators stdIndicators) {
        ArrayJavaType<T> arrayJavaType;
        if (stdIndicators.isLob()) {
            Class javaTypeClass = this.getJavaTypeClass();
            if (javaTypeClass == Byte[].class) {
                return typeConfiguration.getBasicTypeRegistry().resolve(ByteArrayJavaType.INSTANCE, ByteArrayJavaType.INSTANCE.getRecommendedJdbcType(stdIndicators));
            }
            if (javaTypeClass == Character[].class) {
                return typeConfiguration.getBasicTypeRegistry().resolve(CharacterArrayJavaType.INSTANCE, CharacterArrayJavaType.INSTANCE.getRecommendedJdbcType(stdIndicators));
            }
        }
        Class<T> elementJavaTypeClass = elementType.getJavaTypeDescriptor().getJavaTypeClass();
        if (elementType instanceof BasicPluralType || elementJavaTypeClass != null && elementJavaTypeClass.isArray()) {
            return null;
        }
        if (this.getElementJavaType() == elementType.getJavaTypeDescriptor()) {
            arrayJavaType = this;
        } else {
            arrayJavaType = new ArrayJavaType<T>(elementType.getJavaTypeDescriptor());
            typeConfiguration.getJavaTypeRegistry().addDescriptor(arrayJavaType);
        }
        BasicValueConverter<T, ?> valueConverter = elementType.getValueConverter();
        return valueConverter == null ? this.createType(typeConfiguration, dialect, arrayJavaType, elementType, columnTypeInformation, stdIndicators) : this.createTypeUsingConverter(typeConfiguration, dialect, elementType, columnTypeInformation, stdIndicators, valueConverter);
    }

    @Override
    public String extractLoggableRepresentation(T[] value) {
        if (value == null) {
            return "null";
        }
        int iMax = value.length - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        int i = 0;
        while (true) {
            sb.append(this.getElementJavaType().extractLoggableRepresentation(value[i]));
            if (i == iMax) {
                return sb.append(']').toString();
            }
            sb.append(", ");
            ++i;
        }
    }

    @Override
    public boolean areEqual(T[] one, T[] another) {
        if (one == null && another == null) {
            return true;
        }
        if (one == null || another == null) {
            return false;
        }
        if (one.length != another.length) {
            return false;
        }
        int l = one.length;
        for (int i = 0; i < l; ++i) {
            if (this.getElementJavaType().areEqual(one[i], another[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int extractHashCode(T[] value) {
        if (value == null) {
            return 0;
        }
        int result = 1;
        for (T element : value) {
            result = 31 * result + (element == null ? 0 : this.getElementJavaType().extractHashCode(element));
        }
        return result;
    }

    @Override
    public String toString(T[] value) {
        if (value == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        String glue = "";
        for (T v : value) {
            sb.append(glue);
            if (v == null) {
                sb.append("null");
                glue = ",";
                continue;
            }
            sb.append('\"');
            String valstr = this.getElementJavaType().toString(v);
            int len = valstr.length();
            for (int i = 0; i < len; ++i) {
                char c = valstr.charAt(i);
                if (c == '\\' || c == '\"') {
                    sb.append('\\');
                }
                sb.append(c);
            }
            sb.append('\"');
            glue = ",";
        }
        sb.append('}');
        String result = sb.toString();
        return result;
    }

    @Override
    public T[] fromString(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        ArrayList<String> lst = new ArrayList<String>();
        StringBuilder sb = null;
        char lastChar = charSequence.charAt(charSequence.length() - 1);
        char firstChar = charSequence.charAt(0);
        if (firstChar != '{' || lastChar != '}') {
            throw new IllegalArgumentException("Cannot parse given string into array of strings. First and last character must be { and }");
        }
        int len = charSequence.length();
        boolean inquote = false;
        for (int i = 1; i < len; ++i) {
            char c = charSequence.charAt(i);
            if (c == '\"') {
                if (inquote) {
                    lst.add(sb.toString());
                } else {
                    sb = new StringBuilder();
                }
                inquote = !inquote;
                continue;
            }
            if (!inquote) {
                if (Character.isWhitespace(c)) continue;
                if (c == ',') {
                    if (sb == null) {
                        lst.add(null);
                        continue;
                    }
                    sb = null;
                    continue;
                }
                if (i + 4 < len && charSequence.charAt(i) == 'n' && charSequence.charAt(i + 1) == 'u' && charSequence.charAt(i + 2) == 'l' && charSequence.charAt(i + 3) == 'l') {
                    lst.add(null);
                    i += 4;
                    continue;
                }
                if (i + 1 == len) break;
                throw new IllegalArgumentException("Cannot parse given string into array of strings. Outside of quote, but neither whitespace, comma, array end, nor null found.");
            }
            if (c == '\\' && i + 2 < len && (charSequence.charAt(i + 1) == '\\' || charSequence.charAt(i + 1) == '\"')) {
                c = charSequence.charAt(++i);
            }
            sb.append(c);
        }
        Object[] result = (Object[])Array.newInstance(this.getElementJavaType().getJavaTypeClass(), lst.size());
        for (int i = 0; i < result.length; ++i) {
            if (lst.get(i) == null) continue;
            result[i] = this.getElementJavaType().fromString((CharSequence)lst.get(i));
        }
        return result;
    }

    @Override
    public <X> X unwrap(T[] value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (type.isInstance(value)) {
            return (X)value;
        }
        if (type == byte[].class) {
            return (X)ArrayJavaType.toBytes(value);
        }
        if (type == BinaryStream.class) {
            return (X)new BinaryStreamImpl(ArrayJavaType.toBytes(value));
        }
        if (type.isArray()) {
            Class<?> preferredJavaTypeClass = type.getComponentType();
            Object[] unwrapped = (Object[])Array.newInstance(preferredJavaTypeClass, value.length);
            for (int i = 0; i < value.length; ++i) {
                unwrapped[i] = this.getElementJavaType().unwrap(value[i], preferredJavaTypeClass, options);
            }
            return (X)unwrapped;
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> T[] wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof java.sql.Array) {
            try {
                value = ((java.sql.Array)value).getArray();
            }
            catch (SQLException ex) {
                throw new HibernateException(ex);
            }
        }
        if (value instanceof Object[]) {
            Object[] raw = (Object[])value;
            Class componentClass = this.getElementJavaType().getJavaTypeClass();
            Object[] wrapped = (Object[])Array.newInstance(componentClass, raw.length);
            if (componentClass.isAssignableFrom(value.getClass().getComponentType())) {
                for (int i = 0; i < raw.length; ++i) {
                    wrapped[i] = raw[i];
                }
            } else {
                for (int i = 0; i < raw.length; ++i) {
                    wrapped[i] = this.getElementJavaType().wrap(raw[i], options);
                }
            }
            return wrapped;
        }
        if (value instanceof byte[]) {
            return this.fromBytes((byte[])value);
        }
        if (value instanceof BinaryStream) {
            return this.fromBytes(((BinaryStream)value).getBytes());
        }
        throw this.unknownWrap(value.getClass());
    }

    private static <T> byte[] toBytes(T[] value) {
        if (value.getClass().getComponentType().isEnum()) {
            byte[] array = new byte[value.length];
            for (int i = 0; i < value.length; ++i) {
                array[i] = (byte)(value[i] == null ? -1 : (byte)((Enum)value[i]).ordinal());
            }
            return array;
        }
        return SerializationHelper.serialize(value);
    }

    private T[] fromBytes(byte[] value) {
        Class elementClass = this.getElementJavaType().getJavaTypeClass();
        byte[] bytes = value;
        if (elementClass.isEnum()) {
            Object[] array = (Object[])Array.newInstance(elementClass, bytes.length);
            for (int i = 0; i < bytes.length; ++i) {
                array[i] = bytes[i] == -1 ? null : elementClass.getEnumConstants()[bytes[i]];
            }
            return array;
        }
        return (Object[])SerializationHelper.deserialize(value);
    }

    private static class ArrayMutabilityPlan<T>
    implements MutabilityPlan<T[]> {
        private final Class<T> componentClass;
        private final MutabilityPlan<T> componentPlan;

        public ArrayMutabilityPlan(JavaType<T> baseDescriptor) {
            this.componentClass = baseDescriptor.getJavaTypeClass();
            this.componentPlan = baseDescriptor.getMutabilityPlan();
        }

        @Override
        public boolean isMutable() {
            return true;
        }

        @Override
        public T[] deepCopy(T[] value) {
            if (value == null) {
                return null;
            }
            Object[] copy = (Object[])Array.newInstance(this.componentClass, value.length);
            for (int i = 0; i < value.length; ++i) {
                copy[i] = this.componentPlan.deepCopy(value[i]);
            }
            return copy;
        }

        @Override
        public Serializable disassemble(T[] value, SharedSessionContract session) {
            return this.deepCopy(value);
        }

        @Override
        public T[] assemble(Serializable cached, SharedSessionContract session) {
            return this.deepCopy((Object[])cached);
        }
    }
}

