/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.hotrod.session;

import java.time.Duration;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.infinispan.client.hotrod.RemoteCache;
import org.wildfly.clustering.ee.Key;
import org.wildfly.clustering.ee.Mutator;
import org.wildfly.clustering.ee.MutatorFactory;
import org.wildfly.clustering.ee.cache.CacheProperties;
import org.wildfly.clustering.ee.hotrod.HotRodConfiguration;
import org.wildfly.clustering.ee.hotrod.RemoteCacheEntryMutator;
import org.wildfly.clustering.ee.hotrod.RemoteCacheMutatorFactory;
import org.wildfly.clustering.web.cache.session.CompositeSessionMetaData;
import org.wildfly.clustering.web.cache.session.CompositeSessionMetaDataEntry;
import org.wildfly.clustering.web.cache.session.InvalidatableSessionMetaData;
import org.wildfly.clustering.web.cache.session.MutableSessionAccessMetaData;
import org.wildfly.clustering.web.cache.session.MutableSessionCreationMetaData;
import org.wildfly.clustering.web.cache.session.SessionAccessMetaData;
import org.wildfly.clustering.web.cache.session.SessionCreationMetaData;
import org.wildfly.clustering.web.cache.session.SessionCreationMetaDataEntry;
import org.wildfly.clustering.web.cache.session.SessionMetaDataFactory;
import org.wildfly.clustering.web.cache.session.SimpleSessionAccessMetaData;
import org.wildfly.clustering.web.hotrod.session.SessionAccessMetaDataKey;
import org.wildfly.clustering.web.hotrod.session.SessionCreationMetaDataKey;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;

public class HotRodSessionMetaDataFactory<C>
implements SessionMetaDataFactory<CompositeSessionMetaDataEntry<C>> {
    private final RemoteCache<Key<String>, Object> cache;
    private final RemoteCache<SessionCreationMetaDataKey, SessionCreationMetaDataEntry<C>> creationMetaDataCache;
    private final RemoteCache<SessionAccessMetaDataKey, SessionAccessMetaData> accessMetaDataCache;
    private final MutatorFactory<SessionCreationMetaDataKey, SessionCreationMetaDataEntry<C>> creationMetaDataMutatorFactory;
    private final CacheProperties properties;

    public HotRodSessionMetaDataFactory(HotRodConfiguration configuration) {
        this.cache = configuration.getCache();
        this.creationMetaDataCache = configuration.getCache();
        this.creationMetaDataMutatorFactory = new RemoteCacheMutatorFactory(this.creationMetaDataCache);
        this.accessMetaDataCache = configuration.getCache();
        this.properties = configuration.getCacheProperties();
    }

    public CompositeSessionMetaDataEntry<C> createValue(String id, SessionCreationMetaData creationMetaData) {
        SessionCreationMetaDataEntry creationMetaDataEntry = new SessionCreationMetaDataEntry(creationMetaData);
        SimpleSessionAccessMetaData accessMetaData = new SimpleSessionAccessMetaData();
        this.creationMetaDataMutatorFactory.createMutator((Object)new SessionCreationMetaDataKey(id), (Object)creationMetaDataEntry).mutate();
        this.createSessionAccessMetaDataMutator(new SessionAccessMetaDataKey(id), (SessionAccessMetaData)accessMetaData, creationMetaData).mutate();
        return new CompositeSessionMetaDataEntry(creationMetaDataEntry, (SessionAccessMetaData)accessMetaData);
    }

    public CompositeSessionMetaDataEntry<C> findValue(String id) {
        SessionCreationMetaDataKey creationMetaDataKey = new SessionCreationMetaDataKey(id);
        SessionAccessMetaDataKey accessMetaDataKey = new SessionAccessMetaDataKey(id);
        Map entries = this.cache.getAll(Set.of(creationMetaDataKey, accessMetaDataKey));
        SessionCreationMetaDataEntry creationMetaDataEntry = (SessionCreationMetaDataEntry)entries.get((Object)creationMetaDataKey);
        SessionAccessMetaData accessMetaData = (SessionAccessMetaData)entries.get((Object)accessMetaDataKey);
        if (creationMetaDataEntry != null && accessMetaData != null) {
            return new CompositeSessionMetaDataEntry(creationMetaDataEntry, accessMetaData);
        }
        return null;
    }

    public InvalidatableSessionMetaData createSessionMetaData(String id, CompositeSessionMetaDataEntry<C> entry) {
        Mutator mutator;
        boolean newSession = entry.getCreationMetaData().isNew();
        boolean requireMutator = !this.properties.isTransactional() || !newSession;
        SessionCreationMetaData creationMetaData = entry.getCreationMetaData();
        if (requireMutator) {
            SessionCreationMetaDataKey creationMetaDataKey = new SessionCreationMetaDataKey(id);
            SessionCreationMetaDataEntry creationMetaDataEntry = new SessionCreationMetaDataEntry(creationMetaData, entry.getLocalContext());
            mutator = this.creationMetaDataMutatorFactory.createMutator((Object)creationMetaDataKey, (Object)creationMetaDataEntry);
            creationMetaData = new MutableSessionCreationMetaData(creationMetaData, mutator);
        }
        SessionAccessMetaData accessMetaData = entry.getAccessMetaData();
        if (requireMutator) {
            SessionAccessMetaDataKey accessMetaDataKey = new SessionAccessMetaDataKey(id);
            mutator = this.createSessionAccessMetaDataMutator(accessMetaDataKey, accessMetaData, creationMetaData);
            accessMetaData = new MutableSessionAccessMetaData(entry.getAccessMetaData(), mutator);
        }
        return new CompositeSessionMetaData(creationMetaData, accessMetaData);
    }

    public ImmutableSessionMetaData createImmutableSessionMetaData(String id, CompositeSessionMetaDataEntry<C> entry) {
        return new CompositeSessionMetaData(entry.getCreationMetaData(), entry.getAccessMetaData());
    }

    public boolean remove(String id) {
        this.accessMetaDataCache.remove((Object)new SessionAccessMetaDataKey(id));
        this.creationMetaDataCache.remove((Object)new SessionCreationMetaDataKey(id));
        return true;
    }

    private Mutator createSessionAccessMetaDataMutator(SessionAccessMetaDataKey key, SessionAccessMetaData value, final SessionCreationMetaData creationMetaData) {
        return new RemoteCacheEntryMutator(this.accessMetaDataCache, (Object)key, (Object)value, (Function)new Function<SessionAccessMetaData, Duration>(){

            @Override
            public Duration apply(SessionAccessMetaData accessMetaData) {
                return creationMetaData.getTimeout();
            }
        });
    }
}

