/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.function;

import java.util.List;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.function.AbstractSqmFunctionDescriptor;
import org.hibernate.query.sqm.function.SelfRenderingSqmFunction;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.type.spi.TypeConfiguration;

public class JdbcEscapeFunctionDescriptor
extends AbstractSqmFunctionDescriptor {
    private final SqmFunctionDescriptor wrapped;

    public JdbcEscapeFunctionDescriptor(String name, SqmFunctionDescriptor wrapped) {
        super(name);
        this.wrapped = wrapped;
    }

    @Override
    protected <T> SelfRenderingSqmFunction<T> generateSqmFunctionExpression(List<? extends SqmTypedNode<?>> arguments, ReturnableType<T> impliedResultType, QueryEngine queryEngine, TypeConfiguration typeConfiguration) {
        SelfRenderingSqmFunction delegate = this.wrapped.generateSqmExpression(arguments, impliedResultType, queryEngine, typeConfiguration);
        return new SelfRenderingSqmFunction<T>(this, (sqlAppender, sqlAstArguments, walker) -> {
            sqlAppender.appendSql("{fn ");
            delegate.getRenderingSupport().render(sqlAppender, sqlAstArguments, walker);
            sqlAppender.appendSql("}");
        }, arguments, impliedResultType, this.getArgumentsValidator(), this.getReturnTypeResolver(), queryEngine.getCriteriaBuilder(), this.getName());
    }
}

