/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.join.impl;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.search.ConjunctionDISI;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.QueryBitSetProducer;
import org.apache.lucene.util.BitSet;
import org.hibernate.search.backend.lucene.lowlevel.join.impl.ChildDocIds;
import org.hibernate.search.backend.lucene.lowlevel.query.impl.Queries;

public class NestedDocsProvider {
    private final BitSetProducer parentFilter;
    private final Query childQuery;

    public NestedDocsProvider(String parentDocumentPath, String nestedDocumentPath) {
        this(parentDocumentPath, Collections.singleton(nestedDocumentPath), null);
    }

    public NestedDocsProvider(String nestedDocumentPath, Query nestedFilter) {
        this(null, Collections.singleton(nestedDocumentPath), nestedFilter);
    }

    public NestedDocsProvider(Set<String> nestedDocumentPaths) {
        this(null, nestedDocumentPaths, null);
    }

    public NestedDocsProvider(String parentDocumentPath, Set<String> nestedDocumentPaths, Query nestedFilter) {
        Query parentsFilterQuery = Queries.parentsFilterQuery(parentDocumentPath);
        this.parentFilter = new QueryBitSetProducer(parentsFilterQuery);
        this.childQuery = Queries.childDocumentsQuery(nestedDocumentPaths, nestedFilter);
    }

    public ChildDocIds childDocs(LeafReaderContext context, DocIdSetIterator childFilter) throws IOException {
        IndexReaderContext topLevelCtx = ReaderUtil.getTopLevelContext((IndexReaderContext)context);
        IndexSearcher indexSearcher = new IndexSearcher(topLevelCtx);
        Weight childDocsWeight = this.childDocsWeight(indexSearcher);
        return this.childDocs(childDocsWeight, context, childFilter);
    }

    public ChildDocIds childDocs(Weight childDocsWeight, LeafReaderContext context, DocIdSetIterator childFilter) throws IOException {
        DocIdSetIterator childDocs;
        BitSet parentDocs = this.parentFilter.getBitSet(context);
        if (parentDocs == null) {
            return null;
        }
        Scorer s = childDocsWeight.scorer(context);
        DocIdSetIterator docIdSetIterator = childDocs = s == null ? null : s.iterator();
        if (childDocs == null) {
            return null;
        }
        if (childFilter != null) {
            childDocs = ConjunctionDISI.intersectIterators(Arrays.asList(childDocs, childFilter));
        }
        return new ChildDocIds(parentDocs, childDocs);
    }

    public Weight childDocsWeight(IndexSearcher indexSearcher) throws IOException {
        return indexSearcher.createWeight(indexSearcher.rewrite(this.childQuery), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
    }
}

