/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.manager;

import com.sun.faces.config.ConfigurationException;
import com.sun.faces.config.manager.FacesConfigInfo;
import com.sun.faces.config.manager.documents.DocumentInfo;
import com.sun.faces.config.manager.documents.DocumentOrderingWrapper;
import com.sun.faces.config.manager.tasks.FindConfigResourceURIsTask;
import com.sun.faces.config.manager.tasks.ParseConfigResourceToDOMTask;
import com.sun.faces.spi.ConfigurationResourceProvider;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import jakarta.faces.application.ApplicationConfigurationPopulator;
import jakarta.servlet.ServletContext;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class Documents {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();

    public static DocumentInfo[] getXMLDocuments(ServletContext servletContext, List<ConfigurationResourceProvider> providers, ExecutorService executor, boolean validating) {
        ArrayList<FutureTask<Collection<URI>>> uriTasks = new ArrayList<FutureTask<Collection<URI>>>(providers.size());
        for (ConfigurationResourceProvider provider : providers) {
            FutureTask<Collection<URI>> uriTask = new FutureTask<Collection<URI>>(new FindConfigResourceURIsTask(provider, servletContext));
            uriTasks.add(uriTask);
            if (executor != null) {
                executor.execute(uriTask);
                continue;
            }
            uriTask.run();
        }
        ArrayList<FutureTask<DocumentInfo>> docTasks = new ArrayList<FutureTask<DocumentInfo>>(providers.size() << 1);
        HashSet<URI> processedUris = new HashSet<URI>();
        for (FutureTask futureTask : uriTasks) {
            try {
                for (URI uri : (Collection)futureTask.get()) {
                    if (!processedUris.add(uri)) continue;
                    FutureTask<DocumentInfo> docTask = new FutureTask<DocumentInfo>(new ParseConfigResourceToDOMTask(servletContext, validating, uri));
                    docTasks.add(docTask);
                    if (executor != null) {
                        executor.execute(docTask);
                        continue;
                    }
                    docTask.run();
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception exception) {
                throw new ConfigurationException(exception);
            }
        }
        ArrayList<DocumentInfo> docs = new ArrayList<DocumentInfo>(docTasks.size());
        for (FutureTask futureTask : docTasks) {
            try {
                docs.add((DocumentInfo)futureTask.get());
            }
            catch (ExecutionException e) {
                throw new ConfigurationException(e);
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return docs.toArray(new DocumentInfo[docs.size()]);
    }

    public static List<DocumentInfo> getProgrammaticDocuments(List<ApplicationConfigurationPopulator> configPopulators) throws ParserConfigurationException {
        ArrayList<DocumentInfo> programmaticDocuments = new ArrayList<DocumentInfo>();
        DOMImplementation domImpl = Documents.createDOMImplementation();
        for (ApplicationConfigurationPopulator populator : configPopulators) {
            Document facesConfigDoc = Documents.createEmptyFacesConfigDocument(domImpl);
            try {
                populator.populateApplicationConfiguration(facesConfigDoc);
                programmaticDocuments.add(new DocumentInfo(facesConfigDoc, null));
            }
            catch (Throwable e) {
                if (!LOGGER.isLoggable(Level.INFO)) continue;
                LOGGER.log(Level.INFO, "{0} thrown when invoking {1}.populateApplicationConfigurationResources: {2}", new String[]{e.getClass().getName(), populator.getClass().getName(), e.getMessage()});
            }
        }
        return programmaticDocuments;
    }

    public static DocumentInfo[] mergeDocuments(DocumentInfo[] facesDocuments, List<DocumentInfo> programmaticDocuments) {
        if (programmaticDocuments.isEmpty()) {
            return facesDocuments;
        }
        if (Util.isEmpty(facesDocuments)) {
            return programmaticDocuments.toArray(new DocumentInfo[0]);
        }
        ArrayList<DocumentInfo> mergedDocuments = new ArrayList<DocumentInfo>(facesDocuments.length + programmaticDocuments.size());
        mergedDocuments.add(programmaticDocuments.get(0));
        mergedDocuments.addAll(Arrays.asList(facesDocuments));
        mergedDocuments.addAll(programmaticDocuments.subList(1, programmaticDocuments.size()));
        return mergedDocuments.toArray(new DocumentInfo[0]);
    }

    public static DocumentInfo[] sortDocuments(DocumentInfo[] facesDocuments, FacesConfigInfo webInfFacesConfig) {
        int len = webInfFacesConfig.isWebInfFacesConfig() ? facesDocuments.length - 1 : facesDocuments.length;
        List<String> absoluteOrdering = webInfFacesConfig.getAbsoluteOrdering();
        if (len > 1) {
            ArrayList<DocumentOrderingWrapper> list = new ArrayList<DocumentOrderingWrapper>();
            for (int i = 1; i < len; ++i) {
                list.add(new DocumentOrderingWrapper(facesDocuments[i]));
            }
            DocumentOrderingWrapper[] ordering = list.toArray(new DocumentOrderingWrapper[list.size()]);
            if (absoluteOrdering == null) {
                DocumentOrderingWrapper.sort(ordering);
                for (int i = 1; i < len; ++i) {
                    facesDocuments[i] = ordering[i - 1].getDocument();
                }
                return facesDocuments;
            }
            DocumentOrderingWrapper[] result = DocumentOrderingWrapper.sort(ordering, absoluteOrdering);
            DocumentInfo[] ret = new DocumentInfo[webInfFacesConfig.isWebInfFacesConfig() ? result.length + 2 : result.length + 1];
            for (int i = 1; i < len; ++i) {
                ret[i] = result[i - 1].getDocument();
            }
            ret[0] = facesDocuments[0];
            if (webInfFacesConfig.isWebInfFacesConfig()) {
                ret[ret.length - 1] = facesDocuments[facesDocuments.length - 1];
            }
            return ret;
        }
        return facesDocuments;
    }

    private static DOMImplementation createDOMImplementation() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        return documentBuilderFactory.newDocumentBuilder().getDOMImplementation();
    }

    private static Document createEmptyFacesConfigDocument(DOMImplementation domImpl) {
        Document document = domImpl.createDocument("https://jakarta.ee/xml/ns/jakartaee", "faces-config", null);
        Attr versionAttribute = document.createAttribute("version");
        versionAttribute.setValue("4.0");
        document.getDocumentElement().getAttributes().setNamedItem(versionAttribute);
        return document;
    }
}

