/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra.inflow;

import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.endpoint.MessageEndpoint;
import jakarta.resource.spi.endpoint.MessageEndpointFactory;
import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.TransactionSynchronizationRegistry;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.UUID;
import javax.transaction.xa.XAResource;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.FailoverEventListener;
import org.apache.activemq.artemis.api.core.client.FailoverEventType;
import org.apache.activemq.artemis.api.core.client.MessageHandler;
import org.apache.activemq.artemis.core.client.impl.ClientConsumerInternal;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.ClientSessionInternal;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.jms.client.ActiveMQMessage;
import org.apache.activemq.artemis.jms.client.ConnectionFactoryOptions;
import org.apache.activemq.artemis.jms.client.compatible1X.ActiveMQCompatibleMessage;
import org.apache.activemq.artemis.ra.ActiveMQRALogger;
import org.apache.activemq.artemis.ra.ActiveMQResourceAdapter;
import org.apache.activemq.artemis.ra.inflow.ActiveMQActivation;
import org.apache.activemq.artemis.ra.inflow.ActiveMQActivationSpec;
import org.apache.activemq.artemis.service.extensions.ServiceUtils;
import org.apache.activemq.artemis.service.extensions.xa.ActiveMQXAResourceWrapper;
import org.apache.activemq.artemis.utils.AutoCreateUtil;
import org.apache.activemq.artemis.utils.FutureLatch;
import org.apache.activemq.artemis.utils.VersionLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQMessageHandler
implements MessageHandler,
FailoverEventListener {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ClientSessionInternal session;
    private ClientConsumerInternal consumer;
    private MessageEndpoint endpoint;
    private final ConnectionFactoryOptions options;
    private final ActiveMQActivation activation;
    private boolean useLocalTx;
    private boolean transacted;
    private boolean useXA = false;
    private final int sessionNr;
    private final TransactionSynchronizationRegistry tsr;
    private ClientSessionFactory cf;
    private volatile boolean connected;
    private boolean enable1XPrefix;

    public ActiveMQMessageHandler(ConnectionFactoryOptions options, ActiveMQActivation activation, TransactionSynchronizationRegistry tsr, ClientSessionInternal session, ClientSessionFactory cf, int sessionNr) {
        this.options = options;
        this.activation = activation;
        this.session = session;
        this.cf = cf;
        this.sessionNr = sessionNr;
        this.tsr = tsr;
    }

    public void setup() throws Exception {
        SimpleString selectorString;
        logger.trace("setup()");
        this.enable1XPrefix = this.activation.getConnectionFactory().isEnable1xPrefixes();
        ActiveMQActivationSpec spec = this.activation.getActivationSpec();
        String selector = spec.getMessageSelector();
        SimpleString simpleString = selectorString = selector == null || selector.trim().equals("") ? null : new SimpleString(selector);
        if (this.activation.isTopic() && spec.isSubscriptionDurable().booleanValue()) {
            SimpleString queueName = ActiveMQDestination.createQueueNameForSubscription((boolean)true, (String)spec.getClientID(), (String)spec.getSubscriptionName());
            ClientSession.QueueQuery subResponse = this.session.queueQuery(queueName);
            if (!subResponse.isExists()) {
                this.session.createQueue(new QueueConfiguration(queueName).setAddress(this.activation.getAddress()).setFilterString(selectorString));
            } else {
                boolean topicChanged;
                if (this.sessionNr == 0 && subResponse.getConsumerCount() > 0) {
                    if (!spec.isShareSubscriptions().booleanValue()) {
                        throw ActiveMQRALogger.LOGGER.canNotCreatedNonSharedSubscriber();
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("the mdb on destination {} already had {} consumers but the MDB is configured to share subscriptions, so no exceptions are thrown", (Object)queueName, (Object)subResponse.getConsumerCount());
                    }
                }
                SimpleString oldFilterString = subResponse.getFilterString();
                boolean selectorChanged = selector == null && oldFilterString != null || oldFilterString == null && selector != null || oldFilterString != null && selector != null && !oldFilterString.toString().equals(selector);
                SimpleString oldTopicName = (this.enable1XPrefix && !subResponse.getAddress().startsWith(PacketImpl.OLD_TOPIC_PREFIX) ? PacketImpl.OLD_TOPIC_PREFIX : SimpleString.toSimpleString((String)"")).concat(subResponse.getAddress());
                boolean bl = topicChanged = !oldTopicName.equals((Object)this.activation.getAddress());
                if (selectorChanged || topicChanged) {
                    this.session.deleteQueue(queueName);
                    this.session.createQueue(new QueueConfiguration(queueName).setAddress(this.activation.getAddress()).setFilterString(selectorString));
                }
            }
            this.consumer = (ClientConsumerInternal)this.session.createConsumer(queueName, null, false);
        } else {
            SimpleString tempQueueName;
            if (this.activation.isTopic()) {
                if (this.activation.getTopicTemporaryQueue() == null) {
                    tempQueueName = new SimpleString(UUID.randomUUID().toString());
                    this.session.createQueue(new QueueConfiguration(tempQueueName).setAddress(this.activation.getAddress()).setFilterString(selectorString).setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
                    this.activation.setTopicTemporaryQueue(tempQueueName);
                } else {
                    tempQueueName = this.activation.getTopicTemporaryQueue();
                    ClientSession.QueueQuery queueQuery = this.session.queueQuery(tempQueueName);
                    if (!queueQuery.isExists()) {
                        this.session.createQueue(new QueueConfiguration(tempQueueName).setAddress(this.activation.getAddress()).setFilterString(selectorString).setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
                    }
                }
            } else {
                tempQueueName = this.activation.getAddress();
                AutoCreateUtil.autoCreateQueue((ClientSession)this.session, (SimpleString)tempQueueName, null);
            }
            this.consumer = (ClientConsumerInternal)this.session.createConsumer(tempQueueName, selectorString);
        }
        MessageEndpointFactory endpointFactory = this.activation.getMessageEndpointFactory();
        this.useLocalTx = !this.activation.isDeliveryTransacted() && this.activation.getActivationSpec().isUseLocalTx() != false;
        this.transacted = this.activation.isDeliveryTransacted();
        if (this.activation.isDeliveryTransacted() && !this.activation.getActivationSpec().isUseLocalTx().booleanValue()) {
            HashMap<String, String> xaResourceProperties = new HashMap<String, String>();
            xaResourceProperties.put("ACTIVEMQ_JNDI_ID", ((ActiveMQResourceAdapter)spec.getResourceAdapter()).getJndiName());
            xaResourceProperties.put("ACTIVEMQ_NODE_ID", ((ClientSessionFactoryInternal)this.cf).getLiveNodeId());
            xaResourceProperties.put("ACTIVEMQ_PRODUCT_NAME", "ActiveMQ Artemis");
            xaResourceProperties.put("ACTIVEMQ_PRODUCT_VERSION", VersionLoader.getVersion().getFullVersion());
            ActiveMQXAResourceWrapper xaResource = ServiceUtils.wrapXAResource((XAResource)this.session, xaResourceProperties);
            this.endpoint = endpointFactory.createEndpoint((XAResource)xaResource);
            this.useXA = true;
        } else {
            this.endpoint = endpointFactory.createEndpoint(null);
            this.useXA = false;
        }
        this.connected = true;
        this.session.addFailoverListener((FailoverEventListener)this);
        this.consumer.setMessageHandler((MessageHandler)this);
    }

    XAResource getXAResource() {
        return this.useXA ? this.session : null;
    }

    public Thread getCurrentThread() {
        if (this.consumer == null) {
            return null;
        }
        return this.consumer.getCurrentThread();
    }

    public Thread interruptConsumer(FutureLatch future) {
        try {
            if (this.consumer != null) {
                return this.consumer.prepareForClose(future);
            }
        }
        catch (Throwable e) {
            ActiveMQRALogger.LOGGER.errorInterruptingHandler(this.endpoint.toString(), this.consumer.toString(), e);
        }
        return null;
    }

    public void teardown() {
        logger.trace("teardown()");
        try {
            if (this.endpoint != null) {
                this.endpoint.release();
                this.endpoint = null;
            }
        }
        catch (Throwable t) {
            logger.debug("Error releasing endpoint {}", (Object)this.endpoint, (Object)t);
        }
        if (this.connected) {
            try {
                SimpleString tmpQueue;
                ClientSession.QueueQuery subResponse;
                this.consumer.close();
                if (this.activation.getTopicTemporaryQueue() != null && (subResponse = this.session.queueQuery(tmpQueue = this.activation.getTopicTemporaryQueue())).getConsumerCount() == 0) {
                    this.session.deleteQueue(tmpQueue);
                }
            }
            catch (Throwable t) {
                logger.debug("Error closing core-queue consumer", t);
            }
            try {
                if (this.session != null) {
                    this.session.close();
                }
            }
            catch (Throwable t) {
                logger.debug("Error releasing session {}", (Object)this.session, (Object)t);
            }
            try {
                if (this.cf != null) {
                    this.cf.close();
                }
            }
            catch (Throwable t) {
                logger.debug("Error releasing session factory {}", (Object)this.session, (Object)t);
            }
        } else {
            try {
                if (this.cf != null) {
                    this.cf.cleanup();
                }
            }
            catch (Throwable t) {
                logger.debug("Error releasing session factory {}", (Object)this.session, (Object)t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(ClientMessage message) {
        logger.trace("onMessage({})", (Object)message);
        ActiveMQMessage msg = this.enable1XPrefix ? ActiveMQCompatibleMessage.createMessage((ClientMessage)message, (ClientSession)this.session, (ConnectionFactoryOptions)this.options) : ActiveMQMessage.createMessage((ClientMessage)message, (ClientSession)this.session, (ConnectionFactoryOptions)this.options);
        boolean beforeDelivery = false;
        try {
            TransactionManager tm;
            if (this.activation.getActivationSpec().getTransactionTimeout() > 0 && (tm = ServiceUtils.getTransactionManager()) != null) {
                tm.setTransactionTimeout(this.activation.getActivationSpec().getTransactionTimeout().intValue());
            }
            logger.trace("ActiveMQMessageHandler::calling beforeDelivery on message {}", (Object)message);
            this.endpoint.beforeDelivery(ActiveMQActivation.ONMESSAGE);
            beforeDelivery = true;
            msg.doBeforeReceive();
            if (this.transacted) {
                message.individualAcknowledge();
            }
            ((MessageListener)this.endpoint).onMessage((Message)msg);
            if (!this.transacted) {
                message.individualAcknowledge();
            }
            logger.trace("ActiveMQMessageHandler::calling afterDelivery on message {}", (Object)message);
            try {
                this.endpoint.afterDelivery();
            }
            catch (ResourceException e) {
                ActiveMQRALogger.LOGGER.unableToCallAfterDelivery((Exception)((Object)e));
                this.session.markRollbackOnly();
                try {
                    TransactionManager tm2;
                    if (this.activation.getActivationSpec().getTransactionTimeout() > 0 && (tm2 = ServiceUtils.getTransactionManager()) != null) {
                        try {
                            tm2.setTransactionTimeout(0);
                        }
                        catch (SystemException systemException) {
                            // empty catch block
                        }
                    }
                    this.session.resetIfNeeded();
                }
                catch (ActiveMQException e2) {
                    ActiveMQRALogger.LOGGER.unableToResetSession(this.activation.toString(), (Exception)((Object)e2));
                    this.activation.startReconnectThread("Reset MessageHandler after Failure Thread");
                }
                return;
            }
            if (this.useLocalTx) {
                this.session.commit();
            }
            logger.trace("finished onMessage on {}", (Object)message);
        }
        catch (Throwable e) {
            ActiveMQRALogger.LOGGER.errorDeliveringMessage(e);
            int status = 6;
            if (this.useXA && this.tsr != null) {
                status = this.tsr.getTransactionStatus();
            }
            if (beforeDelivery || status != 6) {
                if (this.useXA && this.tsr != null) {
                    this.tsr.setRollbackOnly();
                }
                MessageEndpoint endToUse = this.endpoint;
                try {
                    if (endToUse != null) {
                        endToUse.afterDelivery();
                    }
                }
                catch (ResourceException e1) {
                    ActiveMQRALogger.LOGGER.unableToCallAfterDelivery((Exception)((Object)e1));
                }
            }
            if (this.useLocalTx || !this.activation.isDeliveryTransacted()) {
                try {
                    this.session.rollback(true);
                }
                catch (ActiveMQException e1) {
                    ActiveMQRALogger.LOGGER.unableToRollbackTX();
                }
            }
            this.session.markRollbackOnly();
        }
        finally {
            try {
                TransactionManager tm;
                if (this.activation.getActivationSpec().getTransactionTimeout() > 0 && (tm = ServiceUtils.getTransactionManager()) != null) {
                    try {
                        tm.setTransactionTimeout(0);
                    }
                    catch (SystemException systemException) {}
                }
                this.session.resetIfNeeded();
            }
            catch (ActiveMQException e) {
                ActiveMQRALogger.LOGGER.unableToResetSession(this.activation.toString(), (Exception)((Object)e));
                this.activation.startReconnectThread("Reset MessageHandler after Failure Thread");
            }
        }
    }

    public void start() throws ActiveMQException {
        this.session.start();
    }

    public void failoverEvent(FailoverEventType eventType) {
        this.connected = eventType == FailoverEventType.FAILOVER_COMPLETED;
    }
}

