/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.impl;

import io.smallrye.reactive.messaging.kafka.api.IncomingKafkaRecordMetadata;
import io.smallrye.reactive.messaging.kafka.api.OutgoingKafkaRecordMetadata;
import io.smallrye.reactive.messaging.kafka.impl.RuntimeKafkaSinkConfiguration;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;

public class KafkaRecordHelper {
    public static Headers getHeaders(OutgoingKafkaRecordMetadata<?> om, IncomingKafkaRecordMetadata<?, ?> im, RuntimeKafkaSinkConfiguration configuration) {
        RecordHeaders headers = new RecordHeaders();
        if (KafkaRecordHelper.isNotBlank(configuration.getPropagateHeaders()) && im != null && im.getHeaders() != null) {
            Set headersToPropagate = Arrays.stream(configuration.getPropagateHeaders().split(",")).map(String::trim).collect(Collectors.toSet());
            for (Header header : im.getHeaders()) {
                if (!headersToPropagate.contains(header.key())) continue;
                headers.add(header);
            }
        }
        if (om != null && om.getHeaders() != null) {
            om.getHeaders().forEach(arg_0 -> ((Headers)headers).add(arg_0));
        }
        return headers;
    }

    public static boolean isNotBlank(String s) {
        return s != null && !s.trim().isEmpty();
    }
}

