/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.interceptors;

import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.weld.WeldBootstrapService;
import org.jboss.as.weld.interceptors.WeldInterceptorInstances;
import org.jboss.as.weld.spi.ComponentInterceptorSupport;
import org.jboss.as.weld.spi.InterceptorInstances;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.contexts.WeldCreationalContext;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.ejb.spi.InterceptorBindings;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.serialization.spi.helpers.SerializableContextualInstance;

public class Jsr299BindingsCreateInterceptor
implements Interceptor {
    private final Supplier<WeldBootstrapService> weldContainerSupplier;
    private final Supplier<InterceptorBindings> interceptorBindingsSupplier;
    private final String beanArchiveId;
    private final String ejbName;
    private final ComponentInterceptorSupport interceptorSupport;
    private volatile BeanManagerImpl beanManager;

    public Jsr299BindingsCreateInterceptor(Supplier<WeldBootstrapService> weldContainerSupplier, Supplier<InterceptorBindings> interceptorBindingsSupplier, String beanArchiveId, String ejbName, ComponentInterceptorSupport interceptorSupport) {
        this.weldContainerSupplier = weldContainerSupplier;
        this.interceptorBindingsSupplier = interceptorBindingsSupplier;
        this.beanArchiveId = beanArchiveId;
        this.ejbName = ejbName;
        this.interceptorSupport = interceptorSupport;
    }

    private void addInterceptorInstance(jakarta.enterprise.inject.spi.Interceptor<Object> interceptor, BeanManagerImpl beanManager, Map<String, SerializableContextualInstance<jakarta.enterprise.inject.spi.Interceptor<Object>, Object>> instances, CreationalContext<Object> creationalContext) {
        Object instance = beanManager.getReference(interceptor, (Type)interceptor.getBeanClass(), creationalContext, true);
        SerializableContextualInstance serializableContextualInstance = ((ContextualStore)beanManager.getServices().get(ContextualStore.class)).getSerializableContextualInstance(interceptor, instance, creationalContext);
        instances.put(interceptor.getBeanClass().getName(), (SerializableContextualInstance<jakarta.enterprise.inject.spi.Interceptor<Object>, Object>)serializableContextualInstance);
    }

    public Object processInvocation(InterceptorContext interceptorContext) throws Exception {
        EjbDescriptor descriptor;
        BeanManagerImpl beanManager = this.beanManager;
        if (beanManager == null) {
            beanManager = this.beanManager = this.weldContainerSupplier.get().getBeanManager(this.beanArchiveId);
        }
        SessionBean bean = null;
        if (this.ejbName != null && (descriptor = beanManager.getEjbDescriptor(this.ejbName)) != null) {
            bean = beanManager.getBean(descriptor);
        }
        InterceptorBindings interceptorBindings = this.interceptorBindingsSupplier.get();
        ComponentInstance componentInstance = (ComponentInstance)interceptorContext.getPrivateData(ComponentInstance.class);
        InterceptorInstances existing = this.interceptorSupport.getInterceptorInstances(componentInstance);
        if (existing == null) {
            WeldCreationalContext creationalContext = beanManager.createCreationalContext((Contextual)bean);
            HashMap<String, SerializableContextualInstance<jakarta.enterprise.inject.spi.Interceptor<Object>, Object>> interceptorInstances = new HashMap<String, SerializableContextualInstance<jakarta.enterprise.inject.spi.Interceptor<Object>, Object>>();
            if (interceptorBindings != null) {
                for (jakarta.enterprise.inject.spi.Interceptor interceptor : interceptorBindings.getAllInterceptors()) {
                    this.addInterceptorInstance((jakarta.enterprise.inject.spi.Interceptor<Object>)interceptor, beanManager, interceptorInstances, (CreationalContext<Object>)creationalContext);
                }
            }
            this.interceptorSupport.setInterceptorInstances(componentInstance, (InterceptorInstances)new WeldInterceptorInstances((CreationalContext)creationalContext, interceptorInstances));
        }
        return interceptorContext.proceed();
    }
}

