/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.collector.impl;

import java.io.IOException;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.hibernate.search.backend.lucene.document.impl.LuceneIdReader;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorExecutionContext;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.Values;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.IndexReaderMetadataResolver;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneDocumentReference;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionExtractContext;
import org.hibernate.search.engine.backend.common.DocumentReference;

public abstract class DocumentReferenceValues<R>
implements Values<R> {
    private final LuceneIdReader idReader;
    private final IndexReaderMetadataResolver metadataResolver;
    private String currentLeafMappedTypeName;
    private BinaryDocValues currentLeafIdDocValues;

    public static DocumentReferenceValues<DocumentReference> simple(ProjectionExtractContext context) {
        return new DocumentReferenceValues<DocumentReference>(context.idReader(), (CollectorExecutionContext)context.collectorExecutionContext()){

            @Override
            protected DocumentReference toReference(String typeName, String identifier) {
                return new LuceneDocumentReference(typeName, identifier);
            }
        };
    }

    protected DocumentReferenceValues(LuceneIdReader idReader, CollectorExecutionContext executionContext) {
        this.idReader = idReader;
        this.metadataResolver = executionContext.getMetadataResolver();
    }

    @Override
    public final void context(LeafReaderContext context) throws IOException {
        this.currentLeafMappedTypeName = this.metadataResolver.resolveMappedTypeName(context);
        this.currentLeafIdDocValues = this.idReader.idDocValues(context.reader());
    }

    @Override
    public final R get(int doc) throws IOException {
        this.currentLeafIdDocValues.advance(doc);
        return this.toReference(this.currentLeafMappedTypeName, this.currentLeafIdDocValues.binaryValue().utf8ToString());
    }

    protected abstract R toReference(String var1, String var2);
}

