/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.providers.impl;

import io.smallrye.reactive.messaging.ChannelRegistry;
import io.smallrye.reactive.messaging.MutinyEmitter;
import io.smallrye.reactive.messaging.providers.i18n.ProviderMessages;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Flow;
import java.util.stream.Collectors;
import org.eclipse.microprofile.reactive.messaging.Emitter;
import org.eclipse.microprofile.reactive.messaging.Message;

@ApplicationScoped
public class InternalChannelRegistry
implements ChannelRegistry {
    private final Map<String, List<Flow.Publisher<? extends Message<?>>>> publishers = new ConcurrentHashMap();
    private final Map<String, List<Flow.Subscriber<? extends Message<?>>>> subscribers = new ConcurrentHashMap();
    private final Map<String, Boolean> outgoing = new ConcurrentHashMap<String, Boolean>();
    private final Map<String, Boolean> incoming = new ConcurrentHashMap<String, Boolean>();
    private final Map<Class<?>, Map<String, Object>> emitters = new ConcurrentHashMap();

    public Flow.Publisher<? extends Message<?>> register(String name, Flow.Publisher<? extends Message<?>> stream, boolean broadcast) {
        Objects.requireNonNull(name, ProviderMessages.msg.nameMustBeSet());
        Objects.requireNonNull(stream, ProviderMessages.msg.streamMustBeSet());
        this.register(this.publishers, name, stream);
        this.outgoing.put(name, broadcast);
        return stream;
    }

    public Flow.Subscriber<? extends Message<?>> register(String name, Flow.Subscriber<? extends Message<?>> subscriber, boolean merge) {
        Objects.requireNonNull(name, ProviderMessages.msg.nameMustBeSet());
        Objects.requireNonNull(subscriber, ProviderMessages.msg.subscriberMustBeSet());
        this.register(this.subscribers, name, subscriber);
        this.incoming.put(name, merge);
        return subscriber;
    }

    public void register(String name, Emitter<?> emitter) {
        Objects.requireNonNull(name, ProviderMessages.msg.nameMustBeSet());
        Objects.requireNonNull(emitter, ProviderMessages.msg.emitterMustBeSet());
        this.register(name, Emitter.class, emitter);
    }

    public void register(String name, MutinyEmitter<?> emitter) {
        Objects.requireNonNull(name, ProviderMessages.msg.nameMustBeSet());
        Objects.requireNonNull(emitter, ProviderMessages.msg.emitterMustBeSet());
        this.register(name, MutinyEmitter.class, emitter);
    }

    public <T> void register(String name, Class<T> emitterType, T emitter) {
        Objects.requireNonNull(name, ProviderMessages.msg.nameMustBeSet());
        Objects.requireNonNull(emitter, ProviderMessages.msg.emitterMustBeSet());
        Map map = this.emitters.computeIfAbsent(emitterType, key -> new ConcurrentHashMap());
        map.put(name, emitter);
    }

    public List<Flow.Publisher<? extends Message<?>>> getPublishers(String name) {
        Objects.requireNonNull(name, ProviderMessages.msg.nameMustBeSet());
        return this.publishers.getOrDefault(name, Collections.emptyList());
    }

    public Emitter<?> getEmitter(String name) {
        Objects.requireNonNull(name, ProviderMessages.msg.nameMustBeSet());
        return this.getEmitter(name, Emitter.class);
    }

    public MutinyEmitter<?> getMutinyEmitter(String name) {
        Objects.requireNonNull(name, ProviderMessages.msg.nameMustBeSet());
        return this.getEmitter(name, MutinyEmitter.class);
    }

    public <T> T getEmitter(String name, Class<? super T> emitterType) {
        Objects.requireNonNull(name, ProviderMessages.msg.nameMustBeSet());
        Map<String, Object> typedEmitters = this.emitters.get(emitterType);
        if (typedEmitters == null) {
            return null;
        }
        return (T)typedEmitters.get(name);
    }

    public List<Flow.Subscriber<? extends Message<?>>> getSubscribers(String name) {
        Objects.requireNonNull(name, ProviderMessages.msg.nameMustBeSet());
        return this.subscribers.getOrDefault(name, Collections.emptyList());
    }

    private <T> void register(Map<String, List<T>> multimap, String name, T item) {
        List list = multimap.computeIfAbsent(name, key -> new CopyOnWriteArrayList());
        list.add(item);
    }

    public Set<String> getIncomingNames() {
        return this.publishers.keySet();
    }

    public Set<String> getOutgoingNames() {
        return this.subscribers.keySet();
    }

    public Set<String> getEmitterNames() {
        return this.emitters.values().stream().flatMap(m -> m.keySet().stream()).collect(Collectors.toSet());
    }

    public Map<String, Boolean> getIncomingChannels() {
        return this.outgoing;
    }

    public Map<String, Boolean> getOutgoingChannels() {
        return this.incoming;
    }
}

