/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.massindexing.impl;

import java.util.concurrent.CompletionStage;
import org.hibernate.CacheMode;
import org.hibernate.search.mapper.orm.massindexing.MassIndexer;
import org.hibernate.search.mapper.orm.massindexing.MassIndexerFilteringTypeStep;
import org.hibernate.search.mapper.orm.massindexing.impl.ConditionalExpression;
import org.hibernate.search.mapper.orm.massindexing.impl.HibernateOrmMassIndexerFilteringTypeStep;
import org.hibernate.search.mapper.orm.massindexing.impl.HibernateOrmMassIndexingContext;
import org.hibernate.search.mapper.pojo.massindexing.MassIndexingEnvironment;
import org.hibernate.search.mapper.pojo.massindexing.MassIndexingFailureHandler;
import org.hibernate.search.mapper.pojo.massindexing.MassIndexingMonitor;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexer;

public class HibernateOrmMassIndexer
implements MassIndexer {
    private final PojoMassIndexer delegate;
    private final HibernateOrmMassIndexingContext context;

    public HibernateOrmMassIndexer(PojoMassIndexer delegate, HibernateOrmMassIndexingContext context) {
        this.delegate = delegate;
        this.context = context;
    }

    @Override
    public MassIndexer transactionTimeout(int timeoutInSeconds) {
        this.context.idLoadingTransactionTimeout(timeoutInSeconds);
        return this;
    }

    @Override
    public MassIndexer cacheMode(CacheMode cacheMode) {
        this.context.cacheMode(cacheMode);
        return this;
    }

    @Override
    public MassIndexerFilteringTypeStep type(Class<?> type) {
        return new HibernateOrmMassIndexerFilteringTypeStep(this, type);
    }

    @Override
    public MassIndexer typesToIndexInParallel(int threadsToIndexObjects) {
        this.delegate.typesToIndexInParallel(threadsToIndexObjects);
        return this;
    }

    @Override
    public MassIndexer threadsToLoadObjects(int numberOfThreads) {
        this.delegate.threadsToLoadObjects(numberOfThreads);
        return this;
    }

    @Override
    public HibernateOrmMassIndexer batchSizeToLoadObjects(int batchSize) {
        this.context.objectLoadingBatchSize(batchSize);
        return this;
    }

    @Override
    public MassIndexer mergeSegmentsOnFinish(boolean enable) {
        this.delegate.mergeSegmentsOnFinish(enable);
        return this;
    }

    @Override
    public MassIndexer mergeSegmentsAfterPurge(boolean enable) {
        this.delegate.mergeSegmentsAfterPurge(enable);
        return this;
    }

    @Override
    public MassIndexer dropAndCreateSchemaOnStart(boolean dropAndCreateSchema) {
        this.delegate.dropAndCreateSchemaOnStart(dropAndCreateSchema);
        return this;
    }

    @Override
    public MassIndexer purgeAllOnStart(boolean purgeAll) {
        this.delegate.purgeAllOnStart(purgeAll);
        return this;
    }

    @Override
    public HibernateOrmMassIndexer limitIndexedObjectsTo(long maximum) {
        this.context.objectsLimit(maximum);
        return this;
    }

    @Override
    public CompletionStage<?> start() {
        return this.delegate.start();
    }

    @Override
    public void startAndWait() throws InterruptedException {
        this.delegate.startAndWait();
    }

    @Override
    public HibernateOrmMassIndexer idFetchSize(int idFetchSize) {
        this.context.idFetchSize(idFetchSize);
        return this;
    }

    @Override
    public MassIndexer monitor(MassIndexingMonitor monitor) {
        this.delegate.monitor(monitor);
        return this;
    }

    @Override
    public MassIndexer failureHandler(MassIndexingFailureHandler failureHandler) {
        this.delegate.failureHandler(failureHandler);
        return this;
    }

    @Override
    public MassIndexer failureFloodingThreshold(long threshold) {
        this.delegate.failureFloodingThreshold(threshold);
        return this;
    }

    ConditionalExpression reindexOnly(Class<?> type, String conditionalExpression) {
        return this.context.reindexOnly(type, conditionalExpression);
    }

    @Override
    public MassIndexer environment(MassIndexingEnvironment environment) {
        this.delegate.environment(environment);
        return this;
    }
}

