/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.subsystem.resource.operation;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;

public interface ResourceOperationRuntimeHandler {
    public static ResourceOperationRuntimeHandler configureService(ResourceServiceConfigurator configurator) {
        return new ResourceServiceConfiguratorRuntimeHandler(configurator, Resource::getModel);
    }

    public static ResourceOperationRuntimeHandler configureParentService(ResourceServiceConfigurator configurator) {
        return new ResourceServiceConfiguratorRuntimeHandler(configurator, Resource.Tools::readModel);
    }

    public static ResourceOperationRuntimeHandler restartParent(ResourceOperationRuntimeHandler parentRuntimeHandler) {
        return ResourceOperationRuntimeHandler.restartAncestor(parentRuntimeHandler, PathAddress::getParent);
    }

    public static ResourceOperationRuntimeHandler restartAncestor(ResourceOperationRuntimeHandler ancestorRuntimeHandler, UnaryOperator<PathAddress> ancestorAddressResolver) {
        return new RestartAncestorResourceServiceConfiguratorRuntimeHandler(ancestorRuntimeHandler, ancestorAddressResolver);
    }

    default public void addRuntime(OperationContext context, Resource resource) throws OperationFailedException {
        this.addRuntime(context, this.readModel(resource));
    }

    public void addRuntime(OperationContext var1, ModelNode var2) throws OperationFailedException;

    default public void removeRuntime(OperationContext context, Resource resource) throws OperationFailedException {
        this.removeRuntime(context, this.readModel(resource));
    }

    public void removeRuntime(OperationContext var1, ModelNode var2) throws OperationFailedException;

    default public ModelNode readModel(Resource resource) {
        return resource.getModel();
    }

    public static class RestartAncestorResourceServiceConfiguratorRuntimeHandler
    implements ResourceOperationRuntimeHandler {
        private final ResourceOperationRuntimeHandler ancestorRuntimeHandler;
        private final UnaryOperator<PathAddress> ancestorAddressResolver;

        RestartAncestorResourceServiceConfiguratorRuntimeHandler(ResourceOperationRuntimeHandler ancestorRuntimeHandler, UnaryOperator<PathAddress> ancestorAddressResolver) {
            this.ancestorRuntimeHandler = ancestorRuntimeHandler;
            this.ancestorAddressResolver = ancestorAddressResolver;
        }

        @Override
        public void addRuntime(OperationContext context, ModelNode model) {
            this.restartRuntime(context, model);
        }

        @Override
        public void removeRuntime(OperationContext context, ModelNode model) {
            this.restartRuntime(context, model);
        }

        private void restartRuntime(OperationContext context, ModelNode model) {
            PathAddress childAddress = context.getCurrentAddress();
            PathAddress ancestorAddress = (PathAddress)this.ancestorAddressResolver.apply(childAddress);
            if (!context.isBooting()) {
                boolean runtime;
                boolean bl = runtime = !context.isRollbackOnly();
                if (context.isResourceServiceRestartAllowed()) {
                    if (runtime ? context.markResourceRestarted(ancestorAddress, (Object)this) : context.revertResourceRestarted(ancestorAddress, (Object)this)) {
                        final ResourceOperationRuntimeHandler ancestorRuntimeHandler = this.ancestorRuntimeHandler;
                        final Resource ancestorResource = context.readResourceFromRoot(ancestorAddress);
                        final Resource originalAncestorResource = context.getOriginalRootResource().navigate(ancestorAddress);
                        context.addStep(Util.getReadResourceOperation((PathAddress)ancestorAddress), new OperationStepHandler(){

                            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                                ancestorRuntimeHandler.removeRuntime(context, runtime ? originalAncestorResource : ancestorResource);
                                ancestorRuntimeHandler.addRuntime(context, runtime ? ancestorResource : originalAncestorResource);
                            }
                        }, OperationContext.Stage.RUNTIME, true);
                    }
                } else if (runtime) {
                    context.reloadRequired();
                } else {
                    context.revertReloadRequired();
                }
            }
        }
    }

    public static class ResourceServiceConfiguratorRuntimeHandler
    implements ResourceOperationRuntimeHandler {
        private final ResourceServiceConfigurator configurator;
        private final Function<Resource, ModelNode> modelReader;
        private final Map<PathAddress, Consumer<OperationContext>> removers = new ConcurrentHashMap<PathAddress, Consumer<OperationContext>>();

        ResourceServiceConfiguratorRuntimeHandler(ResourceServiceConfigurator configurator, Function<Resource, ModelNode> modelReader) {
            this.configurator = configurator;
            this.modelReader = modelReader;
        }

        @Override
        public void addRuntime(OperationContext context, ModelNode model) throws OperationFailedException {
            ResourceServiceInstaller installer = this.configurator.configure(context, model);
            this.removers.put(context.getCurrentAddress(), installer.install(context));
        }

        @Override
        public void removeRuntime(OperationContext context, ModelNode model) throws OperationFailedException {
            Consumer<OperationContext> remover = this.removers.remove(context.getCurrentAddress());
            if (remover != null) {
                remover.accept(context);
            }
        }

        @Override
        public ModelNode readModel(Resource resource) {
            return this.modelReader.apply(resource);
        }
    }
}

