/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core.management;

import java.util.Map;
import org.apache.activemq.artemis.api.core.management.ActiveMQComponentControl;
import org.apache.activemq.artemis.api.core.management.Attribute;

public interface ClusterConnectionControl
extends ActiveMQComponentControl {
    @Attribute(desc="name of this cluster connection")
    public String getName();

    @Attribute(desc="address used by this cluster connection")
    public String getAddress();

    @Attribute(desc="node ID used by this cluster connection")
    public String getNodeID();

    @Attribute(desc="whether this cluster connection use duplicate detection")
    public boolean isDuplicateDetection();

    @Attribute(desc="type of message load balancing strategy this bridge will use")
    public String getMessageLoadBalancingType();

    @Attribute(desc="Topology that this Cluster Connection knows about")
    public String getTopology();

    @Attribute(desc="maximum number of hops used by this cluster connection")
    public int getMaxHops();

    @Attribute(desc="list of static connectors")
    public Object[] getStaticConnectors();

    @Attribute(desc="list of static connectors as JSON")
    public String getStaticConnectorsAsJSON() throws Exception;

    @Attribute(desc="name of the discovery group used by this cluster connection")
    public String getDiscoveryGroupName();

    @Attribute(desc="connection retry interval used by this cluster connection")
    public long getRetryInterval();

    @Attribute(desc="map of the nodes connected to this cluster connection (keys are node IDs, values are the addresses used to connect to the nodes)")
    public Map<String, String> getNodes() throws Exception;

    @Attribute(desc="The messagesPendingAcknowledgement counter is incremented when any bridge in the cluster connection has forwarded a message and is waiting acknowledgement from the other broker. (aggregate over all bridges)")
    public long getMessagesPendingAcknowledgement();

    @Attribute(desc="The messagesAcknowledged counter is the number of messages actually received by a remote broker for all bridges in this cluster connection")
    public long getMessagesAcknowledged();

    @Attribute(desc="The metrics for this cluster connection. The messagesPendingAcknowledgement counter is incremented when any bridge in the cluster connection has forwarded a message and is waiting acknowledgement from the other broker. The messagesAcknowledged counter is the number of messages actually received by a remote broker for all bridges in this cluster connection")
    public Map<String, Object> getMetrics();

    @Attribute(desc="The metrics for the bridge by nodeId. The messagesPendingAcknowledgement counter is incremented when the bridge is has forwarded a message but is waiting acknowledgement from the other broker. The messagesAcknowledged counter is the number of messages actually received by the remote broker for this bridge.")
    public Map<String, Object> getBridgeMetrics(String var1) throws Exception;
}

