/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.IOException;
import java.io.InputStream;
import org.jboss.modules.ModuleFinder;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.PathUtils;
import org.jboss.modules.Resource;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.xml.ModuleXmlParser;

public final class ResourceLoaderModuleFinder
implements ModuleFinder {
    private final ResourceLoader resourceLoader;
    private final String modulesDirectory;
    private final NestedResourceRootFactory factory;

    public ResourceLoaderModuleFinder(ResourceLoader resourceLoader, String modulesDirectory) {
        this.factory = new NestedResourceRootFactory(resourceLoader);
        this.resourceLoader = resourceLoader;
        this.modulesDirectory = modulesDirectory;
    }

    public ResourceLoaderModuleFinder(ResourceLoader resourceLoader) {
        this(resourceLoader, "modules");
    }

    @Override
    public ModuleSpec findModule(String name, ModuleLoader delegateLoader) throws ModuleLoadException {
        ModuleSpec moduleSpec;
        ResourceLoader resourceLoader = this.resourceLoader;
        String path = PathUtils.basicModuleNameToPath(name);
        if (path == null) {
            return null;
        }
        String basePath = this.modulesDirectory + "/" + path;
        Resource moduleXmlResource = resourceLoader.getResource(basePath + "/module.xml");
        if (moduleXmlResource == null) {
            return null;
        }
        try (InputStream inputStream = moduleXmlResource.openStream();){
            moduleSpec = ModuleXmlParser.parseModuleXml((ModuleXmlParser.ResourceRootFactory)this.factory, basePath, inputStream, moduleXmlResource.getName(), delegateLoader, name);
        }
        catch (IOException e) {
            throw new ModuleLoadException("Failed to read module.xml file", e);
        }
        return moduleSpec;
    }

    static class NestedResourceRootFactory
    implements ModuleXmlParser.ResourceRootFactory {
        private final ResourceLoader resourceLoader;

        NestedResourceRootFactory(ResourceLoader resourceLoader) {
            this.resourceLoader = resourceLoader;
        }

        @Override
        public ResourceLoader createResourceLoader(String rootPath, String loaderPath, String loaderName) throws IOException {
            ResourceLoader subloader = this.resourceLoader.createSubloader(rootPath + "/" + loaderPath, loaderName);
            if (subloader == null) {
                throw new IllegalArgumentException("Nested resource loaders not supported by " + this.resourceLoader);
            }
            return subloader;
        }
    }
}

