/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.massindexing.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.search.engine.common.EntityReference;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoMassIndexingIndexedTypeContext;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoMassIndexingTypeContextProvider;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexingContext;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexingLoadingStrategy;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexingMappingContext;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexingSessionContext;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;

public class PojoMassIndexingIndexedTypeGroup<E> {
    private final PojoMassIndexingLoadingStrategy<E, ?> loadingStrategy;
    private final PojoMassIndexingIndexedTypeContext<? extends E> commonSuperType;
    private final PojoMassIndexingContext indexingContext;
    private final PojoMassIndexingMappingContext mappingContext;
    private final PojoMassIndexingTypeContextProvider typeContextProvider;
    private final Set<PojoMassIndexingIndexedTypeContext<? extends E>> includedTypes;

    public static List<PojoMassIndexingIndexedTypeGroup<?>> disjoint(PojoMassIndexingContext indexingContext, PojoMassIndexingMappingContext mappingContext, PojoMassIndexingTypeContextProvider typeContextProvider, Set<? extends PojoMassIndexingIndexedTypeContext<?>> indexedTypeContexts) {
        ArrayList typeGroups = new ArrayList();
        for (PojoMassIndexingIndexedTypeContext<?> typeContext : indexedTypeContexts) {
            PojoMassIndexingIndexedTypeGroup<?> typeGroup = PojoMassIndexingIndexedTypeGroup.single(indexingContext, mappingContext, typeContextProvider, typeContext);
            ListIterator iterator = typeGroups.listIterator();
            while (iterator.hasNext()) {
                PojoMassIndexingIndexedTypeGroup<?> mergeResult = ((PojoMassIndexingIndexedTypeGroup)iterator.next()).mergeOrNull(typeGroup);
                if (mergeResult == null) continue;
                typeGroup = mergeResult;
                iterator.remove();
            }
            typeGroups.add(typeGroup);
        }
        return typeGroups;
    }

    private static <E> PojoMassIndexingIndexedTypeGroup<? super E> single(PojoMassIndexingContext indexingContext, PojoMassIndexingMappingContext mappingContext, PojoMassIndexingTypeContextProvider typeContextProvider, PojoMassIndexingIndexedTypeContext<E> typeContext) {
        PojoMassIndexingLoadingStrategy<E, ?> strategy = indexingContext.loadingStrategy(typeContext.typeIdentifier());
        return new PojoMassIndexingIndexedTypeGroup<E>(strategy, typeContext, indexingContext, mappingContext, typeContextProvider, Collections.singleton(typeContext));
    }

    private PojoMassIndexingIndexedTypeGroup(PojoMassIndexingLoadingStrategy<E, ?> loadingStrategy, PojoMassIndexingIndexedTypeContext<? extends E> commonSuperType, PojoMassIndexingContext indexingContext, PojoMassIndexingMappingContext mappingContext, PojoMassIndexingTypeContextProvider typeContextProvider, Set<PojoMassIndexingIndexedTypeContext<? extends E>> includedTypes) {
        this.commonSuperType = commonSuperType;
        this.indexingContext = indexingContext;
        this.mappingContext = mappingContext;
        this.typeContextProvider = typeContextProvider;
        this.loadingStrategy = loadingStrategy;
        this.includedTypes = includedTypes;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[commonSuperType=" + this.commonSuperType + ", loadingStrategy=" + this.includedTypes + ", includedSubTypes=" + this.includedTypes + "]";
    }

    public String notifiedGroupName() {
        return this.includedTypes.stream().map(PojoMassIndexingIndexedTypeContext::entityName).collect(Collectors.joining(","));
    }

    public Set<PojoRawTypeIdentifier<? extends E>> includedTypesIdentifiers() {
        return this.includedTypes.stream().map(PojoMassIndexingIndexedTypeContext::typeIdentifier).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public EntityReference extractReference(PojoMassIndexingSessionContext sessionContext, Object entity) {
        PojoRawTypeIdentifier<Object> targetType = sessionContext.runtimeIntrospector().detectEntityType(entity);
        PojoMassIndexingIndexedTypeContext<Object> typeContext = this.typeContextProvider.indexedForExactType(targetType);
        String entityName = typeContext.entityName();
        Object identifier = this.extractIdentifier(typeContext, sessionContext, entity);
        return this.mappingContext.entityReferenceFactoryDelegate().create(targetType, entityName, identifier);
    }

    public EntityReference makeSuperTypeReference(Object identifier) {
        return this.mappingContext.entityReferenceFactoryDelegate().create(this.commonSuperType.typeIdentifier(), this.commonSuperType.entityName(), identifier);
    }

    public <E2> Object extractIdentifier(PojoMassIndexingIndexedTypeContext<E2> typeContext, PojoMassIndexingSessionContext sessionContext, Object entity) {
        return typeContext.identifierMapping().getIdentifier(null, typeContext.toEntitySupplier(sessionContext, entity));
    }

    public PojoMassIndexingLoadingStrategy<E, ?> loadingStrategy() {
        return this.loadingStrategy;
    }

    private PojoMassIndexingIndexedTypeGroup<?> mergeOrNull(PojoMassIndexingIndexedTypeGroup<?> other) {
        if (!this.loadingStrategy.equals(other.loadingStrategy)) {
            return null;
        }
        if (this.isFirstSuperTypeOfSecond(this.commonSuperType, other.commonSuperType)) {
            return this.withAdditionalTypes(other.includedTypes);
        }
        if (this.isFirstSuperTypeOfSecond(other.commonSuperType, this.commonSuperType)) {
            return other.withAdditionalTypes(this.includedTypes);
        }
        return null;
    }

    private boolean isFirstSuperTypeOfSecond(PojoMassIndexingIndexedTypeContext<?> first, PojoMassIndexingIndexedTypeContext<?> second) {
        return this.typeContextProvider.allIndexedForSuperType(first.typeIdentifier()).map(s -> s.contains(second)).orElse(false);
    }

    private PojoMassIndexingIndexedTypeGroup<E> withAdditionalTypes(Set<? extends PojoMassIndexingIndexedTypeContext<? extends E>> otherIncludedSubTypes) {
        LinkedHashSet<PojoMassIndexingIndexedTypeContext<? extends PojoMassIndexingIndexedTypeContext<? extends E>>> mergedIncludedSubTypes = new LinkedHashSet<PojoMassIndexingIndexedTypeContext<? extends PojoMassIndexingIndexedTypeContext<? extends E>>>(this.includedTypes);
        mergedIncludedSubTypes.addAll(otherIncludedSubTypes);
        return new PojoMassIndexingIndexedTypeGroup<E>(this.loadingStrategy, this.commonSuperType, this.indexingContext, this.mappingContext, this.typeContextProvider, mergedIncludedSubTypes);
    }
}

