/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.server.provider;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.Cache;
import org.infinispan.remoting.transport.Address;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.infinispan.service.InfinispanCacheRequirement;
import org.wildfly.clustering.server.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.server.infinispan.provider.AutoCloseableServiceProviderRegistry;
import org.wildfly.clustering.server.infinispan.provider.CacheServiceProviderRegistry;
import org.wildfly.clustering.server.infinispan.provider.CacheServiceProviderRegistryConfiguration;
import org.wildfly.clustering.server.infinispan.provider.LocalServiceProviderRegistry;
import org.wildfly.clustering.server.service.ClusteringCacheRequirement;
import org.wildfly.clustering.server.service.ClusteringRequirement;
import org.wildfly.clustering.service.AsyncServiceConfigurator;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.common.function.Functions;

public class CacheServiceProviderRegistryServiceConfigurator<T>
extends SimpleServiceNameProvider
implements CapabilityServiceConfigurator,
CacheServiceProviderRegistryConfiguration<T>,
Supplier<AutoCloseableServiceProviderRegistry<T>> {
    private final String containerName;
    private final String cacheName;
    private volatile SupplierDependency<CommandDispatcherFactory> dispatcherFactory;
    private volatile SupplierDependency<org.wildfly.clustering.server.group.Group<Address>> group;
    private volatile SupplierDependency<Cache<?, ?>> cache;

    public CacheServiceProviderRegistryServiceConfigurator(ServiceName name, String containerName, String cacheName) {
        super(name);
        this.containerName = containerName;
        this.cacheName = cacheName;
    }

    @Override
    public AutoCloseableServiceProviderRegistry<T> get() {
        Cache cache = (Cache)this.cache.get();
        return cache.getCacheConfiguration().clustering().cacheMode().isClustered() ? new CacheServiceProviderRegistry((CacheServiceProviderRegistryConfiguration)this) : new LocalServiceProviderRegistry((Group)this.group.get());
    }

    public ServiceConfigurator configure(CapabilityServiceSupport support) {
        this.cache = new ServiceSupplierDependency(InfinispanCacheRequirement.CACHE.getServiceName(support, this.containerName, this.cacheName));
        this.dispatcherFactory = new ServiceSupplierDependency(ClusteringRequirement.COMMAND_DISPATCHER_FACTORY.getServiceName(support, this.containerName));
        this.group = new ServiceSupplierDependency(ClusteringCacheRequirement.GROUP.getServiceName(support, this.containerName, this.cacheName));
        return this;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = new AsyncServiceConfigurator(this.getServiceName()).build(target);
        Consumer registry = new CompositeDependency(new Dependency[]{this.cache, this.dispatcherFactory, this.group}).register(builder).provides(new ServiceName[]{this.getServiceName()});
        FunctionalService service = new FunctionalService(registry, Functions.cast(Function.identity()), (Supplier)this, Functions.closingConsumer());
        return builder.setInstance((Service)service).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public Object getId() {
        return this.getServiceName();
    }

    public org.wildfly.clustering.server.group.Group<Address> getGroup() {
        return (org.wildfly.clustering.server.group.Group)this.group.get();
    }

    public <K, V> Cache<K, V> getCache() {
        return (Cache)this.cache.get();
    }

    public CommandDispatcherFactory getCommandDispatcherFactory() {
        return (CommandDispatcherFactory)this.dispatcherFactory.get();
    }
}

