/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.lra.client.internal.proxy.nonjaxrs.jandex;

import io.narayana.lra.client.internal.proxy.nonjaxrs.jandex.DotNames;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;

public class JandexAnnotationResolver {
    public static Map<DotName, List<AnnotationInstance>> getAllAnnotationsFromClassInfoHierarchy(DotName name, Index index) {
        HashMap<DotName, List<AnnotationInstance>> annotations = new HashMap<DotName, List<AnnotationInstance>>();
        if (name == null || name.equals((Object)DotNames.OBJECT)) {
            return annotations;
        }
        ClassInfo classInfo = index.getClassByName(name);
        if (classInfo != null) {
            annotations.putAll(classInfo.annotationsMap());
            annotations.putAll(JandexAnnotationResolver.getInterfaceAnnotations(classInfo.interfaceNames(), index));
            annotations.putAll(JandexAnnotationResolver.getAllAnnotationsFromClassInfoHierarchy(classInfo.superName(), index));
        }
        return annotations;
    }

    private static Map<DotName, List<AnnotationInstance>> getInterfaceAnnotations(List<DotName> interfaceNames, Index index) {
        HashMap<DotName, List<AnnotationInstance>> annotations = new HashMap<DotName, List<AnnotationInstance>>();
        ClassInfo interfaceClassInfo = null;
        for (DotName interfaceName : interfaceNames) {
            interfaceClassInfo = index.getClassByName(interfaceName);
            Map interfaceAnnotations = interfaceClassInfo.annotationsMap();
            annotations.forEach((k, v) -> interfaceAnnotations.merge(k, v, (v1, v2) -> {
                v1.addAll(v2);
                return v1;
            }));
        }
        return annotations;
    }
}

