/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.security;

import java.util.Set;
import java.util.function.Function;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentInterceptorFactory;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.security.IdentityOutflowInterceptor;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.authz.RoleMapper;

public class IdentityOutflowInterceptorFactory
extends ComponentInterceptorFactory {
    public static final InterceptorFactory INSTANCE = new IdentityOutflowInterceptorFactory();
    private final String category;
    private final RoleMapper roleMapper;

    public IdentityOutflowInterceptorFactory() {
        this(null, null);
    }

    public IdentityOutflowInterceptorFactory(String category, RoleMapper roleMapper) {
        this.category = category;
        this.roleMapper = roleMapper;
    }

    protected Interceptor create(Component component, InterceptorFactoryContext context) {
        if (!(component instanceof EJBComponent)) {
            throw EjbLogger.ROOT_LOGGER.unexpectedComponent(component, EJBComponent.class);
        }
        EJBComponent ejbComponent = (EJBComponent)component;
        Function<SecurityIdentity, Set<SecurityIdentity>> identityOutflowFunction = ejbComponent.getIdentityOutflowFunction();
        return new IdentityOutflowInterceptor(identityOutflowFunction, this.category, this.roleMapper);
    }
}

