/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.service;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.common.function.Functions;

public interface Installer<ST extends ServiceTarget> {
    public ServiceController<?> install(ST var1);

    public static <T> Consumer<T> combine(Consumer<T> dependency1, Consumer<T> dependency2) {
        return Installer.combine(List.of(dependency1, dependency2));
    }

    public static <T> Consumer<T> combine(Consumer<T> ... dependencies) {
        return Installer.combine(List.of(dependencies));
    }

    public static <T> Consumer<T> combine(final Iterable<? extends Consumer<T>> dependencies) {
        return new Consumer<T>(){

            @Override
            public void accept(T value) {
                for (Consumer dependency : dependencies) {
                    dependency.accept(value);
                }
            }
        };
    }

    public static class DefaultService<T, V>
    implements Service {
        private final Consumer<V> consumer;
        private final Function<T, V> mapper;
        private final Supplier<T> factory;
        private final Consumer<T> stopTask;
        private volatile T value;

        DefaultService(Consumer<V> consumer, Function<T, V> mapper, Supplier<T> factory, Consumer<T> stopTask) {
            this.consumer = consumer;
            this.mapper = mapper;
            this.factory = factory;
            this.stopTask = stopTask;
        }

        public void start(StartContext context) throws StartException {
            try {
                this.value = this.factory.get();
                this.consumer.accept(this.mapper.apply(this.value));
            }
            catch (Error | RuntimeException e) {
                throw new StartException(e);
            }
        }

        public void stop(StopContext context) {
            try {
                this.stopTask.accept(this.value);
            }
            finally {
                this.value = null;
                this.consumer.accept(null);
            }
        }
    }

    public static abstract class AbstractInstaller<ST extends ServiceTarget, SB extends DSB, DSB extends ServiceBuilder<?>, T, V>
    implements Installer<ST> {
        private final Function<ST, SB> serviceBuilderFactory;
        private final Function<SB, Consumer<V>> provider;
        private final Function<T, V> mapper;
        private final Supplier<T> factory;
        private final ServiceController.Mode mode;
        private final Consumer<DSB> dependency;
        private final Consumer<V> startTask;
        private final Consumer<T> stopTask;
        private final UnaryOperator<SB> decorator;

        protected AbstractInstaller(Configuration<SB, DSB, T, V> config, Function<ST, SB> serviceBuilderFactory) {
            this.serviceBuilderFactory = serviceBuilderFactory;
            this.provider = config.getProvider();
            this.mapper = config.getMapper();
            this.factory = config.getFactory();
            this.mode = config.getInitialMode();
            this.dependency = config.getDependency();
            this.startTask = config.getStartTask();
            this.stopTask = config.getStopTask();
            this.decorator = config.getServiceBuilderDecorator();
        }

        @Override
        public ServiceController<?> install(ST target) {
            ServiceBuilder builder = (ServiceBuilder)this.decorator.apply((ServiceBuilder)this.serviceBuilderFactory.apply(target));
            Consumer<V> injector = this.provider.apply(builder);
            this.dependency.accept(builder);
            DefaultService<T, V> service = new DefaultService<T, V>(Installer.combine(injector, this.startTask), this.mapper, this.factory, this.stopTask);
            return builder.setInstance(service).setInitialMode(this.mode).install();
        }

        protected static abstract class Builder<B, I extends Installer<ST>, ST extends ServiceTarget, SB extends DSB, DSB extends ServiceBuilder<?>, T, V>
        implements org.wildfly.service.Installer$Builder<B, I, ST, DSB, T, V>,
        Configuration<SB, DSB, T, V> {
            private final List<ServiceName> names = new LinkedList<ServiceName>();
            private final Function<T, V> mapper;
            private final Supplier<T> factory;
            private volatile ServiceController.Mode mode = ServiceController.Mode.ON_DEMAND;
            private volatile Consumer<DSB> dependency = Functions.discardingConsumer();
            private volatile Consumer<V> startTask = Functions.discardingConsumer();
            private volatile Consumer<T> stopTask = Functions.discardingConsumer();

            protected Builder(Function<T, V> mapper, Supplier<T> factory) {
                this.mapper = mapper;
                this.factory = factory;
            }

            protected abstract B builder();

            @Override
            public B asPassive() {
                this.mode = ServiceController.Mode.PASSIVE;
                return this.builder();
            }

            @Override
            public B asActive() {
                this.mode = ServiceController.Mode.ACTIVE;
                return this.builder();
            }

            @Override
            public B withDependency(Consumer<DSB> dependency) {
                this.dependency = dependency;
                return this.builder();
            }

            @Override
            public B provides(ServiceName name) {
                this.names.add(name);
                return this.builder();
            }

            @Override
            public B onStart(Consumer<V> consumer) {
                this.startTask = consumer;
                return this.builder();
            }

            @Override
            public B onStop(Consumer<T> consumer) {
                this.stopTask = consumer;
                return this.builder();
            }

            @Override
            public Function<T, V> getMapper() {
                return this.mapper;
            }

            @Override
            public Supplier<T> getFactory() {
                return this.factory;
            }

            @Override
            public ServiceController.Mode getInitialMode() {
                return this.mode;
            }

            protected List<ServiceName> getServiceNames() {
                return List.copyOf(this.names);
            }

            @Override
            public Function<SB, Consumer<V>> getProvider() {
                final List<ServiceName> names = this.getServiceNames();
                return new Function<SB, Consumer<V>>(){

                    @Override
                    public Consumer<V> apply(SB builder) {
                        return !names.isEmpty() ? builder.provides((ServiceName[])names.toArray(ServiceName[]::new)) : Functions.discardingConsumer();
                    }
                };
            }

            @Override
            public Consumer<DSB> getDependency() {
                return this.dependency;
            }

            @Override
            public Consumer<V> getStartTask() {
                return this.startTask;
            }

            @Override
            public Consumer<T> getStopTask() {
                return this.stopTask;
            }
        }
    }

    public static interface Configuration<SB extends DSB, DSB extends ServiceBuilder<?>, T, V> {
        public Function<T, V> getMapper();

        public Supplier<T> getFactory();

        public ServiceController.Mode getInitialMode();

        public Function<SB, Consumer<V>> getProvider();

        public Consumer<DSB> getDependency();

        public Consumer<V> getStartTask();

        public Consumer<T> getStopTask();

        public UnaryOperator<SB> getServiceBuilderDecorator();
    }

    public static interface Builder<B, I extends Installer<ST>, ST extends ServiceTarget, SB extends ServiceBuilder<?>, T, V> {
        public B asPassive();

        public B asActive();

        public B withDependency(Consumer<SB> var1);

        default public B withDependencies(Consumer<SB> dependency1, Consumer<SB> dependency2) {
            return this.withDependency(Installer.combine(dependency1, dependency2));
        }

        default public B withDependencies(Consumer<SB> ... dependencies) {
            return this.withDependency(Installer.combine(dependencies));
        }

        default public B withDependencies(Iterable<? extends Consumer<SB>> dependencies) {
            return this.withDependency(Installer.combine(dependencies));
        }

        public B provides(ServiceName var1);

        public B onStart(Consumer<V> var1);

        public B onStop(Consumer<T> var1);

        public I build();
    }
}

