/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.subsystem.resource;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.dmr.ModelNode;
import org.wildfly.common.iteration.CompositeIterable;
import org.wildfly.subsystem.resource.AttributeTranslation;
import org.wildfly.subsystem.resource.capability.ResourceCapabilityReferenceRecorder;
import org.wildfly.subsystem.resource.operation.AddResourceOperationStepHandlerDescriptor;
import org.wildfly.subsystem.resource.operation.OperationStepHandlerDescriptor;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.resource.operation.WriteAttributeOperationStepHandler;

public interface ResourceDescriptor
extends AddResourceOperationStepHandlerDescriptor {
    public static Builder builder(ResourceDescriptionResolver resolver) {
        return new DefaultBuilder(resolver);
    }

    public static <T, P extends Supplier<T>> Stream<T> stream(Collection<P> providers) {
        return providers.stream().map(Supplier::get);
    }

    public ResourceDescriptionResolver getResourceDescriptionResolver();

    default public Set<ResourceCapabilityReferenceRecorder<?>> getResourceCapabilityReferences() {
        return Collections.emptySet();
    }

    default public UnaryOperator<OperationStepHandler> getResourceOperationTransformation() {
        return UnaryOperator.identity();
    }

    default public Iterable<AttributeDefinition> getAttributes() {
        return List.of();
    }

    default public OperationStepHandler getWriteAttributeOperationStepHandler(AttributeDefinition attribute) {
        return null;
    }

    default public Set<RuntimeCapability<?>> getCapabilities() {
        return Set.of();
    }

    default public UnaryOperator<OperationStepHandler> getAddOperationTransformation() {
        return UnaryOperator.identity();
    }

    default public OperationEntry.Flag getAddOperationRestartFlag() {
        return OperationEntry.Flag.RESTART_NONE;
    }

    default public OperationEntry.Flag getRemoveOperationRestartFlag() {
        return OperationEntry.Flag.RESTART_NONE;
    }

    public static class DefaultBuilder
    extends AbstractConfigurator<Builder>
    implements Builder {
        DefaultBuilder(ResourceDescriptionResolver descriptionResolver) {
            super(descriptionResolver);
        }

        @Override
        public ResourceDescriptor build() {
            return new DefaultResourceDescriptor(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }

    public static abstract class AbstractConfigurator<C extends Configurator<C>>
    implements Configurator<C> {
        static final Predicate<ModelNode> DEFAULT_CAPABILITY_PREDICATE = ModelNode::isDefined;
        private static final Set<OperationEntry.Flag> RESTART_FLAGS = EnumSet.of(OperationEntry.Flag.RESTART_ALL_SERVICES, OperationEntry.Flag.RESTART_JVM, OperationEntry.Flag.RESTART_NONE, OperationEntry.Flag.RESTART_RESOURCE_SERVICES);
        private final ResourceDescriptionResolver descriptionResolver;
        private Optional<ResourceOperationRuntimeHandler> runtimeHandler = Optional.empty();
        private OperationEntry.Flag addOperationRestartFlag = OperationEntry.Flag.RESTART_NONE;
        private OperationEntry.Flag removeOperationRestartFlag = OperationEntry.Flag.RESTART_NONE;
        private Map<RuntimeCapability<?>, Predicate<ModelNode>> capabilities = Map.of();
        private Collection<AttributeDefinition> attributes = List.of();
        private Collection<AttributeDefinition> modelOnlyAttributes = List.of();
        private Collection<AttributeDefinition> readOnlyAttributes = List.of();
        private Map<AttributeDefinition, OperationStepHandler> customAttributes = Map.of();
        private Set<PathElement> requiredChildren = Set.of();
        private Set<PathElement> requiredSingletonChildren = Set.of();
        private Map<AttributeDefinition, AttributeTranslation> attributeTranslations = Map.of();
        private Set<ResourceCapabilityReferenceRecorder<?>> resourceCapabilityReferences = Set.of();
        private UnaryOperator<OperationStepHandler> addOperationTransformer = UnaryOperator.identity();
        private UnaryOperator<OperationStepHandler> operationTransformer = UnaryOperator.identity();
        private UnaryOperator<Resource> resourceTransformer = UnaryOperator.identity();
        private Optional<Consumer<DeploymentProcessorTarget>> deploymentChainContributor = Optional.empty();

        AbstractConfigurator(ResourceDescriptionResolver descriptionResolver) {
            this.descriptionResolver = descriptionResolver;
        }

        protected abstract C self();

        @Override
        public C withRuntimeHandler(ResourceOperationRuntimeHandler runtimeHandler) {
            this.runtimeHandler = Optional.of(runtimeHandler);
            if (this.removeOperationRestartFlag == OperationEntry.Flag.RESTART_NONE) {
                this.removeOperationRestartFlag = OperationEntry.Flag.RESTART_RESOURCE_SERVICES;
            }
            return this.self();
        }

        @Override
        public C withAddOperationRestartFlag(OperationEntry.Flag restartFlag) {
            if (!RESTART_FLAGS.contains(restartFlag)) {
                throw new IllegalArgumentException(restartFlag.name());
            }
            this.addOperationRestartFlag = restartFlag;
            return this.self();
        }

        @Override
        public C withRemoveOperationRestartFlag(OperationEntry.Flag restartFlag) {
            if (!RESTART_FLAGS.contains(restartFlag)) {
                throw new IllegalArgumentException(restartFlag.name());
            }
            this.removeOperationRestartFlag = restartFlag;
            return this.self();
        }

        @Override
        public C addAttributes(Collection<AttributeDefinition> attributes) {
            this.attributes = this.attributes.isEmpty() ? AbstractConfigurator.copyOf(attributes) : AbstractConfigurator.concat(this.attributes, attributes.stream());
            return this.self();
        }

        @Override
        public C addAttribute(AttributeDefinition attribute, OperationStepHandler writeAttributeHandler) {
            this.customAttributes = AbstractConfigurator.concat(this.customAttributes, attribute, writeAttributeHandler);
            return this.self();
        }

        @Override
        public C addModelOnlyAttributes(Collection<AttributeDefinition> attributes) {
            this.modelOnlyAttributes = this.modelOnlyAttributes.isEmpty() ? AbstractConfigurator.copyOf(attributes) : AbstractConfigurator.concat(this.modelOnlyAttributes, attributes.stream());
            return this.self();
        }

        @Override
        public C addReadOnlyAttributes(Collection<AttributeDefinition> attributes) {
            this.readOnlyAttributes = this.readOnlyAttributes.isEmpty() ? AbstractConfigurator.copyOf(attributes) : AbstractConfigurator.concat(this.readOnlyAttributes, attributes.stream());
            return this.self();
        }

        @Override
        public C translateAttribute(AttributeDefinition attribute, AttributeTranslation translation) {
            assert (attribute.getFlags().contains(AttributeAccess.Flag.ALIAS));
            this.attributeTranslations = AbstractConfigurator.concat(this.attributeTranslations, attribute, translation);
            return this.self();
        }

        @Override
        public C addCapability(RuntimeCapability<?> capability, Predicate<ModelNode> filter) {
            this.capabilities = AbstractConfigurator.concat(this.capabilities, capability, filter);
            return this.self();
        }

        @Override
        public C addCapabilities(Collection<RuntimeCapability<?>> capabilities, Predicate<ModelNode> filter) {
            this.capabilities = AbstractConfigurator.concat(this.capabilities, capabilities.stream(), filter);
            return this.self();
        }

        @Override
        public C requireChildren(Set<PathElement> paths) {
            this.requiredChildren = this.requiredChildren.isEmpty() ? Set.copyOf(paths) : AbstractConfigurator.concat(this.requiredChildren, paths.stream());
            return this.self();
        }

        @Override
        public C requireSingletonChildren(Set<PathElement> paths) {
            this.requiredSingletonChildren = this.requiredSingletonChildren.isEmpty() ? Set.copyOf(paths) : AbstractConfigurator.concat(this.requiredSingletonChildren, paths.stream());
            return this.self();
        }

        @Override
        public C addResourceCapabilityReferences(Collection<ResourceCapabilityReferenceRecorder<?>> references) {
            this.resourceCapabilityReferences = references.isEmpty() ? Set.copyOf(references) : AbstractConfigurator.concat(this.resourceCapabilityReferences, references.stream());
            return this.self();
        }

        @Override
        public C withAddResourceOperationTransformation(UnaryOperator<OperationStepHandler> transformation) {
            this.addOperationTransformer = transformation;
            return this.self();
        }

        @Override
        public C withOperationTransformation(UnaryOperator<OperationStepHandler> transformation) {
            this.operationTransformer = transformation;
            return this.self();
        }

        @Override
        public C withResourceTransformation(UnaryOperator<Resource> transformation) {
            this.resourceTransformer = transformation;
            return this.self();
        }

        @Override
        public C withDeploymentChainContributor(Consumer<DeploymentProcessorTarget> contributor) {
            this.deploymentChainContributor = Optional.of(contributor);
            if (this.addOperationRestartFlag == OperationEntry.Flag.RESTART_NONE) {
                this.addOperationRestartFlag = OperationEntry.Flag.RESTART_ALL_SERVICES;
            }
            return this.self();
        }

        @Override
        public <P extends Supplier<AttributeDefinition>> C provideAttributes(Collection<P> providers) {
            this.attributes = AbstractConfigurator.concat(this.attributes, ResourceDescriptor.stream(providers));
            return this.self();
        }

        @Override
        public <P extends Supplier<AttributeDefinition>> C provideModelOnlyAttributes(Collection<P> providers) {
            this.modelOnlyAttributes = AbstractConfigurator.concat(this.modelOnlyAttributes, ResourceDescriptor.stream(providers));
            return this.self();
        }

        @Override
        public <P extends Supplier<AttributeDefinition>> C provideReadOnlyAttributes(Collection<P> providers) {
            this.readOnlyAttributes = AbstractConfigurator.concat(this.readOnlyAttributes, ResourceDescriptor.stream(providers));
            return this.self();
        }

        @Override
        public <P extends Supplier<RuntimeCapability<?>>> C provideCapabilities(Collection<P> providers, Predicate<ModelNode> filter) {
            this.capabilities = AbstractConfigurator.concat(this.capabilities, ResourceDescriptor.stream(providers), filter);
            return this.self();
        }

        @Override
        public <P extends Supplier<PathElement>> C provideRequiredChildren(Collection<P> providers) {
            this.requiredChildren = AbstractConfigurator.concat(this.requiredChildren, ResourceDescriptor.stream(providers));
            return this.self();
        }

        @Override
        public <P extends Supplier<PathElement>> C provideRequiredSingletonChildren(Collection<P> providers) {
            this.requiredSingletonChildren = AbstractConfigurator.concat(this.requiredSingletonChildren, ResourceDescriptor.stream(providers));
            return this.self();
        }

        private static <T> Collection<T> copyOf(Collection<T> collection) {
            return collection instanceof Set ? Set.copyOf((Set)collection) : List.copyOf(collection);
        }

        private static <T> Collection<T> concat(Collection<T> collection, Stream<? extends T> additions) {
            return (collection.isEmpty() ? additions : Stream.concat(collection.stream(), additions)).collect(Collectors.toUnmodifiableList());
        }

        private static <T> Set<T> concat(Set<T> set, Stream<? extends T> additions) {
            return (set.isEmpty() ? additions : Stream.concat(set.stream(), additions)).collect(Collectors.toUnmodifiableSet());
        }

        private static <K, V> Map<K, V> concat(Map<K, V> map, K key, V value) {
            return map.isEmpty() ? Map.of(key, value) : AbstractConfigurator.concat(map, Stream.of(Map.entry(key, value)));
        }

        private static <K, V> Map<K, V> concat(Map<K, V> map, Stream<K> keys, V value) {
            return AbstractConfigurator.concat(map, keys.map(key -> Map.entry(key, value)));
        }

        private static <K, V> Map<K, V> concat(Map<K, V> map, Stream<Map.Entry<K, V>> entries) {
            return (map.isEmpty() ? entries : Stream.concat(map.entrySet().stream(), entries)).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
        }
    }

    public static interface Builder
    extends Configurator<Builder> {
        public ResourceDescriptor build();
    }

    public static interface Configurator<C extends Configurator<C>> {
        public C withRuntimeHandler(ResourceOperationRuntimeHandler var1);

        public C withAddOperationRestartFlag(OperationEntry.Flag var1);

        public C withRemoveOperationRestartFlag(OperationEntry.Flag var1);

        public C addAttributes(Collection<AttributeDefinition> var1);

        public C addAttribute(AttributeDefinition var1, OperationStepHandler var2);

        public C addModelOnlyAttributes(Collection<AttributeDefinition> var1);

        public C addReadOnlyAttributes(Collection<AttributeDefinition> var1);

        default public C renameAttribute(AttributeDefinition attribute, AttributeDefinition targetAttribute) {
            return this.translateAttribute(attribute, AttributeTranslation.alias(targetAttribute));
        }

        public C translateAttribute(AttributeDefinition var1, AttributeTranslation var2);

        default public C addCapability(RuntimeCapability<?> capability) {
            return this.addCapability(capability, ModelNode::isDefined);
        }

        public C addCapability(RuntimeCapability<?> var1, Predicate<ModelNode> var2);

        default public C addCapabilities(RuntimeCapability<?> ... capabilities) {
            return this.addCapabilities(Set.of(capabilities));
        }

        default public C addCapabilities(Collection<RuntimeCapability<?>> capabilities) {
            return this.addCapabilities(capabilities, ModelNode::isDefined);
        }

        public C addCapabilities(Collection<RuntimeCapability<?>> var1, Predicate<ModelNode> var2);

        default public C requireChild(PathElement path) {
            return this.requireChildren(Set.of(path));
        }

        public C requireChildren(Set<PathElement> var1);

        default public C requireSingletonChild(PathElement path) {
            return this.requireSingletonChildren(Set.of(path));
        }

        public C requireSingletonChildren(Set<PathElement> var1);

        default public C addResourceCapabilityReference(ResourceCapabilityReferenceRecorder<?> reference) {
            return this.addResourceCapabilityReferences(Set.of(reference));
        }

        default public C addResourceCapabilityReferences(ResourceCapabilityReferenceRecorder<?> ... references) {
            return this.addResourceCapabilityReferences(Set.of(references));
        }

        public C addResourceCapabilityReferences(Collection<ResourceCapabilityReferenceRecorder<?>> var1);

        public C withAddResourceOperationTransformation(UnaryOperator<OperationStepHandler> var1);

        public C withOperationTransformation(UnaryOperator<OperationStepHandler> var1);

        public C withResourceTransformation(UnaryOperator<Resource> var1);

        public C withDeploymentChainContributor(Consumer<DeploymentProcessorTarget> var1);

        public <P extends Supplier<AttributeDefinition>> C provideAttributes(Collection<P> var1);

        public <P extends Supplier<AttributeDefinition>> C provideModelOnlyAttributes(Collection<P> var1);

        public <P extends Supplier<AttributeDefinition>> C provideReadOnlyAttributes(Collection<P> var1);

        default public <P extends Supplier<RuntimeCapability<?>>> C provideCapabilities(Collection<P> providers) {
            return this.provideCapabilities(providers, ModelNode::isDefined);
        }

        public <P extends Supplier<RuntimeCapability<?>>> C provideCapabilities(Collection<P> var1, Predicate<ModelNode> var2);

        public <P extends Supplier<PathElement>> C provideRequiredChildren(Collection<P> var1);

        public <P extends Supplier<PathElement>> C provideRequiredSingletonChildren(Collection<P> var1);
    }

    public static class DefaultResourceDescriptor
    implements ResourceDescriptor {
        private final ResourceDescriptionResolver descriptionResolver;
        private final Optional<ResourceOperationRuntimeHandler> runtimeHandler;
        private final Map<RuntimeCapability<?>, Predicate<ModelNode>> capabilities;
        private final Map<AttributeDefinition, OperationStepHandler> readWriteAttributes = new HashMap<AttributeDefinition, OperationStepHandler>();
        private final Iterable<? extends AttributeDefinition> readOnlyAttributes;
        private final Set<PathElement> requiredChildren;
        private final Set<PathElement> requiredSingletonChildren;
        private final Map<AttributeDefinition, AttributeTranslation> attributeTranslations;
        private final Set<ResourceCapabilityReferenceRecorder<?>> resourceCapabilityReferences;
        private final UnaryOperator<OperationStepHandler> addOperationTransformer;
        private final UnaryOperator<OperationStepHandler> operationTransformer;
        private final UnaryOperator<Resource> resourceTransformer;
        private final Optional<Consumer<DeploymentProcessorTarget>> deploymentChainContributor;
        private final OperationEntry.Flag addOperationRestartFlag;
        private final OperationEntry.Flag removeOperationRestartFlag;

        DefaultResourceDescriptor(AbstractConfigurator<?> builder) {
            Collection<AttributeDefinition> modelOnlyAttributes;
            this.descriptionResolver = builder.descriptionResolver;
            this.runtimeHandler = builder.runtimeHandler;
            this.capabilities = builder.capabilities;
            Collection<AttributeDefinition> attributes = builder.attributes;
            if (!attributes.isEmpty()) {
                WriteAttributeOperationStepHandler handler = new WriteAttributeOperationStepHandler(this);
                for (AttributeDefinition attribute : attributes) {
                    this.readWriteAttributes.put(attribute, (OperationStepHandler)handler);
                }
            }
            if (!(modelOnlyAttributes = builder.modelOnlyAttributes).isEmpty()) {
                OperationStepHandlerDescriptor descriptor = new OperationStepHandlerDescriptor(){

                    @Override
                    public Predicate<ModelNode> getCapabilityFilter(RuntimeCapability<?> capability) {
                        return this.getCapabilityFilter(capability);
                    }
                };
                WriteAttributeOperationStepHandler handler = new WriteAttributeOperationStepHandler(descriptor);
                for (AttributeDefinition attribute : modelOnlyAttributes) {
                    this.readWriteAttributes.put(attribute, (OperationStepHandler)handler);
                }
            }
            this.readWriteAttributes.putAll(builder.customAttributes);
            this.readOnlyAttributes = builder.readOnlyAttributes;
            this.attributeTranslations = builder.attributeTranslations;
            this.requiredChildren = builder.requiredChildren;
            this.requiredSingletonChildren = builder.requiredSingletonChildren;
            this.resourceCapabilityReferences = builder.resourceCapabilityReferences;
            this.addOperationTransformer = builder.addOperationTransformer;
            this.operationTransformer = builder.operationTransformer;
            this.resourceTransformer = builder.resourceTransformer;
            this.deploymentChainContributor = builder.deploymentChainContributor;
            this.addOperationRestartFlag = builder.addOperationRestartFlag;
            this.removeOperationRestartFlag = builder.removeOperationRestartFlag;
        }

        @Override
        public ResourceDescriptionResolver getResourceDescriptionResolver() {
            return this.descriptionResolver;
        }

        @Override
        public Optional<ResourceOperationRuntimeHandler> getRuntimeHandler() {
            return this.runtimeHandler;
        }

        @Override
        public Set<RuntimeCapability<?>> getCapabilities() {
            return this.capabilities.keySet();
        }

        @Override
        public Predicate<ModelNode> getCapabilityFilter(RuntimeCapability<?> capability) {
            return this.capabilities.getOrDefault(capability, model -> false);
        }

        @Override
        public Set<ResourceCapabilityReferenceRecorder<?>> getResourceCapabilityReferences() {
            return this.resourceCapabilityReferences;
        }

        @Override
        public UnaryOperator<OperationStepHandler> getResourceOperationTransformation() {
            return this.operationTransformer;
        }

        @Override
        public Iterable<AttributeDefinition> getAttributes() {
            return new CompositeIterable(new Iterable[]{this.attributeTranslations.keySet(), this.readWriteAttributes.keySet(), this.readOnlyAttributes});
        }

        @Override
        public AttributeTranslation getAttributeTranslation(AttributeDefinition attribute) {
            return this.attributeTranslations.get(attribute);
        }

        @Override
        public OperationStepHandler getWriteAttributeOperationStepHandler(AttributeDefinition attribute) {
            return this.readWriteAttributes.get(attribute);
        }

        @Override
        public Set<PathElement> getRequiredChildren() {
            return this.requiredChildren;
        }

        @Override
        public Set<PathElement> getRequiredSingletonChildren() {
            return this.requiredSingletonChildren;
        }

        @Override
        public UnaryOperator<OperationStepHandler> getAddOperationTransformation() {
            return this.addOperationTransformer;
        }

        @Override
        public UnaryOperator<Resource> getResourceTransformation() {
            return this.resourceTransformer;
        }

        @Override
        public Optional<Consumer<DeploymentProcessorTarget>> getDeploymentChainContributor() {
            return this.deploymentChainContributor;
        }

        @Override
        public OperationEntry.Flag getAddOperationRestartFlag() {
            return this.addOperationRestartFlag;
        }

        @Override
        public OperationEntry.Flag getRemoveOperationRestartFlag() {
            return this.removeOperationRestartFlag;
        }
    }
}

