/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.subsystem.service.capability;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.CapabilityServiceTarget;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.RequirementServiceBuilder;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.common.function.Functions;
import org.wildfly.service.AsyncServiceBuilder;
import org.wildfly.service.Installer;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capability.AsyncCapabilityServiceBuilder;

public interface CapabilityServiceInstaller
extends ResourceServiceInstaller,
Installer<CapabilityServiceTarget> {
    public static <V> Builder<V, V> builder(RuntimeCapability<Void> capability, V value) {
        return (Builder)CapabilityServiceInstaller.builder(capability, Functions.constantSupplier(value)).asActive();
    }

    public static <V> Builder<V, V> builder(RuntimeCapability<Void> capability, ServiceDependency<V> dependency) {
        return (Builder)((Builder)CapabilityServiceInstaller.builder(capability, dependency).withDependency((Consumer)((Object)dependency))).asPassive();
    }

    public static <V> Builder<V, V> builder(RuntimeCapability<Void> capability, Supplier<V> factory) {
        return CapabilityServiceInstaller.builder(capability, Function.identity(), factory);
    }

    public static <T, V> Builder<T, V> builder(RuntimeCapability<Void> capability, Function<T, V> mapper, Supplier<T> factory) {
        return new DefaultCapabilityServiceInstaller.Builder<T, V>(capability, mapper, factory);
    }

    @Override
    default public Consumer<OperationContext> install(OperationContext context) {
        final ServiceController controller = this.install((ServiceTarget)context.getCapabilityServiceTarget());
        return new Consumer<OperationContext>(){

            @Override
            public void accept(OperationContext context) {
                context.removeService(controller);
            }
        };
    }

    public static class DefaultCapabilityServiceInstaller<T, V>
    extends Installer.AbstractInstaller<CapabilityServiceTarget, CapabilityServiceBuilder<?>, RequirementServiceBuilder<?>, T, V>
    implements CapabilityServiceInstaller {
        private static final Function<CapabilityServiceTarget, CapabilityServiceBuilder<?>> FACTORY = CapabilityServiceTarget::addService;

        DefaultCapabilityServiceInstaller(Installer.Configuration<CapabilityServiceBuilder<?>, RequirementServiceBuilder<?>, T, V> config) {
            super(config, FACTORY);
        }

        static class Builder<T, V>
        extends Installer.AbstractInstaller.Builder<org.wildfly.subsystem.service.capability.CapabilityServiceInstaller$Builder<T, V>, CapabilityServiceInstaller, CapabilityServiceTarget, CapabilityServiceBuilder<?>, RequirementServiceBuilder<?>, T, V>
        implements org.wildfly.subsystem.service.capability.CapabilityServiceInstaller$Builder<T, V> {
            private final RuntimeCapability<Void> capability;
            private volatile boolean sync = true;
            private volatile AsyncServiceBuilder.Async async = AsyncServiceBuilder.Async.START_ONLY;

            Builder(RuntimeCapability<Void> capability, Function<T, V> mapper, Supplier<T> factory) {
                super(mapper, factory);
                this.capability = capability;
            }

            @Override
            public org.wildfly.subsystem.service.capability.CapabilityServiceInstaller$Builder<T, V> async() {
                this.sync = false;
                return this;
            }

            public Function<CapabilityServiceBuilder<?>, Consumer<V>> getProvider() {
                final RuntimeCapability<Void> capability = this.capability;
                final List names = this.getServiceNames();
                return new Function<CapabilityServiceBuilder<?>, Consumer<V>>(){

                    @Override
                    public Consumer<V> apply(CapabilityServiceBuilder<?> builder) {
                        return names.isEmpty() ? builder.provides(capability) : builder.provides(new RuntimeCapability[]{capability}, (ServiceName[])names.toArray(ServiceName[]::new));
                    }
                };
            }

            public org.wildfly.subsystem.service.capability.CapabilityServiceInstaller$Builder<T, V> onStop(Consumer<T> consumer) {
                this.async = AsyncServiceBuilder.Async.START_AND_STOP;
                return (org.wildfly.subsystem.service.capability.CapabilityServiceInstaller$Builder)super.onStop(consumer);
            }

            public UnaryOperator<CapabilityServiceBuilder<?>> getServiceBuilderDecorator() {
                final AsyncServiceBuilder.Async async = this.async;
                return this.sync ? UnaryOperator.identity() : new UnaryOperator<CapabilityServiceBuilder<?>>(){

                    @Override
                    public CapabilityServiceBuilder<?> apply(CapabilityServiceBuilder<?> builder) {
                        return new AsyncCapabilityServiceBuilder(builder, async);
                    }
                };
            }

            public CapabilityServiceInstaller build() {
                return new DefaultCapabilityServiceInstaller(this);
            }

            protected org.wildfly.subsystem.service.capability.CapabilityServiceInstaller$Builder<T, V> builder() {
                return this;
            }
        }
    }

    public static interface Builder<T, V>
    extends Installer.Builder<Builder<T, V>, CapabilityServiceInstaller, CapabilityServiceTarget, RequirementServiceBuilder<?>, T, V> {
        public Builder<T, V> async();
    }
}

