/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.se.idl.constExpr;

import com.sun.tools.corba.se.idl.Util;
import com.sun.tools.corba.se.idl.constExpr.BinaryExpr;
import com.sun.tools.corba.se.idl.constExpr.EvaluationException;
import com.sun.tools.corba.se.idl.constExpr.Expression;
import java.math.BigInteger;

public class Modulo
extends BinaryExpr {
    protected Modulo(Expression leftOperand, Expression rightOperand) {
        super("%", leftOperand, rightOperand);
    }

    @Override
    public Object evaluate() throws EvaluationException {
        try {
            Number l = (Number)this.left().evaluate();
            Number r = (Number)this.right().evaluate();
            if (l instanceof Float || l instanceof Double || r instanceof Float || r instanceof Double) {
                String[] parameters = new String[]{Util.getMessage("EvaluationException.mod"), this.left().value().getClass().getName(), this.right().value().getClass().getName()};
                throw new EvaluationException(Util.getMessage("EvaluationException.1", parameters));
            }
            BigInteger tmpL = (BigInteger)l;
            BigInteger tmpR = (BigInteger)r;
            this.value(tmpL.remainder(tmpR));
        }
        catch (ClassCastException e) {
            String[] parameters = new String[]{Util.getMessage("EvaluationException.mod"), this.left().value().getClass().getName(), this.right().value().getClass().getName()};
            throw new EvaluationException(Util.getMessage("EvaluationException.1", parameters));
        }
        return this.value();
    }
}

